/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.distributedclassloading.impl;

import com.hazelcast.config.DistributedClassloadingConfig;
import com.hazelcast.internal.distributedclassloading.impl.ClassData;
import com.hazelcast.internal.distributedclassloading.impl.ClassSource;
import com.hazelcast.logging.ILogger;
import java.util.concurrent.ConcurrentMap;

public final class ClassDataProvider {
    private final DistributedClassloadingConfig.ProviderMode providerMode;
    private final ClassLoader parent;
    private final ConcurrentMap<String, ClassSource> classSourceMap;
    private final ILogger logger;

    public ClassDataProvider(DistributedClassloadingConfig.ProviderMode providerMode, ClassLoader parent, ConcurrentMap<String, ClassSource> classSourceMap, ILogger logger) {
        this.providerMode = providerMode;
        this.parent = parent;
        this.classSourceMap = classSourceMap;
        this.logger = logger;
    }

    public ClassData getClassDataOrNull(String className) {
        if (this.providerMode == DistributedClassloadingConfig.ProviderMode.OFF) {
            return null;
        }
        ClassData classData = null;
        byte[] bytecode = this.loadBytecodeFromParent(className);
        if (bytecode == null && this.providerMode == DistributedClassloadingConfig.ProviderMode.LOCAL_AND_CACHED_CLASSES) {
            bytecode = this.loadBytecodeFromCache(className);
        }
        if (bytecode != null) {
            classData = new ClassData(bytecode);
        }
        return classData;
    }

    private byte[] loadBytecodeFromCache(String className) {
        ClassSource classSource = (ClassSource)this.classSourceMap.get(className);
        if (classSource == null) {
            return null;
        }
        return classSource.getBytecode();
    }

    /*
     * Exception decompiling
     */
    private byte[] loadBytecodeFromParent(String className) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

