/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.distributedclassloading.impl;

import com.hazelcast.config.DistributedClassloadingConfig;
import com.hazelcast.core.Member;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.distributedclassloading.impl.ClassData;
import com.hazelcast.internal.distributedclassloading.impl.ClassSource;
import com.hazelcast.internal.distributedclassloading.impl.ClassloadingMutexProvider;
import com.hazelcast.internal.distributedclassloading.impl.ThreadLocalClassCache;
import com.hazelcast.internal.distributedclassloading.impl.operation.ClassDataFinderOperation;
import com.hazelcast.internal.util.filter.Filter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import java.io.Closeable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;

public final class ClassLocator {
    private final ConcurrentMap<String, ClassSource> classSourceMap;
    private final ClassLoader parent;
    private final Filter<String> classNameFilter;
    private final Filter<Member> memberFilter;
    private final DistributedClassloadingConfig.ClassCacheMode classCacheMode;
    private final NodeEngine nodeEngine;
    private final ClassloadingMutexProvider mutexFactory = new ClassloadingMutexProvider();
    private final ILogger logger;

    public ClassLocator(ConcurrentMap<String, ClassSource> classSourceMap, ClassLoader parent, Filter<String> classNameFilter, Filter<Member> memberFilter, DistributedClassloadingConfig.ClassCacheMode classCacheMode, NodeEngine nodeEngine) {
        this.classSourceMap = classSourceMap;
        this.parent = parent;
        this.classNameFilter = classNameFilter;
        this.memberFilter = memberFilter;
        this.classCacheMode = classCacheMode;
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(ClassLocator.class);
    }

    public static void onStartDeserialization() {
        ThreadLocalClassCache.onStartDeserialization();
    }

    public static void onFinishDeserialization() {
        ThreadLocalClassCache.onFinishDeserialization();
    }

    public Class<?> handleClassNotFoundException(String name) throws ClassNotFoundException {
        if (!this.classNameFilter.accept(name)) {
            throw new ClassNotFoundException("Class " + name + " is not allowed to be loaded from other members.");
        }
        Class<?> clazz = this.tryToGetClassFromLocalCache(name);
        if (clazz != null) {
            return clazz;
        }
        return this.tryToGetClassFromRemote(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Class<?> tryToGetClassFromRemote(String name) throws ClassNotFoundException {
        Closeable classMutex;
        block8: {
            Class clazz;
            classMutex = this.mutexFactory.getMutexForClass(name);
            try {
                Closeable closeable = classMutex;
                // MONITORENTER : closeable
                ClassSource classSource = (ClassSource)this.classSourceMap.get(name);
                if (classSource == null) break block8;
                if (this.logger.isFineEnabled()) {
                    this.logger.finest("Class " + name + " is already in a local cache. ");
                }
                clazz = classSource.getClazz();
                // MONITOREXIT : closeable
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(classMutex);
                throw throwable;
            }
            IOUtil.closeResource(classMutex);
            return clazz;
        }
        byte[] classDef = this.fetchBytecodeFromRemote(name);
        if (classDef == null) {
            throw new ClassNotFoundException("Failed to load class " + name + " from other members.");
        }
        Class<?> clazz = this.defineAndCacheClass(name, classDef);
        // MONITOREXIT : closeable
        IOUtil.closeResource(classMutex);
        return clazz;
    }

    private Class<?> tryToGetClassFromLocalCache(String name) {
        ClassSource classSource = (ClassSource)this.classSourceMap.get(name);
        if (classSource != null) {
            if (this.logger.isFineEnabled()) {
                this.logger.finest("Class " + name + " is already in a local cache. ");
            }
            return classSource.getClazz();
        }
        classSource = ThreadLocalClassCache.getFromCache(name);
        if (classSource != null) {
            return classSource.getClazz();
        }
        return null;
    }

    private Class<?> defineAndCacheClass(String name, byte[] classDef) {
        ClassSource classSource = new ClassSource(name, classDef, this.parent, this);
        classSource.define();
        if (this.classCacheMode != DistributedClassloadingConfig.ClassCacheMode.OFF) {
            this.classSourceMap.put(name, classSource);
        } else {
            ThreadLocalClassCache.store(name, classSource);
        }
        return classSource.getClazz();
    }

    private byte[] fetchBytecodeFromRemote(String className) {
        ClusterService cluster = this.nodeEngine.getClusterService();
        boolean interrupted = false;
        for (Member member : cluster.getMembers()) {
            if (this.isCandidateMember(member)) continue;
            try {
                byte[] classDef;
                ClassData classData = this.tryToFetchClassDataFromMember(className, member);
                if (classData == null) continue;
                if (this.logger.isFineEnabled()) {
                    this.logger.finest("Loaded class " + className + " from " + member);
                }
                if ((classDef = classData.getClassDefinition()) == null) continue;
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                return classDef;
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            catch (Exception e) {
                if (!this.logger.isFinestEnabled()) continue;
                this.logger.finest("Unable to get class data for class " + className + " from member " + member, e);
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return null;
    }

    private ClassData tryToFetchClassDataFromMember(String className, Member member) throws ExecutionException, InterruptedException {
        OperationService operationService = this.nodeEngine.getOperationService();
        ClassDataFinderOperation op = new ClassDataFinderOperation(className);
        InternalCompletableFuture classDataFuture = operationService.invokeOnTarget("distributed-classloading-service", op, member.getAddress());
        return (ClassData)classDataFuture.get();
    }

    private boolean isCandidateMember(Member member) {
        if (member.localMember()) {
            return true;
        }
        return !this.memberFilter.accept(member);
    }

    public Class<?> findLoadedClass(String name) {
        ClassSource classSource = (ClassSource)this.classSourceMap.get(name);
        if (classSource == null) {
            return null;
        }
        return classSource.getClazz();
    }
}

