/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.distributedclassloading.impl;

import com.hazelcast.internal.distributedclassloading.impl.GlobalMutex;
import com.hazelcast.util.ContextMutexFactory;
import java.io.Closeable;

public class ClassloadingMutexProvider {
    private static final String JAVA_VERSION_WHERE_PARALLEL_CLASSLOADING_IS_NOT_POSSIBLE = "1.6";
    private static final boolean USE_PARALLEL_LOADING = ClassloadingMutexProvider.isParallelClassLoadingPossible();
    private final ContextMutexFactory mutexFactory = new ContextMutexFactory();
    private final GlobalMutex globalMutex = new GlobalMutex();

    public Closeable getMutexForClass(String classname) {
        if (USE_PARALLEL_LOADING) {
            return this.mutexFactory.mutexFor(classname);
        }
        return this.globalMutex;
    }

    private static boolean isParallelClassLoadingPossible() {
        String implVersion = Runtime.class.getPackage().getImplementationVersion();
        return !implVersion.startsWith(JAVA_VERSION_WHERE_PARALLEL_CLASSLOADING_IS_NOT_POSSIBLE);
    }
}

