/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.distributedclassloading.impl.operation;

import com.hazelcast.internal.distributedclassloading.DistributedClassloadingService;
import com.hazelcast.internal.distributedclassloading.impl.ClassData;
import com.hazelcast.internal.distributedclassloading.impl.ClassloadingSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.UrgentSystemOperation;
import java.io.IOException;

public final class ClassDataFinderOperation
extends Operation
implements UrgentSystemOperation,
IdentifiedDataSerializable {
    private String className;
    private ClassData response;

    public ClassDataFinderOperation(String className) {
        this.className = className;
    }

    public ClassDataFinderOperation() {
    }

    @Override
    public ClassData getResponse() {
        return this.response;
    }

    @Override
    public void run() throws Exception {
        DistributedClassloadingService service = (DistributedClassloadingService)this.getService();
        this.response = service.getClassDataOrNull(this.className);
    }

    @Override
    public String getServiceName() {
        return "distributed-classloading-service";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.className);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.className = in.readUTF();
    }

    @Override
    public int getFactoryId() {
        return ClassloadingSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 1;
    }
}

