/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache.impl.invalidation;

import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.InternalCompletableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;

public abstract class MetaDataFetcher {
    protected final ILogger logger;

    public MetaDataFetcher(ILogger logger) {
        this.logger = logger;
    }

    protected abstract List<InternalCompletableFuture> scanMembers(List<String> var1);

    protected abstract void process(InternalCompletableFuture var1, ConcurrentMap<String, RepairingHandler> var2);

    protected abstract List<Object> assignAndGetUuids() throws Exception;

    public final void fetchMetadata(ConcurrentMap<String, RepairingHandler> handlers) {
        if (handlers.isEmpty()) {
            return;
        }
        List<String> mapNames = this.getNames(handlers);
        List<InternalCompletableFuture> futures = this.scanMembers(mapNames);
        for (InternalCompletableFuture future : futures) {
            this.process(future, handlers);
        }
    }

    private List<String> getNames(ConcurrentMap<String, RepairingHandler> handlers) {
        ArrayList<String> names = new ArrayList<String>(handlers.size());
        for (RepairingHandler handler : handlers.values()) {
            names.add(handler.getName());
        }
        return names;
    }

    protected void repairUuids(List<Object> uuids, ConcurrentMap<String, RepairingHandler> handlers) {
        int i = 0;
        while (i < uuids.size()) {
            int partitionId = (Integer)uuids.get(i++);
            long mostSigBits = (Long)uuids.get(i++);
            long leastSigBits = (Long)uuids.get(i++);
            for (RepairingHandler handler : handlers.values()) {
                handler.checkOrRepairUuid(partitionId, new UUID(mostSigBits, leastSigBits));
            }
        }
    }

    protected void repairSequences(List<Object> namePartitionSequenceList, ConcurrentMap<String, RepairingHandler> handlers) {
        String name = null;
        int i = 0;
        while (i < namePartitionSequenceList.size()) {
            Object item;
            if ((item = namePartitionSequenceList.get(i++)) instanceof String) {
                name = (String)item;
                continue;
            }
            int partitionId = (Integer)item;
            long nextSequence = (Long)namePartitionSequenceList.get(i++);
            RepairingHandler repairingHandler = (RepairingHandler)handlers.get(name);
            repairingHandler.checkOrRepairSequence(partitionId, nextSequence, true);
        }
    }
}

