/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache.impl.preloader;

import com.hazelcast.config.NearCachePreloaderConfig;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.nearcache.NearCacheRecord;
import com.hazelcast.internal.nearcache.impl.NearCacheRecordMap;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.util.BufferingInputStream;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.memory.MemoryUnit;
import com.hazelcast.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.nio.Bits;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.StringUtil;
import com.hazelcast.util.collection.InflatableSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class NearCachePreloader<KS> {
    private static final int MAGIC_BYTES = -365122482;
    private static final int LOG_OF_BUFFER_SIZE = 16;
    private static final int BUFFER_SIZE = 65536;
    private static final int LOAD_BATCH_SIZE = 100;
    private final ILogger logger = Logger.getLogger(NearCachePreloader.class);
    private final ByteBuffer buf = ByteBuffer.allocate(65536);
    private final byte[] tmpBytes = new byte[4];
    private final String nearCacheName;
    private final NearCacheStatsImpl nearCacheStats;
    private final SerializationService serializationService;
    private final File storeFile;
    private final File tmpStoreFile;
    private int lastWrittenBytes;
    private int lastKeyCount;

    public NearCachePreloader(String nearCacheName, NearCachePreloaderConfig preloaderConfig, NearCacheStatsImpl nearCacheStats, SerializationService serializationService) {
        this.nearCacheName = nearCacheName;
        this.nearCacheStats = nearCacheStats;
        this.serializationService = serializationService;
        String fileName = NearCachePreloader.getFileName(preloaderConfig.getFileName(), nearCacheName);
        this.storeFile = new File(fileName);
        this.tmpStoreFile = new File(fileName + "~");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadKeys(DataStructureAdapter<Data, ?> adapter) {
        BufferingInputStream bis;
        long startedNanos;
        block5: {
            startedNanos = System.nanoTime();
            bis = null;
            bis = new BufferingInputStream(new FileInputStream(this.storeFile), 65536);
            if (this.checkHeader(bis)) break block5;
            IOUtil.closeResource(bis);
            return;
        }
        try {
            int loadedKeys = this.loadKeySet(bis, adapter);
            long elapsedMillis = NearCachePreloader.getElapsedMillis(startedNanos);
            this.logger.info(String.format("Loaded %d keys of Near Cache %s in %d ms", loadedKeys, this.nearCacheName, elapsedMillis));
        }
        catch (Exception e) {
            try {
                this.logger.warning(String.format("Could not pre-load Near Cache %s (%s): [%s] %s", this.nearCacheName, this.storeFile.getAbsolutePath(), e.getClass().getSimpleName(), e.getMessage()));
            }
            catch (Throwable throwable) {
                IOUtil.closeResource(bis);
                throw throwable;
            }
            IOUtil.closeResource(bis);
        }
        IOUtil.closeResource(bis);
    }

    private boolean checkHeader(BufferingInputStream bis) throws IOException {
        int magicBytes = this.readInt(bis);
        if (magicBytes != -365122482) {
            this.logger.warning(String.format("Found invalid header for Near Cache %s (%s)", this.nearCacheName, this.storeFile.getAbsolutePath()));
            return false;
        }
        int fileFormat = this.readInt(bis);
        if (fileFormat < 0 || fileFormat > FileFormat.values().length - 1) {
            this.logger.warning(String.format("Found invalid file format for Near Cache %s (%s)", this.nearCacheName, this.storeFile.getAbsolutePath()));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends NearCacheRecord, NCRM extends NearCacheRecordMap<KS, R>> void storeKeys(NCRM ... records) {
        FileOutputStream fos;
        long startedNanos;
        block6: {
            startedNanos = System.nanoTime();
            fos = null;
            this.lastWrittenBytes = 0;
            this.lastKeyCount = 0;
            fos = new FileOutputStream(this.tmpStoreFile, false);
            this.writeInt(fos, -365122482);
            this.writeInt(fos, FileFormat.INTERLEAVED_LENGTH_FIELD.ordinal());
            for (NCRM record : records) {
                this.writeKeySet(fos, fos.getChannel(), record.keySet());
            }
            if (this.lastKeyCount != 0) break block6;
            IOUtil.deleteQuietly(this.storeFile);
            this.updatePersistenceStats(startedNanos);
            IOUtil.deleteQuietly(this.tmpStoreFile);
            IOUtil.closeResource(fos);
            return;
        }
        try {
            fos.flush();
            IOUtil.rename(this.tmpStoreFile, this.storeFile);
            this.updatePersistenceStats(startedNanos);
        }
        catch (Exception e) {
            try {
                this.logger.warning(String.format("Could not store keys of Near Cache %s (%s): [%s] %s", this.nearCacheName, this.storeFile.getAbsolutePath(), e.getClass().getSimpleName(), e.getMessage()));
            }
            catch (Throwable throwable) {
                IOUtil.deleteQuietly(this.tmpStoreFile);
                IOUtil.closeResource(fos);
                throw throwable;
            }
            IOUtil.deleteQuietly(this.tmpStoreFile);
            IOUtil.closeResource(fos);
        }
        IOUtil.deleteQuietly(this.tmpStoreFile);
        IOUtil.closeResource(fos);
    }

    private void updatePersistenceStats(long startedNanos) {
        long elapsedMillis = NearCachePreloader.getElapsedMillis(startedNanos);
        this.nearCacheStats.addPersistence(elapsedMillis, this.lastWrittenBytes, this.lastKeyCount);
        this.logger.info(String.format("Stored %d keys of Near Cache %s in %d ms (%d kB)", this.lastKeyCount, this.nearCacheName, elapsedMillis, MemoryUnit.BYTES.toKiloBytes(this.lastWrittenBytes)));
    }

    private int loadKeySet(BufferingInputStream bis, DataStructureAdapter<Data, ?> adapter) throws IOException {
        int dataSize;
        byte[] payload;
        int loadedKeys = 0;
        InflatableSet.Builder<HeapData> builder = InflatableSet.newBuilder(100);
        while (IOUtil.readFullyOrNothing(bis, this.tmpBytes) && IOUtil.readFullyOrNothing(bis, payload = new byte[dataSize = Bits.readIntB(this.tmpBytes, 0)])) {
            builder.add(new HeapData(payload));
            if (builder.size() == 100) {
                adapter.getAll(builder.build());
                builder = InflatableSet.newBuilder(100);
            }
            ++loadedKeys;
        }
        if (builder.size() > 0) {
            adapter.getAll(builder.build());
        }
        return loadedKeys;
    }

    private void writeKeySet(FileOutputStream fos, FileChannel outChannel, Set<KS> keySet) throws IOException {
        for (KS key : keySet) {
            Object dataKey = this.serializationService.toData(key);
            if (dataKey != null) {
                int transferredCount;
                int dataSize = dataKey.totalSize();
                this.writeInt(fos, dataSize);
                int position = 0;
                for (int remaining = dataSize; remaining > 0; remaining -= transferredCount) {
                    transferredCount = Math.min(65536 - this.buf.position(), remaining);
                    this.ensureBufHasRoom(fos, transferredCount);
                    this.buf.put(dataKey.toByteArray(), position, transferredCount);
                    position += transferredCount;
                }
                this.lastWrittenBytes += 4 + dataSize;
                ++this.lastKeyCount;
            }
            this.flushLocalBuffer(outChannel);
        }
    }

    private int readInt(BufferingInputStream bis) throws IOException {
        IOUtil.readFullyOrNothing(bis, this.tmpBytes);
        return Bits.readIntB(this.tmpBytes, 0);
    }

    private void writeInt(FileOutputStream fos, int dataSize) throws IOException {
        this.ensureBufHasRoom(fos, 4);
        Bits.writeIntB(this.tmpBytes, 0, dataSize);
        this.buf.put(this.tmpBytes);
    }

    private void ensureBufHasRoom(FileOutputStream fos, int expectedSize) throws IOException {
        if (this.buf.position() < 65536 - expectedSize) {
            return;
        }
        fos.write(this.buf.array());
        this.buf.position(0);
    }

    private void flushLocalBuffer(FileChannel outChannel) throws IOException {
        if (this.buf.position() == 0) {
            return;
        }
        this.buf.flip();
        while (this.buf.hasRemaining()) {
            outChannel.write(this.buf);
        }
        this.buf.clear();
    }

    private static String getFileName(String configFileName, String nearCacheName) {
        if (!StringUtil.isNullOrEmpty(configFileName)) {
            return configFileName;
        }
        return "nearcache-" + IOUtil.toFileName(nearCacheName) + ".store";
    }

    private static long getElapsedMillis(long startedNanos) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startedNanos);
    }

    private static enum FileFormat {
        INTERLEAVED_LENGTH_FIELD;

    }
}

