/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.core.MigrationEvent;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.PartitionRuntimeState;
import com.hazelcast.internal.partition.PartitionStateVersionMismatchException;
import com.hazelcast.internal.partition.impl.InternalMigrationListener;
import com.hazelcast.internal.partition.impl.InternalPartitionImpl;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.MigrationPlanner;
import com.hazelcast.internal.partition.impl.MigrationQueue;
import com.hazelcast.internal.partition.impl.MigrationRunnable;
import com.hazelcast.internal.partition.impl.MigrationThread;
import com.hazelcast.internal.partition.impl.PartitionEventManager;
import com.hazelcast.internal.partition.impl.PartitionStateManager;
import com.hazelcast.internal.partition.operation.FinalizeMigrationOperation;
import com.hazelcast.internal.partition.operation.MigrationCommitOperation;
import com.hazelcast.internal.partition.operation.MigrationRequestOperation;
import com.hazelcast.internal.partition.operation.PromotionCommitOperation;
import com.hazelcast.internal.partition.operation.ShutdownResponseOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.executionservice.InternalExecutionService;
import com.hazelcast.spi.partition.MigrationEndpoint;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.util.Clock;
import com.hazelcast.util.MutableInteger;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.scheduler.CoalescingDelayedTrigger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;

public class MigrationManager {
    private static final boolean ASSERTION_ENABLED = MigrationManager.class.desiredAssertionStatus();
    private static final int PARTITION_STATE_VERSION_INCREMENT_DELTA_ON_MIGRATION_FAILURE = 2;
    private static final int MIGRATION_PAUSE_DURATION_SECONDS_ON_MIGRATION_FAILURE = 3;
    private static final String INVALID_UUID = "<invalid-uuid>";
    final long partitionMigrationInterval;
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final InternalPartitionServiceImpl partitionService;
    private final ILogger logger;
    private final PartitionStateManager partitionStateManager;
    private final MigrationQueue migrationQueue = new MigrationQueue();
    private final MigrationThread migrationThread;
    private final AtomicBoolean migrationAllowed = new AtomicBoolean(true);
    @Probe(name="lastRepartitionTime")
    private final AtomicLong lastRepartitionTime = new AtomicLong();
    private final long partitionMigrationTimeout;
    private final CoalescingDelayedTrigger delayedResumeMigrationTrigger;
    private final Set<Address> shutdownRequestedAddresses = new HashSet<Address>();
    private volatile MigrationInfo activeMigrationInfo;
    private final LinkedHashSet<MigrationInfo> completedMigrations = new LinkedHashSet();
    @Probe
    private final AtomicLong completedMigrationCounter = new AtomicLong();
    private volatile InternalMigrationListener internalMigrationListener = new InternalMigrationListener.NopInternalMigrationListener();
    private final Lock partitionServiceLock;
    private final MigrationPlanner migrationPlanner;

    MigrationManager(Node node, InternalPartitionServiceImpl service, Lock partitionServiceLock) {
        this.node = node;
        this.nodeEngine = node.nodeEngine;
        this.partitionService = service;
        this.logger = node.getLogger(this.getClass());
        this.partitionServiceLock = partitionServiceLock;
        this.migrationPlanner = new MigrationPlanner(node.getLogger(MigrationPlanner.class));
        HazelcastProperties properties = node.getProperties();
        long intervalMillis = properties.getMillis(GroupProperty.PARTITION_MIGRATION_INTERVAL);
        this.partitionMigrationInterval = intervalMillis > 0L ? intervalMillis : 0L;
        this.partitionMigrationTimeout = properties.getMillis(GroupProperty.PARTITION_MIGRATION_TIMEOUT);
        this.partitionStateManager = this.partitionService.getPartitionStateManager();
        ILogger migrationThreadLogger = node.getLogger(MigrationThread.class);
        this.migrationThread = new MigrationThread(this, node.getHazelcastThreadGroup(), migrationThreadLogger, this.migrationQueue);
        long migrationPauseDelayMs = TimeUnit.SECONDS.toMillis(3L);
        InternalExecutionService executionService = this.nodeEngine.getExecutionService();
        this.delayedResumeMigrationTrigger = new CoalescingDelayedTrigger(executionService, migrationPauseDelayMs, 2L * migrationPauseDelayMs, new Runnable(){

            @Override
            public void run() {
                MigrationManager.this.resumeMigration();
            }
        });
    }

    @Probe(name="migrationActive")
    private int migrationActiveProbe() {
        return this.migrationAllowed.get() ? 1 : 0;
    }

    void pauseMigration() {
        this.migrationAllowed.set(false);
    }

    void resumeMigration() {
        this.migrationAllowed.set(true);
    }

    private void resumeMigrationEventually() {
        this.delayedResumeMigrationTrigger.executeWithDelay();
    }

    boolean isMigrationAllowed() {
        return this.migrationAllowed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeMigration(MigrationInfo migrationInfo) {
        try {
            Address thisAddress = this.node.getThisAddress();
            int partitionId = migrationInfo.getPartitionId();
            boolean source = thisAddress.equals(migrationInfo.getSource());
            boolean destination = thisAddress.equals(migrationInfo.getDestination());
            assert (migrationInfo.getStatus() == MigrationInfo.MigrationStatus.SUCCESS || migrationInfo.getStatus() == MigrationInfo.MigrationStatus.FAILED) : "Invalid migration: " + migrationInfo;
            if (source || destination) {
                InternalMigrationListener.MigrationParticipant participant;
                boolean success = migrationInfo.getStatus() == MigrationInfo.MigrationStatus.SUCCESS;
                InternalMigrationListener.MigrationParticipant migrationParticipant = participant = source ? InternalMigrationListener.MigrationParticipant.SOURCE : InternalMigrationListener.MigrationParticipant.DESTINATION;
                if (success) {
                    this.internalMigrationListener.onMigrationCommit(participant, migrationInfo);
                } else {
                    this.internalMigrationListener.onMigrationRollback(participant, migrationInfo);
                }
                MigrationEndpoint endpoint = source ? MigrationEndpoint.SOURCE : MigrationEndpoint.DESTINATION;
                FinalizeMigrationOperation op = new FinalizeMigrationOperation(migrationInfo, endpoint, success);
                op.setPartitionId(partitionId).setNodeEngine(this.nodeEngine).setValidateTarget(false).setService(this.partitionService);
                this.nodeEngine.getOperationService().execute(op);
                this.removeActiveMigration(partitionId);
            } else {
                Address partitionOwner = this.partitionStateManager.getPartitionImpl(partitionId).getOwnerOrNull();
                if (this.node.getThisAddress().equals(partitionOwner)) {
                    this.removeActiveMigration(partitionId);
                    this.partitionStateManager.clearMigratingFlag(partitionId);
                } else {
                    this.logger.severe("Failed to finalize migration because this member " + thisAddress + " is not a participant of the migration: " + migrationInfo);
                }
            }
        }
        catch (Exception e) {
            this.logger.warning(e);
        }
        finally {
            migrationInfo.doneProcessing();
        }
    }

    public MigrationInfo setActiveMigration(MigrationInfo migrationInfo) {
        this.partitionServiceLock.lock();
        try {
            if (this.activeMigrationInfo == null) {
                this.activeMigrationInfo = migrationInfo;
                MigrationInfo migrationInfo2 = null;
                return migrationInfo2;
            }
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Active migration is not set: " + migrationInfo + ". Existing active migration: " + this.activeMigrationInfo + "\n");
            }
            MigrationInfo migrationInfo3 = this.activeMigrationInfo;
            return migrationInfo3;
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    MigrationInfo getActiveMigration() {
        return this.activeMigrationInfo;
    }

    private boolean removeActiveMigration(int partitionId) {
        this.partitionServiceLock.lock();
        try {
            if (this.activeMigrationInfo != null) {
                if (this.activeMigrationInfo.getPartitionId() == partitionId) {
                    this.activeMigrationInfo = null;
                    boolean bl = true;
                    return bl;
                }
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Active migration is not removed, because it has different partitionId! partitionId=" + partitionId + ", active migration=" + this.activeMigrationInfo);
                }
            }
        }
        finally {
            this.partitionServiceLock.unlock();
        }
        return false;
    }

    void scheduleActiveMigrationFinalization(final MigrationInfo migrationInfo) {
        this.partitionServiceLock.lock();
        try {
            MigrationInfo activeMigrationInfo = this.activeMigrationInfo;
            if (activeMigrationInfo != null && migrationInfo.equals(activeMigrationInfo)) {
                if (activeMigrationInfo.startProcessing()) {
                    activeMigrationInfo.setStatus(migrationInfo.getStatus());
                    this.finalizeMigration(activeMigrationInfo);
                } else {
                    this.logger.info("Scheduling finalization of " + migrationInfo + ", because migration process is currently running.");
                    this.nodeEngine.getExecutionService().schedule(new Runnable(){

                        @Override
                        public void run() {
                            MigrationManager.this.scheduleActiveMigrationFinalization(migrationInfo);
                        }
                    }, 3L, TimeUnit.SECONDS);
                }
                return;
            }
            if (migrationInfo.getSourceCurrentReplicaIndex() > 0 && this.node.getThisAddress().equals(migrationInfo.getSource())) {
                this.finalizeMigration(migrationInfo);
                return;
            }
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    private boolean commitMigrationToDestination(Address destination, MigrationInfo migration) {
        assert (migration != null) : "No migrations to commit! destination=" + destination;
        if (this.node.getThisAddress().equals(destination)) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Shortcutting migration commit, since destination is master. -> " + migration);
            }
            return true;
        }
        MemberImpl member = this.node.getClusterService().getMember(destination);
        if (member == null) {
            this.logger.warning("Destination " + destination + " is not member anymore");
            return false;
        }
        try {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Sending commit operation to " + destination + " for " + migration);
            }
            PartitionRuntimeState partitionState = this.partitionService.createMigrationCommitPartitionState(migration);
            String destinationUuid = member.getUuid();
            MigrationCommitOperation operation = new MigrationCommitOperation(partitionState, destinationUuid);
            InternalCompletableFuture future = this.nodeEngine.getOperationService().createInvocationBuilder("hz:core:partitionService", (Operation)operation, destination).setTryCount(Integer.MAX_VALUE).setCallTimeout(Long.MAX_VALUE).invoke();
            boolean result = (Boolean)future.get();
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Migration commit result " + result + " from " + destination + " for " + migration);
            }
            return result;
        }
        catch (Throwable t) {
            this.logMigrationCommitFailure(destination, migration, t);
            return false;
        }
    }

    private void logMigrationCommitFailure(Address destination, MigrationInfo migration, Throwable t) {
        boolean memberLeft;
        boolean bl = memberLeft = t instanceof MemberLeftException || t.getCause() instanceof TargetNotMemberException || t.getCause() instanceof HazelcastInstanceNotActiveException;
        if (memberLeft) {
            if (this.node.getThisAddress().equals(destination)) {
                this.logger.fine("Migration commit failed for " + migration + " since this node is shutting down.");
                return;
            }
            this.logger.warning("Migration commit failed for " + migration + " since destination " + destination + " left the cluster");
        } else {
            this.logger.severe("Migration commit to " + destination + " failed for " + migration, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addCompletedMigration(MigrationInfo migrationInfo) {
        if (migrationInfo.getStatus() != MigrationInfo.MigrationStatus.SUCCESS && migrationInfo.getStatus() != MigrationInfo.MigrationStatus.FAILED) {
            throw new IllegalArgumentException("Migration doesn't seem completed: " + migrationInfo);
        }
        this.partitionServiceLock.lock();
        try {
            boolean added = this.completedMigrations.add(migrationInfo);
            if (added) {
                this.completedMigrationCounter.incrementAndGet();
            }
            boolean bl = added;
            return bl;
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    void retainCompletedMigrations(Collection<MigrationInfo> migrations) {
        this.partitionServiceLock.lock();
        try {
            this.completedMigrations.retainAll(migrations);
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictCompletedMigrations(MigrationInfo currentMigration) {
        this.partitionServiceLock.lock();
        try {
            assert (this.completedMigrations.contains(currentMigration)) : currentMigration + " to evict is not in completed migrations";
            Iterator iter = this.completedMigrations.iterator();
            while (iter.hasNext()) {
                MigrationInfo migration = (MigrationInfo)iter.next();
                iter.remove();
                if (!migration.equals(currentMigration)) continue;
                return;
            }
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    void triggerControlTask() {
        this.migrationQueue.clear();
        if (!this.node.joined()) {
            this.logger.fine("Node is not joined, will not trigger ControlTask");
            return;
        }
        this.migrationQueue.add(new ControlTask());
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Migration queue is cleared and control task is scheduled");
        }
    }

    InternalMigrationListener getInternalMigrationListener() {
        return this.internalMigrationListener;
    }

    void setInternalMigrationListener(InternalMigrationListener listener) {
        Preconditions.checkNotNull(listener);
        this.internalMigrationListener = listener;
    }

    void resetInternalMigrationListener() {
        this.internalMigrationListener = new InternalMigrationListener.NopInternalMigrationListener();
    }

    void onShutdownRequest(Address address) {
        if (!this.partitionStateManager.isInitialized()) {
            this.sendShutdownOperation(address);
            return;
        }
        ClusterState clusterState = this.node.getClusterService().getClusterState();
        if (clusterState == ClusterState.FROZEN || clusterState == ClusterState.PASSIVE) {
            this.sendShutdownOperation(address);
            return;
        }
        if (this.shutdownRequestedAddresses.add(address)) {
            this.logger.info("Shutdown request of " + address + " is handled");
            this.triggerControlTask();
        }
    }

    void onMemberRemove(MemberImpl member) {
        Address deadAddress = member.getAddress();
        this.shutdownRequestedAddresses.remove(deadAddress);
        MigrationInfo activeMigration = this.activeMigrationInfo;
        if (activeMigration != null && (deadAddress.equals(activeMigration.getSource()) || deadAddress.equals(activeMigration.getDestination()))) {
            activeMigration.setStatus(MigrationInfo.MigrationStatus.INVALID);
        }
    }

    void schedule(MigrationRunnable runnable) {
        this.migrationQueue.add(runnable);
    }

    List<MigrationInfo> getCompletedMigrationsCopy() {
        this.partitionServiceLock.lock();
        try {
            ArrayList<MigrationInfo> arrayList = new ArrayList<MigrationInfo>(this.completedMigrations);
            return arrayList;
        }
        finally {
            this.partitionServiceLock.unlock();
        }
    }

    boolean hasOnGoingMigration() {
        return this.activeMigrationInfo != null || this.migrationQueue.hasMigrationTasks();
    }

    int getMigrationQueueSize() {
        return this.migrationQueue.migrationTaskCount();
    }

    void reset() {
        this.migrationQueue.clear();
        this.activeMigrationInfo = null;
        this.completedMigrations.clear();
    }

    void start() {
        this.migrationThread.start();
    }

    void stop() {
        this.migrationThread.stopNow();
    }

    void scheduleMigration(MigrationInfo migrationInfo) {
        this.migrationQueue.add(new MigrateTask(migrationInfo));
    }

    void applyMigration(InternalPartitionImpl partition, MigrationInfo migrationInfo) {
        Address[] addresses = Arrays.copyOf(partition.getReplicaAddresses(), 7);
        if (migrationInfo.getSourceCurrentReplicaIndex() > -1) {
            addresses[migrationInfo.getSourceCurrentReplicaIndex()] = null;
        }
        if (migrationInfo.getDestinationCurrentReplicaIndex() > -1) {
            addresses[migrationInfo.getDestinationCurrentReplicaIndex()] = null;
        }
        addresses[migrationInfo.getDestinationNewReplicaIndex()] = migrationInfo.getDestination();
        if (migrationInfo.getSourceNewReplicaIndex() > -1) {
            addresses[migrationInfo.getSourceNewReplicaIndex()] = migrationInfo.getSource();
        }
        partition.setReplicaAddresses(addresses);
    }

    Set<Address> getShutdownRequestedAddresses() {
        return this.shutdownRequestedAddresses;
    }

    private void sendShutdownOperation(Address address) {
        if (this.node.getThisAddress().equals(address)) {
            assert (!this.node.isRunning()) : "Node state: " + (Object)((Object)this.node.getState());
            this.partitionService.onShutdownResponse();
        } else {
            this.nodeEngine.getOperationService().send(new ShutdownResponseOperation(), address);
        }
    }

    MigrationRunnable getActiveTask() {
        return this.migrationThread.getActiveTask();
    }

    private String getMemberUuid(Address address) {
        MemberImpl member = this.node.getClusterService().getMember(address);
        return member != null ? member.getUuid() : INVALID_UUID;
    }

    private class ProcessShutdownRequestsTask
    implements MigrationRunnable {
        private ProcessShutdownRequestsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!MigrationManager.this.node.isMaster()) {
                return;
            }
            MigrationManager.this.partitionServiceLock.lock();
            try {
                int shutdownRequestCount = MigrationManager.this.shutdownRequestedAddresses.size();
                if (shutdownRequestCount > 0) {
                    if (shutdownRequestCount == MigrationManager.this.nodeEngine.getClusterService().getSize(MemberSelectors.DATA_MEMBER_SELECTOR)) {
                        for (Address address : MigrationManager.this.shutdownRequestedAddresses) {
                            MigrationManager.this.sendShutdownOperation(address);
                        }
                    } else {
                        boolean present = false;
                        for (Address address : MigrationManager.this.shutdownRequestedAddresses) {
                            if (MigrationManager.this.partitionStateManager.isAbsentInPartitionTable(address)) {
                                MigrationManager.this.sendShutdownOperation(address);
                                continue;
                            }
                            MigrationManager.this.logger.warning(address + " requested to shutdown but still in partition table");
                            present = true;
                        }
                        if (present) {
                            MigrationManager.this.triggerControlTask();
                        }
                    }
                }
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }
    }

    private class ControlTask
    implements MigrationRunnable {
        private ControlTask() {
        }

        @Override
        public void run() {
            MigrationManager.this.partitionServiceLock.lock();
            try {
                MigrationManager.this.migrationQueue.clear();
                if (MigrationManager.this.partitionService.scheduleFetchMostRecentPartitionTableTaskIfRequired()) {
                    if (MigrationManager.this.logger.isFinestEnabled()) {
                        MigrationManager.this.logger.finest("FetchMostRecentPartitionTableTask scheduled");
                    }
                    MigrationManager.this.migrationQueue.add(new ControlTask());
                    return;
                }
                if (MigrationManager.this.logger.isFinestEnabled()) {
                    MigrationManager.this.logger.finest("RepairPartitionTableTask scheduled");
                }
                MigrationManager.this.migrationQueue.add(new RepairPartitionTableTask());
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }
    }

    private class RepairPartitionTableTask
    implements MigrationRunnable {
        private RepairPartitionTableTask() {
        }

        @Override
        public void run() {
            if (!MigrationManager.this.partitionStateManager.isInitialized()) {
                return;
            }
            Map<Address, Collection<MigrationInfo>> promotions = this.removeUnknownAddressesAndCollectPromotions();
            boolean success = this.promoteBackupsForMissingOwners(promotions);
            MigrationManager.this.partitionServiceLock.lock();
            try {
                if (success) {
                    if (MigrationManager.this.logger.isFinestEnabled()) {
                        MigrationManager.this.logger.finest("RepartitioningTask scheduled");
                    }
                    MigrationManager.this.migrationQueue.add(new RepartitioningTask());
                } else {
                    MigrationManager.this.triggerControlTask();
                }
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<Address, Collection<MigrationInfo>> removeUnknownAddressesAndCollectPromotions() {
            MigrationManager.this.partitionServiceLock.lock();
            try {
                MigrationManager.this.partitionStateManager.removeUnknownAddresses();
                HashMap<Address, Collection<MigrationInfo>> promotions = new HashMap<Address, Collection<MigrationInfo>>();
                for (int partitionId = 0; partitionId < MigrationManager.this.partitionService.getPartitionCount(); ++partitionId) {
                    MigrationInfo migration = this.createPromotionMigrationIfOwnerIsNull(partitionId);
                    if (migration == null) continue;
                    ArrayList<MigrationInfo> migrations = (ArrayList<MigrationInfo>)promotions.get(migration.getDestination());
                    if (migrations == null) {
                        migrations = new ArrayList<MigrationInfo>();
                        promotions.put(migration.getDestination(), migrations);
                    }
                    migrations.add(migration);
                }
                HashMap<Address, Collection<MigrationInfo>> hashMap = promotions;
                return hashMap;
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }

        private boolean promoteBackupsForMissingOwners(Map<Address, Collection<MigrationInfo>> promotions) {
            boolean allSucceeded = true;
            for (Map.Entry<Address, Collection<MigrationInfo>> entry : promotions.entrySet()) {
                Address destination = entry.getKey();
                Collection<MigrationInfo> migrations = entry.getValue();
                allSucceeded &= this.commitPromotionMigrations(destination, migrations);
            }
            return allSucceeded;
        }

        private boolean commitPromotionMigrations(Address destination, Collection<MigrationInfo> migrations) {
            boolean success = this.commitPromotionsToDestination(destination, migrations);
            boolean local = MigrationManager.this.node.getThisAddress().equals(destination);
            if (!local) {
                this.processPromotionCommitResult(destination, migrations, success);
            }
            MigrationManager.this.partitionService.syncPartitionRuntimeState();
            return success;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processPromotionCommitResult(Address destination, Collection<MigrationInfo> migrations, boolean success) {
            MigrationManager.this.partitionServiceLock.lock();
            try {
                if (!MigrationManager.this.partitionStateManager.isInitialized()) {
                    return;
                }
                if (success) {
                    for (MigrationInfo migration : migrations) {
                        InternalPartitionImpl partition = MigrationManager.this.partitionStateManager.getPartitionImpl(migration.getPartitionId());
                        assert (partition.getOwnerOrNull() == null) : "Owner should be null: " + partition;
                        assert (destination.equals(partition.getReplicaAddress(migration.getDestinationCurrentReplicaIndex()))) : "Invalid replica! Destination: " + destination + ", index: " + migration.getDestinationCurrentReplicaIndex() + ", " + partition;
                        partition.swapAddresses(0, migration.getDestinationCurrentReplicaIndex());
                    }
                } else {
                    int delta = migrations.size() + 1;
                    MigrationManager.this.partitionService.getPartitionStateManager().incrementVersion(delta);
                }
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }

        private MigrationInfo createPromotionMigrationIfOwnerIsNull(int partitionId) {
            InternalPartitionImpl partition = MigrationManager.this.partitionStateManager.getPartitionImpl(partitionId);
            if (partition.getOwnerOrNull() == null) {
                int index;
                Address destination = null;
                for (int i = index = 1; i < 7; ++i) {
                    destination = partition.getReplicaAddress(i);
                    if (destination == null) continue;
                    index = i;
                    break;
                }
                if (MigrationManager.this.logger.isFinestEnabled()) {
                    if (destination != null) {
                        MigrationManager.this.logger.finest("partitionId=" + partition.getPartitionId() + " owner is removed. replicaIndex=" + index + " will be shifted up to 0. " + partition);
                    } else {
                        MigrationManager.this.logger.finest("partitionId=" + partition.getPartitionId() + " owner is removed. there is no other replica to shift up. " + partition);
                    }
                }
                if (destination != null) {
                    String destinationUuid = MigrationManager.this.getMemberUuid(destination);
                    MigrationInfo migration = new MigrationInfo(partitionId, null, null, destination, destinationUuid, -1, -1, index, 0);
                    migration.setMaster(MigrationManager.this.node.getThisAddress());
                    migration.setStatus(MigrationInfo.MigrationStatus.SUCCESS);
                    return migration;
                }
            }
            if (partition.getOwnerOrNull() == null) {
                MigrationManager.this.logger.warning("partitionId=" + partitionId + " is completely lost!");
                PartitionEventManager partitionEventManager = MigrationManager.this.partitionService.getPartitionEventManager();
                partitionEventManager.sendPartitionLostEvent(partitionId, 6);
            }
            return null;
        }

        private boolean commitPromotionsToDestination(Address destination, Collection<MigrationInfo> migrations) {
            assert (migrations.size() > 0) : "No promotions to commit! destination=" + destination;
            MemberImpl member = MigrationManager.this.node.getClusterService().getMember(destination);
            if (member == null) {
                MigrationManager.this.logger.warning("Destination " + destination + " is not member anymore");
                return false;
            }
            try {
                if (MigrationManager.this.logger.isFinestEnabled()) {
                    MigrationManager.this.logger.finest("Sending commit operation to " + destination + " for " + migrations);
                }
                PartitionRuntimeState partitionState = MigrationManager.this.partitionService.createPromotionCommitPartitionState(migrations);
                String destinationUuid = member.getUuid();
                PromotionCommitOperation op = new PromotionCommitOperation(partitionState, migrations, destinationUuid);
                InternalCompletableFuture future = MigrationManager.this.nodeEngine.getOperationService().createInvocationBuilder("hz:core:partitionService", (Operation)op, destination).setTryCount(Integer.MAX_VALUE).setCallTimeout(Long.MAX_VALUE).invoke();
                boolean result = (Boolean)future.get();
                if (MigrationManager.this.logger.isFinestEnabled()) {
                    MigrationManager.this.logger.finest("Promotion commit result " + result + " from " + destination + " for migrations " + migrations);
                }
                return result;
            }
            catch (Throwable t) {
                this.logPromotionCommitFailure(destination, migrations, t);
                return false;
            }
        }

        private void logPromotionCommitFailure(Address destination, Collection<MigrationInfo> migrations, Throwable t) {
            boolean memberLeft = t instanceof MemberLeftException || t.getCause() instanceof TargetNotMemberException || t.getCause() instanceof HazelcastInstanceNotActiveException;
            int migrationsSize = migrations.size();
            if (memberLeft) {
                if (MigrationManager.this.node.getThisAddress().equals(destination)) {
                    MigrationManager.this.logger.fine("Promotion commit failed for " + migrationsSize + " migrations" + " since this node is shutting down.");
                    return;
                }
                if (MigrationManager.this.logger.isFinestEnabled()) {
                    MigrationManager.this.logger.warning("Promotion commit failed for " + migrations + " since destination " + destination + " left the cluster");
                } else {
                    MigrationManager.this.logger.warning("Promotion commit failed for " + (migrationsSize == 1 ? migrations.iterator().next() : migrationsSize + " migrations") + " since destination " + destination + " left the cluster");
                }
                return;
            }
            if (MigrationManager.this.logger.isFinestEnabled()) {
                MigrationManager.this.logger.severe("Promotion commit to " + destination + " failed for " + migrations, t);
            } else {
                MigrationManager.this.logger.severe("Promotion commit to " + destination + " failed for " + (migrationsSize == 1 ? migrations.iterator().next() : migrationsSize + " migrations"), t);
            }
        }
    }

    class MigrateTask
    implements MigrationRunnable {
        final MigrationInfo migrationInfo;

        MigrateTask(MigrationInfo migrationInfo) {
            this.migrationInfo = migrationInfo;
            migrationInfo.setMaster(MigrationManager.this.node.getThisAddress());
        }

        @Override
        public void run() {
            if (!MigrationManager.this.node.isMaster()) {
                return;
            }
            if (this.migrationInfo.getSource() == null && this.migrationInfo.getDestinationCurrentReplicaIndex() > 0 && this.migrationInfo.getDestinationNewReplicaIndex() == 0) {
                throw new AssertionError((Object)("Promotion migrations should be handled by " + RepairPartitionTableTask.class.getSimpleName() + "! -> " + this.migrationInfo));
            }
            try {
                MemberImpl partitionOwner = this.checkMigrationParticipantsAndGetPartitionOwner();
                if (partitionOwner == null) {
                    return;
                }
                this.beforeMigration();
                Boolean result = this.executeMigrateOperation(partitionOwner);
                this.processMigrationResult(result);
            }
            catch (Throwable t) {
                Level level = this.migrationInfo.isValid() ? Level.WARNING : Level.FINE;
                MigrationManager.this.logger.log(level, "Error [" + t.getClass() + ": " + t.getMessage() + "] during " + this.migrationInfo);
                MigrationManager.this.logger.finest(t);
                this.migrationOperationFailed();
            }
        }

        private void beforeMigration() {
            MigrationManager.this.internalMigrationListener.onMigrationStart(InternalMigrationListener.MigrationParticipant.MASTER, this.migrationInfo);
            MigrationManager.this.partitionService.getPartitionEventManager().sendMigrationEvent(this.migrationInfo, MigrationEvent.MigrationStatus.STARTED);
            if (MigrationManager.this.logger.isFineEnabled()) {
                MigrationManager.this.logger.fine("Starting Migration: " + this.migrationInfo);
            }
        }

        private MemberImpl checkMigrationParticipantsAndGetPartitionOwner() {
            MemberImpl partitionOwner = this.getPartitionOwner();
            if (partitionOwner == null) {
                MigrationManager.this.logger.fine("Partition owner is null. Ignoring " + this.migrationInfo);
                this.triggerRepartitioningAfterMigrationFailure();
                return null;
            }
            if (this.migrationInfo.getSource() != null && MigrationManager.this.node.getClusterService().getMember(this.migrationInfo.getSource()) == null) {
                MigrationManager.this.logger.fine("Source is not member anymore. Ignoring " + this.migrationInfo);
                this.triggerRepartitioningAfterMigrationFailure();
                return null;
            }
            if (MigrationManager.this.node.getClusterService().getMember(this.migrationInfo.getDestination()) == null) {
                MigrationManager.this.logger.fine("Destination is not member anymore. Ignoring " + this.migrationInfo);
                this.triggerRepartitioningAfterMigrationFailure();
                return null;
            }
            return partitionOwner;
        }

        private MemberImpl getPartitionOwner() {
            InternalPartitionImpl partition = MigrationManager.this.partitionStateManager.getPartitionImpl(this.migrationInfo.getPartitionId());
            Address owner = partition.getOwnerOrNull();
            if (owner == null) {
                if (this.migrationInfo.isValid()) {
                    MigrationManager.this.logger.severe("Skipping migration! Partition owner is not set! -> partitionId=" + this.migrationInfo.getPartitionId() + " , " + partition + " -VS- " + this.migrationInfo);
                }
                return null;
            }
            return MigrationManager.this.node.getClusterService().getMember(owner);
        }

        private void processMigrationResult(Boolean result) {
            if (Boolean.TRUE.equals(result)) {
                if (MigrationManager.this.logger.isFineEnabled()) {
                    MigrationManager.this.logger.fine("Finished Migration: " + this.migrationInfo);
                }
                this.migrationOperationSucceeded();
            } else {
                Level level;
                Level level2 = level = MigrationManager.this.nodeEngine.isRunning() && this.migrationInfo.isValid() ? Level.WARNING : Level.FINE;
                if (MigrationManager.this.logger.isLoggable(level)) {
                    MigrationManager.this.logger.log(level, "Migration failed: " + this.migrationInfo);
                }
                this.migrationOperationFailed();
            }
        }

        private Boolean executeMigrateOperation(MemberImpl fromMember) {
            MigrationRequestOperation migrationRequestOp = new MigrationRequestOperation(this.migrationInfo, MigrationManager.this.partitionService.getPartitionStateVersion());
            InternalCompletableFuture future = MigrationManager.this.nodeEngine.getOperationService().createInvocationBuilder("hz:core:partitionService", (Operation)migrationRequestOp, fromMember.getAddress()).setCallTimeout(MigrationManager.this.partitionMigrationTimeout).setTryCount(12).setTryPauseMillis(10000L).invoke();
            try {
                Object response = future.get();
                return (Boolean)MigrationManager.this.nodeEngine.toObject(response);
            }
            catch (Throwable e) {
                Level level;
                Level level2 = level = MigrationManager.this.nodeEngine.isRunning() && this.migrationInfo.isValid() ? Level.WARNING : Level.FINE;
                if (e instanceof ExecutionException && e.getCause() instanceof PartitionStateVersionMismatchException) {
                    level = Level.FINE;
                }
                if (MigrationManager.this.logger.isLoggable(level)) {
                    MigrationManager.this.logger.log(level, "Failed migration from " + fromMember + " for " + migrationRequestOp.getMigrationInfo(), e);
                }
                return Boolean.FALSE;
            }
        }

        private void migrationOperationFailed() {
            this.migrationInfo.setStatus(MigrationInfo.MigrationStatus.FAILED);
            MigrationManager.this.internalMigrationListener.onMigrationComplete(InternalMigrationListener.MigrationParticipant.MASTER, this.migrationInfo, false);
            MigrationManager.this.partitionServiceLock.lock();
            try {
                MigrationManager.this.addCompletedMigration(this.migrationInfo);
                MigrationManager.this.internalMigrationListener.onMigrationRollback(InternalMigrationListener.MigrationParticipant.MASTER, this.migrationInfo);
                MigrationManager.this.scheduleActiveMigrationFinalization(this.migrationInfo);
                int delta = 2;
                MigrationManager.this.partitionService.getPartitionStateManager().incrementVersion(delta);
                MigrationManager.this.node.getNodeExtension().onPartitionStateChange();
                if (MigrationManager.this.partitionService.syncPartitionRuntimeState()) {
                    MigrationManager.this.evictCompletedMigrations(this.migrationInfo);
                }
                this.triggerRepartitioningAfterMigrationFailure();
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
            MigrationManager.this.partitionService.getPartitionEventManager().sendMigrationEvent(this.migrationInfo, MigrationEvent.MigrationStatus.FAILED);
        }

        private void triggerRepartitioningAfterMigrationFailure() {
            MigrationManager.this.partitionServiceLock.lock();
            try {
                MigrationManager.this.pauseMigration();
                MigrationManager.this.triggerControlTask();
                MigrationManager.this.resumeMigrationEventually();
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }

        private void migrationOperationSucceeded() {
            MigrationManager.this.internalMigrationListener.onMigrationComplete(InternalMigrationListener.MigrationParticipant.MASTER, this.migrationInfo, true);
            boolean commitSuccessful = MigrationManager.this.commitMigrationToDestination(this.migrationInfo.getDestination(), this.migrationInfo);
            MigrationManager.this.partitionServiceLock.lock();
            try {
                if (commitSuccessful) {
                    this.migrationInfo.setStatus(MigrationInfo.MigrationStatus.SUCCESS);
                    MigrationManager.this.internalMigrationListener.onMigrationCommit(InternalMigrationListener.MigrationParticipant.MASTER, this.migrationInfo);
                    InternalPartitionImpl partition = MigrationManager.this.partitionStateManager.getPartitionImpl(this.migrationInfo.getPartitionId());
                    MigrationManager.this.applyMigration(partition, this.migrationInfo);
                } else {
                    this.migrationInfo.setStatus(MigrationInfo.MigrationStatus.FAILED);
                    MigrationManager.this.internalMigrationListener.onMigrationRollback(InternalMigrationListener.MigrationParticipant.MASTER, this.migrationInfo);
                    int delta = 2;
                    MigrationManager.this.partitionService.getPartitionStateManager().incrementVersion(delta);
                    this.triggerRepartitioningAfterMigrationFailure();
                }
                MigrationManager.this.addCompletedMigration(this.migrationInfo);
                MigrationManager.this.scheduleActiveMigrationFinalization(this.migrationInfo);
                MigrationManager.this.node.getNodeExtension().onPartitionStateChange();
                if (MigrationManager.this.partitionService.syncPartitionRuntimeState()) {
                    MigrationManager.this.evictCompletedMigrations(this.migrationInfo);
                }
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
            PartitionEventManager partitionEventManager = MigrationManager.this.partitionService.getPartitionEventManager();
            partitionEventManager.sendMigrationEvent(this.migrationInfo, MigrationEvent.MigrationStatus.COMPLETED);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{" + "migrationInfo=" + this.migrationInfo + '}';
        }
    }

    private final class AssertPartitionTableTask
    implements MigrationRunnable {
        final int maxBackupCount;

        private AssertPartitionTableTask(int maxBackupCount) {
            this.maxBackupCount = maxBackupCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!ASSERTION_ENABLED) {
                return;
            }
            if (!MigrationManager.this.node.isMaster()) {
                return;
            }
            MigrationManager.this.partitionServiceLock.lock();
            try {
                if (!MigrationManager.this.partitionStateManager.isInitialized()) {
                    MigrationManager.this.logger.info("Skipping partition table assertions since partition table state is reset");
                    return;
                }
                InternalPartition[] partitions = MigrationManager.this.partitionStateManager.getPartitions();
                HashSet<Address> replicas = new HashSet<Address>();
                for (InternalPartition partition : partitions) {
                    replicas.clear();
                    for (int index = 0; index < 7; ++index) {
                        Address address = partition.getReplicaAddress(index);
                        if (index <= this.maxBackupCount) {
                            if (MigrationManager.this.shutdownRequestedAddresses.isEmpty()) assert (address != null) : "Repartitioning problem, missing replica! Current replica: " + index + ", Max backups: " + this.maxBackupCount + " -> " + partition;
                        } else assert (address == null) : "Repartitioning problem, leaking replica! Current replica: " + index + ", Max backups: " + this.maxBackupCount + " -> " + partition;
                        if (address != null) assert (replicas.add(address)) : "Duplicate address in " + partition;
                    }
                }
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }
    }

    private class RepartitioningTask
    implements MigrationRunnable {
        private RepartitioningTask() {
        }

        @Override
        public void run() {
            if (!MigrationManager.this.node.isMaster()) {
                return;
            }
            MigrationManager.this.partitionServiceLock.lock();
            try {
                Address[][] newState = this.repartition();
                if (newState == null) {
                    return;
                }
                MigrationManager.this.lastRepartitionTime.set(Clock.currentTimeMillis());
                this.processNewPartitionState(newState);
                if (ASSERTION_ENABLED) {
                    MigrationManager.this.migrationQueue.add(new AssertPartitionTableTask(MigrationManager.this.partitionService.getMaxAllowedBackupCount()));
                }
                MigrationManager.this.migrationQueue.add(new ProcessShutdownRequestsTask());
                MigrationManager.this.partitionService.syncPartitionRuntimeState();
            }
            finally {
                MigrationManager.this.partitionServiceLock.unlock();
            }
        }

        private Address[][] repartition() {
            if (!this.isAllowed()) {
                return null;
            }
            Address[][] newState = MigrationManager.this.partitionStateManager.repartition(MigrationManager.this.shutdownRequestedAddresses);
            if (newState == null) {
                MigrationManager.this.migrationQueue.add(new ProcessShutdownRequestsTask());
                return null;
            }
            if (!this.isAllowed()) {
                return null;
            }
            return newState;
        }

        private void processNewPartitionState(Address[][] newState) {
            MutableInteger lostCount = new MutableInteger();
            MutableInteger migrationCount = new MutableInteger();
            ArrayList<Queue<MigrationInfo>> migrations = new ArrayList<Queue<MigrationInfo>>(newState.length);
            for (int partitionId = 0; partitionId < newState.length; ++partitionId) {
                InternalPartitionImpl currentPartition = MigrationManager.this.partitionStateManager.getPartitionImpl(partitionId);
                Object[] currentReplicas = currentPartition.getReplicaAddresses();
                Object[] newReplicas = newState[partitionId];
                MigrationCollector migrationCollector = new MigrationCollector(currentPartition, migrationCount, lostCount);
                if (MigrationManager.this.logger.isFinestEnabled()) {
                    MigrationManager.this.logger.finest("Planning migrations for partitionId=" + partitionId + ". Current replicas: " + Arrays.toString(currentReplicas) + ", New replicas: " + Arrays.toString(newReplicas));
                }
                MigrationManager.this.migrationPlanner.planMigrations((Address[])currentReplicas, (Address[])newReplicas, migrationCollector);
                MigrationManager.this.migrationPlanner.prioritizeCopiesAndShiftUps(migrationCollector.migrations);
                migrations.add(migrationCollector.migrations);
            }
            this.scheduleMigrations(migrations);
            this.logMigrationStatistics(migrationCount.value, lostCount.value);
        }

        private void scheduleMigrations(List<Queue<MigrationInfo>> migrations) {
            boolean migrationScheduled;
            do {
                migrationScheduled = false;
                for (Queue<MigrationInfo> queue : migrations) {
                    MigrationInfo migration = queue.poll();
                    if (migration == null) continue;
                    migrationScheduled = true;
                    MigrationManager.this.scheduleMigration(migration);
                }
            } while (migrationScheduled);
        }

        private void logMigrationStatistics(int migrationCount, int lostCount) {
            if (lostCount > 0) {
                MigrationManager.this.logger.warning("Assigning new owners for " + lostCount + " LOST partitions!");
            }
            if (migrationCount > 0) {
                MigrationManager.this.logger.info("Re-partitioning cluster data... Migration queue size: " + migrationCount);
            } else {
                MigrationManager.this.logger.info("Partition balance is ok, no need to re-partition cluster data... ");
            }
        }

        private void assignNewPartitionOwner(int partitionId, InternalPartitionImpl currentPartition, Address newOwner) {
            String destinationUuid = MigrationManager.this.getMemberUuid(newOwner);
            MigrationInfo migrationInfo = new MigrationInfo(partitionId, null, null, newOwner, destinationUuid, -1, -1, -1, 0);
            PartitionEventManager partitionEventManager = MigrationManager.this.partitionService.getPartitionEventManager();
            partitionEventManager.sendMigrationEvent(migrationInfo, MigrationEvent.MigrationStatus.STARTED);
            currentPartition.setReplicaAddress(0, newOwner);
            partitionEventManager.sendMigrationEvent(migrationInfo, MigrationEvent.MigrationStatus.COMPLETED);
        }

        private boolean isAllowed() {
            boolean hasMigrationTasks;
            boolean migrationAllowed = this.isClusterActiveAndMigrationAllowed();
            boolean bl = hasMigrationTasks = MigrationManager.this.migrationQueue.migrationTaskCount() > 1;
            if (migrationAllowed && !hasMigrationTasks) {
                return true;
            }
            MigrationManager.this.triggerControlTask();
            return false;
        }

        private boolean isClusterActiveAndMigrationAllowed() {
            if (MigrationManager.this.isMigrationAllowed()) {
                ClusterState clusterState = MigrationManager.this.node.getClusterService().getClusterState();
                return clusterState == ClusterState.ACTIVE;
            }
            return false;
        }

        private class MigrationCollector
        implements MigrationPlanner.MigrationDecisionCallback {
            private final int partitionId;
            private final InternalPartitionImpl partition;
            private final MutableInteger migrationCount;
            private final MutableInteger lostCount;
            private final LinkedList<MigrationInfo> migrations = new LinkedList();

            MigrationCollector(InternalPartitionImpl partition, MutableInteger migrationCount, MutableInteger lostCount) {
                this.partitionId = partition.getPartitionId();
                this.partition = partition;
                this.migrationCount = migrationCount;
                this.lostCount = lostCount;
            }

            @Override
            public void migrate(Address source, int sourceCurrentReplicaIndex, int sourceNewReplicaIndex, Address destination, int destinationCurrentReplicaIndex, int destinationNewReplicaIndex) {
                if (MigrationManager.this.logger.isFineEnabled()) {
                    MigrationManager.this.logger.fine("Planned migration -> partitionId=" + this.partitionId + ", source=" + source + ", sourceCurrentReplicaIndex=" + sourceCurrentReplicaIndex + ", sourceNewReplicaIndex=" + sourceNewReplicaIndex + ", destination=" + destination + ", destinationCurrentReplicaIndex=" + destinationCurrentReplicaIndex + ", destinationNewReplicaIndex=" + destinationNewReplicaIndex);
                }
                if (source == null && destinationCurrentReplicaIndex == -1 && destinationNewReplicaIndex == 0) {
                    assert (destination != null) : "partitionId=" + this.partitionId + " destination is null";
                    assert (sourceCurrentReplicaIndex == -1) : "partitionId=" + this.partitionId + " invalid index: " + sourceCurrentReplicaIndex;
                    assert (sourceNewReplicaIndex == -1) : "partitionId=" + this.partitionId + " invalid index: " + sourceNewReplicaIndex;
                    ++this.lostCount.value;
                    RepartitioningTask.this.assignNewPartitionOwner(this.partitionId, this.partition, destination);
                } else if (destination == null && sourceNewReplicaIndex == -1) {
                    assert (source != null) : "partitionId=" + this.partitionId + " source is null";
                    assert (sourceCurrentReplicaIndex != -1) : "partitionId=" + this.partitionId + " invalid index: " + sourceCurrentReplicaIndex;
                    assert (sourceCurrentReplicaIndex != 0) : "partitionId=" + this.partitionId + " invalid index: " + sourceCurrentReplicaIndex;
                    Address currentSource = this.partition.getReplicaAddress(sourceCurrentReplicaIndex);
                    assert (source.equals(currentSource)) : "partitionId=" + this.partitionId + " current source=" + source + " is different than expected source=" + source;
                    this.partition.setReplicaAddress(sourceCurrentReplicaIndex, null);
                } else {
                    String sourceUuid = MigrationManager.this.getMemberUuid(source);
                    String destinationUuid = MigrationManager.this.getMemberUuid(destination);
                    MigrationInfo migration = new MigrationInfo(this.partitionId, source, sourceUuid, destination, destinationUuid, sourceCurrentReplicaIndex, sourceNewReplicaIndex, destinationCurrentReplicaIndex, destinationNewReplicaIndex);
                    ++this.migrationCount.value;
                    this.migrations.add(migration);
                }
            }
        }
    }
}

