/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.core.MigrationEvent;
import com.hazelcast.internal.partition.operation.AbstractPromotionOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.PartitionMigrationEvent;

final class BeforePromotionOperation
extends AbstractPromotionOperation {
    public BeforePromotionOperation() {
        super(-1);
    }

    BeforePromotionOperation(int currentReplicaIndex) {
        super(currentReplicaIndex);
    }

    @Override
    public void beforeRun() throws Exception {
        this.sendMigrationEvent(MigrationEvent.MigrationStatus.STARTED);
    }

    @Override
    public void run() throws Exception {
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("Running before promotion for " + this.getPartitionMigrationEvent());
        }
        PartitionMigrationEvent event = this.getPartitionMigrationEvent();
        for (MigrationAwareService service : this.getMigrationAwareServices()) {
            try {
                service.beforeMigration(event);
            }
            catch (Throwable e) {
                logger.warning("While promoting partitionId=" + this.getPartitionId(), e);
            }
        }
    }
}

