/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.nearcache;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCachePreloaderConfig;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.map.impl.nearcache.KeyStateMarker;
import com.hazelcast.map.impl.nearcache.KeyStateMarkerImpl;
import com.hazelcast.monitor.NearCacheStats;

public final class InvalidationAwareWrapper<K, V>
implements NearCache<K, V> {
    private final NearCache<K, V> nearCache;
    private final KeyStateMarker keyStateMarker;

    private InvalidationAwareWrapper(NearCache<K, V> nearCache, int markerCount) {
        this.nearCache = nearCache;
        this.keyStateMarker = new KeyStateMarkerImpl(markerCount);
    }

    public static <KEY, VALUE> NearCache<KEY, VALUE> asInvalidationAware(NearCache<KEY, VALUE> nearCache, int markerCount) {
        return new InvalidationAwareWrapper<KEY, VALUE>(nearCache, markerCount);
    }

    @Override
    public void initialize() {
        this.nearCache.initialize();
    }

    @Override
    public String getName() {
        return this.nearCache.getName();
    }

    @Override
    public V get(K key) {
        return this.nearCache.get(key);
    }

    @Override
    public void put(K key, V value) {
        this.nearCache.put(key, value);
    }

    @Override
    public boolean remove(K key) {
        this.keyStateMarker.tryRemove(key);
        return this.nearCache.remove(key);
    }

    @Override
    public boolean isInvalidatedOnChange() {
        return this.nearCache.isInvalidatedOnChange();
    }

    @Override
    public void clear() {
        this.keyStateMarker.init();
        this.nearCache.clear();
    }

    @Override
    public void destroy() {
        this.keyStateMarker.init();
        this.nearCache.destroy();
    }

    @Override
    public InMemoryFormat getInMemoryFormat() {
        return this.nearCache.getInMemoryFormat();
    }

    @Override
    public NearCachePreloaderConfig getPreloaderConfig() {
        return this.nearCache.getPreloaderConfig();
    }

    @Override
    public NearCacheStats getNearCacheStats() {
        return this.nearCache.getNearCacheStats();
    }

    @Override
    public Object selectToSave(Object ... candidates) {
        return this.nearCache.selectToSave(candidates);
    }

    @Override
    public int size() {
        return this.nearCache.size();
    }

    @Override
    public void preload(DataStructureAdapter adapter) {
        this.nearCache.preload(adapter);
    }

    @Override
    public void storeKeys() {
        this.nearCache.storeKeys();
    }

    @Override
    public boolean isPreloadDone() {
        return this.nearCache.isPreloadDone();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.nearCache.getClass())) {
            return clazz.cast(this.nearCache);
        }
        throw new IllegalArgumentException("Unwrapping to " + clazz + " is not supported by this implementation");
    }

    public KeyStateMarker getKeyStateMarker() {
        return this.keyStateMarker;
    }
}

