/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.nearcache;

import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.impl.DefaultNearCacheManager;
import com.hazelcast.internal.nearcache.impl.invalidation.MinimalPartitionService;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.nearcache.MemberMinimalPartitionService;
import com.hazelcast.map.impl.nearcache.invalidation.BatchInvalidator;
import com.hazelcast.map.impl.nearcache.invalidation.Invalidator;
import com.hazelcast.map.impl.nearcache.invalidation.MemberMapMetaDataFetcher;
import com.hazelcast.map.impl.nearcache.invalidation.NonStopInvalidator;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;

public class MapNearCacheManager
extends DefaultNearCacheManager {
    protected final int partitionCount;
    protected final NodeEngine nodeEngine;
    protected final MapServiceContext mapServiceContext;
    protected final Invalidator invalidator;
    protected final RepairingTask repairingTask;
    protected final MinimalPartitionService partitionService;

    public MapNearCacheManager(MapServiceContext mapServiceContext) {
        super(mapServiceContext.getNodeEngine().getSerializationService(), mapServiceContext.getNodeEngine().getExecutionService(), null);
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.partitionService = new MemberMinimalPartitionService(this.nodeEngine.getPartitionService());
        this.mapServiceContext = mapServiceContext;
        this.partitionCount = this.partitionService.getPartitionCount();
        this.invalidator = this.isBatchingEnabled() ? new BatchInvalidator(mapServiceContext) : new NonStopInvalidator(mapServiceContext);
        this.repairingTask = this.createRepairingInvalidationTask();
    }

    private RepairingTask createRepairingInvalidationTask() {
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        ClusterService clusterService = this.nodeEngine.getClusterService();
        OperationService operationService = this.nodeEngine.getOperationService();
        HazelcastProperties properties = this.nodeEngine.getProperties();
        ILogger logger = this.nodeEngine.getLogger(RepairingTask.class);
        MemberMapMetaDataFetcher metaDataFetcher = new MemberMapMetaDataFetcher(clusterService, operationService, logger);
        String localUuid = this.nodeEngine.getLocalMember().getUuid();
        return new RepairingTask(metaDataFetcher, executionService, this.partitionService, properties, localUuid, logger);
    }

    private boolean isBatchingEnabled() {
        HazelcastProperties hazelcastProperties = this.nodeEngine.getProperties();
        int batchSize = hazelcastProperties.getInteger(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_SIZE);
        return hazelcastProperties.getBoolean(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_ENABLED) && batchSize > 1;
    }

    public void reset() {
        this.clearAllNearCaches();
        this.invalidator.reset();
    }

    public void shutdown() {
        this.destroyAllNearCaches();
        this.invalidator.shutdown();
    }

    @Override
    public boolean destroyNearCache(String mapName) {
        if (!super.destroyNearCache(mapName)) {
            return false;
        }
        String uuid = this.nodeEngine.getLocalMember().getUuid();
        this.invalidator.destroy(mapName, uuid);
        return true;
    }

    public Object getFromNearCache(String mapName, Data key) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        if (!mapContainer.hasInvalidationListener()) {
            return null;
        }
        NearCacheConfig nearCacheConfig = mapContainer.getMapConfig().getNearCacheConfig();
        NearCache nearCache = this.getOrCreateNearCache(mapName, nearCacheConfig);
        return nearCache.get(key);
    }

    public Invalidator getInvalidator() {
        return this.invalidator;
    }

    public RepairingHandler newRepairingHandler(String name, NearCache nearCache) {
        return this.repairingTask.registerAndGetHandler(name, nearCache);
    }

    public void deregisterRepairingHandler(String name) {
        this.repairingTask.deregisterHandler(name);
    }
}

