/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.nearcache.invalidation;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.nearcache.invalidation.BatchNearCacheInvalidation;
import com.hazelcast.map.impl.nearcache.invalidation.Invalidation;
import com.hazelcast.map.impl.nearcache.invalidation.Invalidator;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class BatchInvalidator
extends Invalidator {
    private static final String INVALIDATION_EXECUTOR_NAME = BatchInvalidator.class.getName();
    private final ConstructorFunction<String, InvalidationQueue> invalidationQueueConstructor = new ConstructorFunction<String, InvalidationQueue>(){

        @Override
        public InvalidationQueue createNew(String mapName) {
            return new InvalidationQueue();
        }
    };
    private final ConcurrentMap<String, InvalidationQueue> invalidationQueues = new ConcurrentHashMap<String, InvalidationQueue>();
    private final int batchSize = this.getBatchSize();
    private final String nodeShutdownListenerId = this.registerNodeShutdownListener();
    private final ExecutionService executionService = this.nodeEngine.getExecutionService();

    public BatchInvalidator(MapServiceContext mapServiceContext) {
        super(mapServiceContext);
        this.startBackgroundBatchProcessor();
    }

    @Override
    protected void invalidateInternal(Invalidation invalidation, int orderKey) {
        String mapName = invalidation.getName();
        InvalidationQueue invalidationQueue = ConcurrencyUtil.getOrPutIfAbsent(this.invalidationQueues, mapName, this.invalidationQueueConstructor);
        invalidationQueue.offer(invalidation);
        if (invalidationQueue.size() >= this.batchSize) {
            this.createAndSendInvalidations(mapName, invalidationQueue, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndSendInvalidations(String mapName, InvalidationQueue invalidationQueue, boolean offloadEventSending) {
        assert (invalidationQueue != null);
        if (!invalidationQueue.tryAcquire()) {
            return;
        }
        try {
            List<Invalidation> invalidations = this.createInvalidations(invalidationQueue);
            if (!CollectionUtil.isEmpty(invalidations)) {
                this.sendInvalidations(mapName, invalidations, offloadEventSending);
            }
        }
        finally {
            invalidationQueue.release();
        }
    }

    private List<Invalidation> createInvalidations(InvalidationQueue invalidationQueue) {
        Invalidation invalidation;
        int size = Math.min(this.batchSize, invalidationQueue.size());
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<Invalidation> invalidations = new ArrayList<Invalidation>(size);
        for (int i = 0; i < size && (invalidation = invalidationQueue.poll()) != null; ++i) {
            invalidations.add(invalidation);
        }
        return invalidations;
    }

    private void sendInvalidations(String mapName, List<Invalidation> invalidations, boolean offloadEventSending) {
        if (offloadEventSending) {
            this.executionService.execute(mapName, new EventSender(mapName, invalidations));
        } else {
            this.sendInvalidations(mapName, invalidations);
        }
    }

    private void sendInvalidations(String mapName, List<Invalidation> invalidations) {
        Collection<EventRegistration> registrations = this.eventService.getRegistrations("hz:impl:mapService", mapName);
        for (EventRegistration registration : registrations) {
            List<Invalidation> selection = this.filterInvalidations(invalidations, registration.getFilter());
            if (selection == null) continue;
            BatchNearCacheInvalidation invalidation = new BatchNearCacheInvalidation(mapName, selection);
            this.eventService.publishEvent("hz:impl:mapService", registration, (Object)invalidation, mapName.hashCode());
        }
    }

    private List<Invalidation> filterInvalidations(List<Invalidation> invalidations, EventFilter filter) {
        ArrayList<Invalidation> selection = null;
        for (Invalidation invalidation : invalidations) {
            if (!this.canSendInvalidation(filter)) continue;
            if (selection == null) {
                selection = new ArrayList<Invalidation>();
            }
            selection.add(invalidation);
        }
        return selection;
    }

    private String registerNodeShutdownListener() {
        HazelcastInstance node = this.nodeEngine.getHazelcastInstance();
        LifecycleService lifecycleService = node.getLifecycleService();
        return lifecycleService.addLifecycleListener(new LifecycleListener(){

            @Override
            public void stateChanged(LifecycleEvent event) {
                if (event.getState() == LifecycleEvent.LifecycleState.SHUTTING_DOWN) {
                    Set entries = BatchInvalidator.this.invalidationQueues.entrySet();
                    for (Map.Entry entry : entries) {
                        BatchInvalidator.this.createAndSendInvalidations((String)entry.getKey(), (InvalidationQueue)entry.getValue(), false);
                    }
                }
            }
        });
    }

    private int getBatchSize() {
        return this.nodeEngine.getProperties().getInteger(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_SIZE);
    }

    private int getBackgroundProcessorRunPeriodSeconds() {
        return this.nodeEngine.getProperties().getInteger(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS);
    }

    private void startBackgroundBatchProcessor() {
        int periodSeconds = this.getBackgroundProcessorRunPeriodSeconds();
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        executionService.scheduleWithRepetition(INVALIDATION_EXECUTOR_NAME, new MapBatchInvalidationEventSender(), periodSeconds, periodSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void destroy(String mapName, String sourceUuid) {
        InvalidationQueue invalidationQueue = (InvalidationQueue)this.invalidationQueues.remove(mapName);
        if (invalidationQueue != null) {
            this.invalidateInternal(this.newClearInvalidation(mapName, sourceUuid), mapName.hashCode());
        }
    }

    @Override
    public void shutdown() {
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        executionService.shutdownExecutor(INVALIDATION_EXECUTOR_NAME);
        HazelcastInstance node = this.nodeEngine.getHazelcastInstance();
        LifecycleService lifecycleService = node.getLifecycleService();
        lifecycleService.removeLifecycleListener(this.nodeShutdownListenerId);
        this.invalidationQueues.clear();
    }

    @Override
    public void reset() {
        this.invalidationQueues.clear();
    }

    private static class InvalidationQueue
    extends ConcurrentLinkedQueue<Invalidation> {
        private final AtomicInteger elementCount = new AtomicInteger(0);
        private final AtomicBoolean flushingInProgress = new AtomicBoolean(false);

        private InvalidationQueue() {
        }

        @Override
        public int size() {
            return this.elementCount.get();
        }

        @Override
        public boolean offer(Invalidation invalidation) {
            boolean offered = super.offer(invalidation);
            if (offered) {
                this.elementCount.incrementAndGet();
            }
            return offered;
        }

        @Override
        public Invalidation poll() {
            Invalidation invalidation = (Invalidation)super.poll();
            if (invalidation != null) {
                this.elementCount.decrementAndGet();
            }
            return invalidation;
        }

        public boolean tryAcquire() {
            return this.flushingInProgress.compareAndSet(false, true);
        }

        public void release() {
            this.flushingInProgress.set(false);
        }

        @Override
        public boolean add(Invalidation invalidation) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Invalidation remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Invalidation> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private class MapBatchInvalidationEventSender
    implements Runnable {
        private MapBatchInvalidationEventSender() {
        }

        @Override
        public void run() {
            for (Map.Entry entry : BatchInvalidator.this.invalidationQueues.entrySet()) {
                if (Thread.currentThread().isInterrupted()) break;
                String mapName = (String)entry.getKey();
                InvalidationQueue invalidationQueue = (InvalidationQueue)entry.getValue();
                if (invalidationQueue.size() <= 0) continue;
                BatchInvalidator.this.createAndSendInvalidations(mapName, invalidationQueue, false);
            }
        }
    }

    private final class EventSender
    implements Runnable {
        private final String mapName;
        private final List<Invalidation> invalidations;

        public EventSender(String mapName, List<Invalidation> invalidations) {
            this.mapName = mapName;
            this.invalidations = invalidations;
        }

        @Override
        public void run() {
            BatchInvalidator.this.sendInvalidations(this.mapName, this.invalidations);
        }
    }
}

