/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.nearcache.invalidation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.IMapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.util.UUID;

public abstract class Invalidation
implements IMapEvent,
IdentifiedDataSerializable {
    private String mapName;
    private String sourceUuid;
    private UUID partitionUuid;
    private long sequence = -1L;

    public Invalidation() {
    }

    public Invalidation(String mapName) {
        this.mapName = Preconditions.checkNotNull(mapName, "mapName cannot be null");
    }

    public Invalidation(String mapName, String sourceUuid, UUID partitionUuid) {
        this.mapName = Preconditions.checkNotNull(mapName, "mapName cannot be null");
        this.sourceUuid = Preconditions.checkNotNull(sourceUuid, "sourceUuid cannot be null");
        this.partitionUuid = partitionUuid;
    }

    public Invalidation(String mapName, String sourceUuid, UUID partitionUuid, long sequence) {
        this.mapName = Preconditions.checkNotNull(mapName, "mapName cannot be null");
        this.partitionUuid = Preconditions.checkNotNull(partitionUuid, "partitionUuid cannot be null");
        this.sequence = Preconditions.checkPositive(sequence, "sequence should be positive");
        this.sourceUuid = Preconditions.checkNotNull(sourceUuid, "sourceUuid cannot be null");
    }

    public final UUID getPartitionUuid() {
        return this.partitionUuid;
    }

    public final String getSourceUuid() {
        return this.sourceUuid;
    }

    public final long getSequence() {
        return this.sequence;
    }

    public Data getKey() {
        throw new UnsupportedOperationException("getKey is not supported");
    }

    @Override
    public final String getName() {
        return this.mapName;
    }

    @Override
    public Member getMember() {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntryEventType getEventType() {
        return EntryEventType.INVALIDATION;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.mapName);
        out.writeUTF(this.sourceUuid);
        out.writeLong(this.sequence);
        boolean nullUuid = this.partitionUuid == null;
        out.writeBoolean(nullUuid);
        if (!nullUuid) {
            out.writeLong(this.partitionUuid.getMostSignificantBits());
            out.writeLong(this.partitionUuid.getLeastSignificantBits());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.mapName = in.readUTF();
        this.sourceUuid = in.readUTF();
        this.sequence = in.readLong();
        boolean nullUuid = in.readBoolean();
        if (!nullUuid) {
            this.partitionUuid = new UUID(in.readLong(), in.readLong());
        }
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    public String toString() {
        return "mapName='" + this.mapName + "', sourceUuid='" + this.sourceUuid + "', partitionUuid='" + this.partitionUuid + ", sequence=" + this.sequence;
    }
}

