/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.nearcache.invalidation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataGenerator;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.EventListenerFilter;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.nearcache.invalidation.Invalidation;
import com.hazelcast.map.impl.nearcache.invalidation.SingleNearCacheInvalidation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.spi.serialization.SerializationService;
import java.util.UUID;

public abstract class Invalidator {
    protected final ILogger logger;
    protected final int partitionCount;
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;
    protected final EventService eventService;
    protected final SerializationService serializationService;
    protected final MetaDataGenerator metaDataGenerator;
    protected final IPartitionService partitionService;

    public Invalidator(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.logger = this.nodeEngine.getLogger(this.getClass());
        this.partitionService = this.nodeEngine.getPartitionService();
        this.eventService = this.nodeEngine.getEventService();
        this.serializationService = this.nodeEngine.getSerializationService();
        this.partitionCount = this.nodeEngine.getPartitionService().getPartitionCount();
        this.metaDataGenerator = new MetaDataGenerator(this.partitionCount);
    }

    public final void invalidateKey(Data key, String mapName, String sourceUuid) {
        assert (key != null);
        assert (mapName != null);
        Invalidation invalidation = this.newKeyInvalidation(key, mapName, sourceUuid);
        this.invalidateInternal(invalidation, this.getPartitionId(key));
    }

    public final void invalidateAllKeys(String mapName, String sourceUuid) {
        assert (mapName != null);
        int orderKey = this.getPartitionId(mapName);
        Invalidation invalidation = this.newClearInvalidation(mapName, sourceUuid);
        this.invalidateInternal(invalidation, orderKey);
    }

    protected abstract void invalidateInternal(Invalidation var1, int var2);

    public MetaDataGenerator getMetaDataGenerator() {
        return this.metaDataGenerator;
    }

    protected final Invalidation newKeyInvalidation(Data key, String mapName, String sourceUuid) {
        int partitionId = this.getPartitionId(key);
        long sequence = this.metaDataGenerator.nextSequence(mapName, partitionId);
        UUID partitionUuid = this.metaDataGenerator.getOrCreateUuid(partitionId);
        if (this.logger.isFinestEnabled()) {
            this.logger.finest(String.format("mapName=%s, partition=%d, sequence=%d, uuid=%s", mapName, partitionId, sequence, partitionUuid));
        }
        return new SingleNearCacheInvalidation(this.toHeapData(key), mapName, sourceUuid, partitionUuid, sequence);
    }

    protected final Invalidation newClearInvalidation(String mapName, String sourceUuid) {
        int partitionId = this.getPartitionId(mapName);
        long sequence = this.metaDataGenerator.nextSequence(mapName, partitionId);
        UUID partitionUuid = this.metaDataGenerator.getOrCreateUuid(partitionId);
        return new SingleNearCacheInvalidation(mapName, sourceUuid, partitionUuid, sequence);
    }

    protected final int getPartitionId(Data o) {
        return this.partitionService.getPartitionId(o);
    }

    protected final int getPartitionId(Object o) {
        return this.partitionService.getPartitionId(o);
    }

    protected final boolean canSendInvalidation(EventFilter filter) {
        if (!(filter instanceof EventListenerFilter)) {
            return false;
        }
        return filter.eval(EntryEventType.INVALIDATION.getType());
    }

    private Data toHeapData(Data key) {
        return this.serializationService.toData(key);
    }

    public void destroy(String mapName, String sourceUuid) {
    }

    public void reset() {
    }

    public void shutdown() {
    }
}

