/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.LocalMapStatsProvider;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.query.PartitionScanExecutor;
import com.hazelcast.map.impl.query.Query;
import com.hazelcast.map.impl.query.QueryResultSizeLimiter;
import com.hazelcast.map.impl.query.Result;
import com.hazelcast.map.impl.query.ResultProcessor;
import com.hazelcast.map.impl.query.ResultProcessorRegistry;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.predicates.QueryOptimizer;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.partition.IPartitionService;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;

public class QueryRunner {
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;
    protected final ILogger logger;
    protected final QueryResultSizeLimiter queryResultSizeLimiter;
    protected final InternalSerializationService serializationService;
    protected final IPartitionService partitionService;
    protected final QueryOptimizer queryOptimizer;
    protected final OperationService operationService;
    protected final ClusterService clusterService;
    protected final LocalMapStatsProvider localMapStatsProvider;
    protected final PartitionScanExecutor partitionScanExecutor;
    protected final ResultProcessorRegistry resultProcessorRegistry;

    public QueryRunner(MapServiceContext mapServiceContext, QueryOptimizer optimizer, PartitionScanExecutor partitionScanExecutor, ResultProcessorRegistry resultProcessorRegistry) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.serializationService = (InternalSerializationService)this.nodeEngine.getSerializationService();
        this.partitionService = this.nodeEngine.getPartitionService();
        this.logger = this.nodeEngine.getLogger(this.getClass());
        this.queryResultSizeLimiter = new QueryResultSizeLimiter(mapServiceContext, this.logger);
        this.queryOptimizer = optimizer;
        this.operationService = this.nodeEngine.getOperationService();
        this.clusterService = this.nodeEngine.getClusterService();
        this.localMapStatsProvider = mapServiceContext.getLocalMapStatsProvider();
        this.partitionScanExecutor = partitionScanExecutor;
        this.resultProcessorRegistry = resultProcessorRegistry;
    }

    public Result run(Query query) throws ExecutionException, InterruptedException {
        int initialPartitionStateVersion = this.partitionService.getPartitionStateVersion();
        Collection<Integer> initialPartitions = this.mapServiceContext.getOwnedPartitions();
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(query.getMapName());
        Predicate predicate = this.queryOptimizer.optimize(query.getPredicate(), mapContainer.getIndexes());
        Collection<QueryableEntry> entries = this.runUsingIndexSafely(predicate, mapContainer, initialPartitionStateVersion);
        if (entries == null) {
            entries = this.runUsingPartitionScanSafely(query.getMapName(), predicate, initialPartitions, initialPartitionStateVersion);
        }
        this.updateStatistics(mapContainer);
        if (this.hasPartitionVersion(initialPartitionStateVersion, predicate)) {
            return this.populateTheResult(query, entries, initialPartitions);
        }
        return this.resultProcessorRegistry.get(query.getResultType()).populateResult(query, this.queryResultSizeLimiter.getNodeResultLimit(initialPartitions.size()));
    }

    protected Result populateTheResult(Query query, Collection<QueryableEntry> entries, Collection<Integer> initialPartitions) {
        ResultProcessor processor = this.resultProcessorRegistry.get(query.getResultType());
        return processor.populateResult(query, this.queryResultSizeLimiter.getNodeResultLimit(initialPartitions.size()), entries, initialPartitions);
    }

    protected Collection<QueryableEntry> runUsingIndexSafely(Predicate predicate, MapContainer mapContainer, int initialPartitionStateVersion) {
        if (this.hasOwnerMigrationsInFlight()) {
            return null;
        }
        Collection<QueryableEntry> entries = this.runUsingIndex(predicate, mapContainer);
        if (entries == null) {
            return null;
        }
        if (this.isResultSafe(initialPartitionStateVersion)) {
            return entries;
        }
        return null;
    }

    protected Collection<QueryableEntry> runUsingIndex(Predicate predicate, MapContainer mapContainer) {
        return mapContainer.getIndexes().query(predicate);
    }

    protected Collection<QueryableEntry> runUsingPartitionScanSafely(String name, Predicate predicate, Collection<Integer> partitions, int initialPartitionStateVersion) throws InterruptedException, ExecutionException {
        if (this.hasOwnerMigrationsInFlight()) {
            return null;
        }
        Collection<QueryableEntry> entries = this.partitionScanExecutor.execute(name, predicate, partitions);
        if (this.isResultSafe(initialPartitionStateVersion)) {
            return entries;
        }
        return null;
    }

    public Result runUsingPartitionScanOnSinglePartition(Query query, int partitionId) throws ExecutionException, InterruptedException {
        Collection<QueryableEntry> entries = this.doRunUsingPartitionScanOnSinglePartition(query.getMapName(), query.getPredicate(), partitionId);
        return this.populateTheResult(query, entries, Collections.singletonList(partitionId));
    }

    protected Collection<QueryableEntry> doRunUsingPartitionScanOnSinglePartition(String mapName, Predicate originalPredicate, int partitionId) throws ExecutionException, InterruptedException {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        Predicate predicate = this.queryOptimizer.optimize(originalPredicate, mapContainer.getIndexes());
        return this.partitionScanExecutor.execute(mapName, predicate, Collections.singletonList(partitionId));
    }

    protected boolean hasOwnerMigrationsInFlight() {
        return this.mapServiceContext.getService().getOwnerMigrationsInFlight() > 0;
    }

    protected boolean hasPartitionStateVersionChanged(int initialPartitionStateVersion) {
        return initialPartitionStateVersion != this.partitionService.getPartitionStateVersion();
    }

    protected boolean isResultSafe(int initialPartitionStateVersion) {
        return !this.hasOwnerMigrationsInFlight() && !this.hasPartitionStateVersionChanged(initialPartitionStateVersion);
    }

    protected boolean hasPartitionVersion(int expectedVersion, Predicate predicate) {
        if (this.hasPartitionStateVersionChanged(expectedVersion)) {
            this.logger.info("Partition assignments changed while executing query: " + predicate);
            return false;
        }
        return true;
    }

    protected void updateStatistics(MapContainer mapContainer) {
        if (mapContainer.getMapConfig().isStatisticsEnabled()) {
            LocalMapStatsImpl localStats = this.localMapStatsProvider.getLocalMapStatsImpl(mapContainer.getName());
            localStats.incrementOtherOperations();
        }
    }
}

