/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.hotrestart.BackupTaskState;
import com.hazelcast.hotrestart.BackupTaskStatus;
import com.hazelcast.monitor.HotRestartState;
import com.hazelcast.util.JsonUtil;

public class HotRestartStateImpl
implements HotRestartState {
    private BackupTaskStatus backupTaskStatus;

    public HotRestartStateImpl() {
    }

    public HotRestartStateImpl(BackupTaskStatus backupTaskStatus) {
        this.backupTaskStatus = backupTaskStatus;
    }

    @Override
    public BackupTaskStatus getBackupTaskStatus() {
        return this.backupTaskStatus;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("backupTaskState", this.backupTaskStatus.getState().name());
        root.add("backupTaskCompleted", this.backupTaskStatus.getCompleted());
        root.add("backupTaskTotal", this.backupTaskStatus.getTotal());
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        String jsonBackupTaskState = JsonUtil.getString(json, "backupTaskState", BackupTaskState.NOT_STARTED.name());
        int jsonBackupTaskCompleted = JsonUtil.getInt(json, "backupTaskCompleted", 0);
        int jsonBackupTaskTotal = JsonUtil.getInt(json, "backupTaskTotal", 0);
        this.backupTaskStatus = new BackupTaskStatus(BackupTaskState.valueOf(jsonBackupTaskState), jsonBackupTaskCompleted, jsonBackupTaskTotal);
    }

    public String toString() {
        return "HotRestartStateImpl{backupTaskStatus=" + this.backupTaskStatus + '}';
    }
}

