/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.monitor.NodeState;
import com.hazelcast.util.JsonUtil;
import com.hazelcast.version.ClusterVersion;
import com.hazelcast.version.MemberVersion;

public class NodeStateImpl
implements NodeState {
    private ClusterState clusterState;
    private com.hazelcast.instance.NodeState nodeState;
    private ClusterVersion clusterVersion;
    private MemberVersion memberVersion;

    public NodeStateImpl() {
    }

    public NodeStateImpl(ClusterState clusterState, com.hazelcast.instance.NodeState nodeState, ClusterVersion clusterVersion, MemberVersion memberVersion) {
        this.clusterState = clusterState;
        this.nodeState = nodeState;
        this.clusterVersion = clusterVersion;
        this.memberVersion = memberVersion;
    }

    @Override
    public ClusterState getClusterState() {
        return this.clusterState;
    }

    @Override
    public com.hazelcast.instance.NodeState getNodeState() {
        return this.nodeState;
    }

    @Override
    public ClusterVersion getClusterVersion() {
        return this.clusterVersion;
    }

    @Override
    public MemberVersion getMemberVersion() {
        return this.memberVersion;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("clusterState", this.clusterState.name());
        root.add("nodeState", this.nodeState.name());
        root.add("clusterVersion", this.clusterVersion.toString());
        root.add("memberVersion", this.memberVersion.toString());
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        String jsonClusterVersion;
        String jsonNodeState;
        String jsonClusterState = JsonUtil.getString(json, "clusterState", null);
        if (jsonClusterState != null) {
            this.clusterState = ClusterState.valueOf(jsonClusterState);
        }
        if ((jsonNodeState = JsonUtil.getString(json, "nodeState", null)) != null) {
            this.nodeState = com.hazelcast.instance.NodeState.valueOf(jsonNodeState);
        }
        if ((jsonClusterVersion = JsonUtil.getString(json, "clusterVersion", null)) != null) {
            this.clusterVersion = ClusterVersion.of(jsonClusterVersion);
        }
        String jsonNodeVersion = JsonUtil.getString(json, "memberVersion", null);
        if (jsonNodeState != null) {
            this.memberVersion = MemberVersion.of(jsonNodeVersion);
        }
    }

    public String toString() {
        return "NodeStateImpl{clusterState=" + (Object)((Object)this.clusterState) + ", nodeState=" + (Object)((Object)this.nodeState) + ", clusterVersion=" + this.clusterVersion + ", memberVersion=" + this.memberVersion + '}';
    }
}

