/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

public final class Version {
    public static final byte UNKNOWN_VERSION = -1;
    public static final Version UNKNOWN = new Version(-1);
    private byte value;

    public Version(int value) {
        this.value = (byte)value;
    }

    public byte getValue() {
        return this.value;
    }

    public boolean isEqualTo(Version version) {
        return this.value == version.value;
    }

    public boolean isGreaterThan(Version version) {
        return this.value > version.value;
    }

    public boolean isGreaterOrEqual(Version version) {
        return this.value >= version.value;
    }

    public boolean isLessThan(Version version) {
        return this.value < version.value;
    }

    public boolean isLessOrEqual(Version version) {
        return this.value <= version.value;
    }

    public boolean isBetween(Version from, Version to) {
        return this.value >= from.value && this.value <= to.value;
    }

    public boolean isUnknown() {
        return this.value == -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.value == version.value;
    }

    public int hashCode() {
        return this.value;
    }

    public static Version of(int value) {
        if (value == -1) {
            return UNKNOWN;
        }
        return new Version(value);
    }
}

