/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.logging.ILogger;
import com.hazelcast.scheduledexecutor.DuplicateTaskException;
import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import com.hazelcast.scheduledexecutor.ScheduledTaskStatistics;
import com.hazelcast.scheduledexecutor.StaleTaskException;
import com.hazelcast.scheduledexecutor.StatefulTask;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskDescriptor;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskHandlerImpl;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskStatisticsImpl;
import com.hazelcast.scheduledexecutor.impl.TaskDefinition;
import com.hazelcast.scheduledexecutor.impl.operations.ResultReadyNotifyOperation;
import com.hazelcast.scheduledexecutor.impl.operations.SyncStateOperation;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.impl.executionservice.InternalExecutionService;
import com.hazelcast.util.ExceptionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ScheduledExecutorContainer {
    protected final ConcurrentMap<String, ScheduledTaskDescriptor> tasks;
    private final ILogger logger;
    private final String name;
    private final NodeEngine nodeEngine;
    private final InternalExecutionService executionService;
    private final int partitionId;
    private final int durability;

    ScheduledExecutorContainer(String name, int partitionId, NodeEngine nodeEngine, int durability) {
        this(name, partitionId, nodeEngine, durability, new ConcurrentHashMap<String, ScheduledTaskDescriptor>());
    }

    ScheduledExecutorContainer(String name, int partitionId, NodeEngine nodeEngine, int durability, ConcurrentMap<String, ScheduledTaskDescriptor> tasks) {
        this.logger = nodeEngine.getLogger(this.getClass());
        this.name = name;
        this.nodeEngine = nodeEngine;
        this.executionService = (InternalExecutionService)nodeEngine.getExecutionService();
        this.partitionId = partitionId;
        this.durability = durability;
        this.tasks = tasks;
    }

    public ScheduledFuture schedule(TaskDefinition definition) {
        this.checkNotDuplicateTask(definition.getName());
        return this.createContextAndSchedule(definition);
    }

    public boolean cancel(String taskName) throws ExecutionException, InterruptedException {
        this.checkNotStaleTask(taskName);
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("[Scheduler: " + this.name + "][Partition: " + this.partitionId + "] Cancelling " + taskName);
        }
        ScheduledTaskDescriptor descriptor = (ScheduledTaskDescriptor)this.tasks.get(taskName);
        boolean cancelled = descriptor.getScheduledFuture().cancel(true);
        if (TaskDefinition.Type.SINGLE_RUN.equals((Object)descriptor.getDefinition().getType())) {
            cancelled = ((Future)descriptor.getScheduledFuture().get()).cancel(true);
        }
        return cancelled;
    }

    public Object get(String taskName) throws ExecutionException, InterruptedException {
        this.checkNotStaleTask(taskName);
        ScheduledTaskDescriptor descriptor = (ScheduledTaskDescriptor)this.tasks.get(taskName);
        if (TaskDefinition.Type.SINGLE_RUN.equals((Object)descriptor.getDefinition().getType())) {
            return ((Future)descriptor.getScheduledFuture().get()).get();
        }
        return descriptor.getScheduledFuture().get();
    }

    public long getDelay(String taskName, TimeUnit unit) {
        this.checkNotStaleTask(taskName);
        ScheduledTaskDescriptor descriptor = (ScheduledTaskDescriptor)this.tasks.get(taskName);
        return descriptor.getScheduledFuture().getDelay(unit);
    }

    public ScheduledTaskStatistics getStatistics(String taskName) {
        this.checkNotStaleTask(taskName);
        ScheduledTaskDescriptor descriptor = (ScheduledTaskDescriptor)this.tasks.get(taskName);
        return descriptor.getStatsSnapshot();
    }

    public boolean isCancelled(String taskName) throws ExecutionException, InterruptedException {
        this.checkNotStaleTask(taskName);
        ScheduledTaskDescriptor descriptor = (ScheduledTaskDescriptor)this.tasks.get(taskName);
        if (TaskDefinition.Type.SINGLE_RUN.equals((Object)descriptor.getDefinition().getType())) {
            return ((Future)descriptor.getScheduledFuture().get()).isCancelled();
        }
        return descriptor.getScheduledFuture().isCancelled();
    }

    public boolean isDone(String taskName) throws ExecutionException, InterruptedException {
        this.checkNotStaleTask(taskName);
        ScheduledTaskDescriptor descriptor = (ScheduledTaskDescriptor)this.tasks.get(taskName);
        if (TaskDefinition.Type.SINGLE_RUN.equals((Object)descriptor.getDefinition().getType())) {
            return ((Future)descriptor.getScheduledFuture().get()).isDone();
        }
        return descriptor.getScheduledFuture().isDone();
    }

    public void destroy() {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("[Scheduler: " + this.name + "][Partition: " + this.partitionId + "] Destroying container...");
        }
        for (ScheduledTaskDescriptor descriptor : this.tasks.values()) {
            if (descriptor.getScheduledFuture() == null) continue;
            try {
                descriptor.getScheduledFuture().cancel(true);
            }
            catch (Exception ex) {
                this.logger.warning("[Scheduler: " + this.name + "][Partition: " + this.partitionId + "] " + "Destroying " + descriptor.getDefinition().getName() + " error: ", ex);
            }
        }
    }

    public void dispose(String taskName) throws ExecutionException, InterruptedException {
        ScheduledTaskDescriptor descriptor;
        ScheduledFuture<?> scheduledFuture;
        this.checkNotStaleTask(taskName);
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("[Scheduler: " + this.name + "][Partition: " + this.partitionId + "] Disposing " + taskName);
        }
        if (!(scheduledFuture = (descriptor = (ScheduledTaskDescriptor)this.tasks.get(taskName)).getScheduledFuture()).isDone()) {
            if (TaskDefinition.Type.SINGLE_RUN.equals((Object)descriptor.getDefinition().getType())) {
                ((Future)scheduledFuture.get()).cancel(true);
            }
            scheduledFuture.cancel(true);
        }
        this.tasks.remove(taskName);
    }

    public void stash(TaskDefinition definition) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("[Backup Scheduler: " + this.name + "][Partition: " + this.partitionId + "] Stashing " + definition);
        }
        if (!this.tasks.containsKey(definition.getName())) {
            ScheduledTaskDescriptor descriptor = new ScheduledTaskDescriptor(definition);
            this.tasks.put(definition.getName(), descriptor);
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("[Backup Scheduler: " + this.name + "][Partition: " + this.partitionId + "] Stash size: " + this.tasks.size());
        }
    }

    public void unstash(String taskName) {
        this.tasks.remove(taskName);
    }

    public Collection<ScheduledTaskDescriptor> getTasks() {
        return this.tasks.values();
    }

    public void syncState(String taskName, Map newState, ScheduledTaskStatisticsImpl stats) throws ExecutionException, InterruptedException {
        ScheduledTaskDescriptor descriptor = (ScheduledTaskDescriptor)this.tasks.get(taskName);
        if (descriptor == null) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("[Scheduler: " + this.name + "][Partition: " + this.partitionId + "] syncState attempt " + "but no descriptor found for task: " + taskName);
            }
            return;
        }
        descriptor.setState(newState);
        descriptor.setStats(stats);
    }

    public boolean shouldParkGetResult(String taskName) throws ExecutionException, InterruptedException {
        if (!this.tasks.containsKey(taskName)) {
            return false;
        }
        return ((ScheduledTaskDescriptor)this.tasks.get(taskName)).getScheduledFuture() == null || !this.isDone(taskName);
    }

    public int getDurability() {
        return this.durability;
    }

    public String getName() {
        return this.name;
    }

    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    public ScheduledTaskHandler offprintHandler(String taskName) {
        return ScheduledTaskHandlerImpl.of(this.partitionId, this.getName(), taskName);
    }

    ScheduledFuture createContextAndSchedule(TaskDefinition definition) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("[Scheduler: " + this.name + "][Partition: " + this.partitionId + "] Scheduling " + definition);
        }
        ScheduledTaskDescriptor descriptor = new ScheduledTaskDescriptor(definition);
        if (this.tasks.putIfAbsent(definition.getName(), descriptor) == null) {
            this.doSchedule(descriptor);
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("[Scheduler: " + this.name + "][Partition: " + this.partitionId + "] Queue size: " + this.tasks.size());
        }
        return descriptor.getScheduledFuture();
    }

    void promoteStash() {
        for (ScheduledTaskDescriptor descriptor : this.tasks.values()) {
            if (descriptor.getScheduledFuture() != null) continue;
            this.doSchedule(descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, ScheduledTaskDescriptor> prepareForReplication(boolean migrationMode) {
        HashMap<String, ScheduledTaskDescriptor> replicas = new HashMap<String, ScheduledTaskDescriptor>();
        for (ScheduledTaskDescriptor descriptor : this.tasks.values()) {
            try {
                ScheduledTaskDescriptor replica = new ScheduledTaskDescriptor(descriptor.getDefinition(), descriptor.getStateSnapshot(), descriptor.getStatsSnapshot());
                replicas.put(descriptor.getDefinition().getName(), replica);
            }
            finally {
                if (!migrationMode) continue;
                descriptor.getScheduledFuture().cancel(true);
                descriptor.setScheduledFuture(null);
            }
        }
        return replicas;
    }

    void checkNotDuplicateTask(String taskName) {
        if (this.tasks.containsKey(taskName)) {
            throw new DuplicateTaskException("There is already a task with the same name '" + taskName + "' in '" + this.getName() + "'");
        }
    }

    protected void publishTaskState(String taskName, Map stateSnapshot, ScheduledTaskStatisticsImpl statsSnapshot) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("[Scheduler: " + this.name + "][Partition: " + this.partitionId + "][Task: " + taskName + "] " + "Publishing state, to replicas. State: " + stateSnapshot);
        }
        SyncStateOperation op = new SyncStateOperation(this.getName(), taskName, stateSnapshot, statsSnapshot);
        this.createInvocationBuilder(op).invoke().join();
    }

    protected InvocationBuilder createInvocationBuilder(Operation op) {
        OperationService operationService = this.nodeEngine.getOperationService();
        return operationService.createInvocationBuilder("hz:impl:scheduledExecutorService", op, this.partitionId);
    }

    private <V> void doSchedule(ScheduledTaskDescriptor descriptor) {
        ScheduledFuture<Future<Object>> future;
        assert (descriptor.getScheduledFuture() == null);
        TaskDefinition definition = descriptor.getDefinition();
        switch (definition.getType()) {
            case SINGLE_RUN: {
                TaskRunner runner = new TaskRunner(descriptor);
                future = this.executionService.scheduleDurable(this.name, runner, definition.getInitialDelay(), definition.getUnit());
                break;
            }
            case AT_FIXED_RATE: {
                TaskRunner runner = new TaskRunner(descriptor);
                future = this.executionService.scheduleDurableWithRepetition(this.name, runner, definition.getInitialDelay(), definition.getPeriod(), definition.getUnit());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        descriptor.setScheduledFuture(future);
    }

    private void checkNotStaleTask(String taskName) {
        if (!this.tasks.containsKey(taskName)) {
            throw new StaleTaskException("Task with name " + taskName + " not found. ");
        }
    }

    private class TaskRunner<V>
    implements Callable<V>,
    Runnable {
        private final String taskName;
        private final Callable<V> original;
        private final ScheduledTaskDescriptor descriptor;
        private final ScheduledTaskStatisticsImpl statistics;
        private boolean initted;

        TaskRunner(ScheduledTaskDescriptor descriptor) {
            this.descriptor = descriptor;
            this.original = descriptor.getDefinition().getCommand();
            this.taskName = descriptor.getDefinition().getName();
            this.statistics = descriptor.getStatsSnapshot();
        }

        @Override
        public V call() throws Exception {
            this.beforeRun();
            try {
                V v = this.original.call();
                return v;
            }
            finally {
                this.afterRun();
            }
        }

        @Override
        public void run() {
            try {
                this.call();
            }
            catch (Exception e) {
                ExceptionUtil.sneakyThrow(e);
            }
        }

        private void initOnce() {
            if (this.initted) {
                return;
            }
            Map<?, ?> snapshot = this.descriptor.getStateSnapshot();
            if (this.original instanceof StatefulTask && !snapshot.isEmpty()) {
                ((StatefulTask)((Object)this.original)).load(snapshot);
            }
            this.initted = true;
        }

        private void beforeRun() {
            if (ScheduledExecutorContainer.this.logger.isFinestEnabled()) {
                ScheduledExecutorContainer.this.logger.finest("[Scheduler: " + ScheduledExecutorContainer.this.name + "][Partition: " + ScheduledExecutorContainer.this.partitionId + "][Task: " + this.taskName + "] " + "Entering running mode.");
            }
            try {
                this.initOnce();
                this.statistics.onBeforeRun();
            }
            catch (Exception ex) {
                ScheduledExecutorContainer.this.logger.warning("[Scheduler: " + ScheduledExecutorContainer.this.name + "][Partition: " + ScheduledExecutorContainer.this.partitionId + "][Task: " + this.taskName + "] " + "Unexpected exception during beforeRun occurred: ", ex);
            }
        }

        private void afterRun() {
            try {
                this.statistics.onAfterRun();
                HashMap state = new HashMap();
                if (this.original instanceof StatefulTask) {
                    ((StatefulTask)((Object)this.original)).save(state);
                }
                ScheduledExecutorContainer.this.publishTaskState(this.taskName, state, this.statistics);
            }
            catch (Exception ex) {
                ScheduledExecutorContainer.this.logger.warning("[Scheduler: " + ScheduledExecutorContainer.this.name + "][Partition: " + ScheduledExecutorContainer.this.partitionId + "][Task: " + this.taskName + "] " + "Unexpected exception during afterRun occurred: ", ex);
            }
            finally {
                this.notifyResultReady();
            }
            if (ScheduledExecutorContainer.this.logger.isFinestEnabled()) {
                ScheduledExecutorContainer.this.logger.finest("[Scheduler: " + ScheduledExecutorContainer.this.name + "][Partition: " + ScheduledExecutorContainer.this.partitionId + "][Task: " + this.taskName + "] " + "Exiting running mode.");
            }
        }

        private void notifyResultReady() {
            ResultReadyNotifyOperation op = new ResultReadyNotifyOperation(ScheduledExecutorContainer.this.offprintHandler(this.taskName));
            ScheduledExecutorContainer.this.createInvocationBuilder(op).setCallTimeout(Long.MAX_VALUE).invoke();
        }
    }
}

