/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorContainer;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorContainerHolder;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorMemberOwnedContainer;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.executionservice.InternalExecutionService;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ScheduledExecutorMemberBin
implements ScheduledExecutorContainerHolder {
    private final NodeEngine nodeEngine;
    private final ConcurrentMap<String, ScheduledExecutorContainer> containers = new ConcurrentHashMap<String, ScheduledExecutorContainer>();
    private final ConstructorFunction<String, ScheduledExecutorContainer> containerConstructorFunction = new ConstructorFunction<String, ScheduledExecutorContainer>(){

        @Override
        public ScheduledExecutorContainer createNew(String name) {
            return new ScheduledExecutorMemberOwnedContainer(name, ScheduledExecutorMemberBin.this.nodeEngine);
        }
    };

    public ScheduledExecutorMemberBin(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
    }

    @Override
    public ScheduledExecutorContainer getOrCreateContainer(String name) {
        Preconditions.checkNotNull(name, "Name can't be null");
        return ConcurrencyUtil.getOrPutIfAbsent(this.containers, name, this.containerConstructorFunction);
    }

    @Override
    public Collection<ScheduledExecutorContainer> getContainers() {
        return Collections.unmodifiableCollection(this.containers.values());
    }

    public void destroy() {
        for (ScheduledExecutorContainer container : this.containers.values()) {
            ((InternalExecutionService)this.nodeEngine.getExecutionService()).shutdownScheduledDurableExecutor(container.getName());
        }
    }
}

