/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorContainer;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorContainerHolder;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskDescriptor;
import com.hazelcast.scheduledexecutor.impl.operations.ReplicationOperation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.executionservice.InternalExecutionService;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ScheduledExecutorPartition
implements ScheduledExecutorContainerHolder {
    private final ILogger logger;
    private final int partitionId;
    private final NodeEngine nodeEngine;
    private final ConcurrentMap<String, ScheduledExecutorContainer> containers = new ConcurrentHashMap<String, ScheduledExecutorContainer>();
    private final ConstructorFunction<String, ScheduledExecutorContainer> containerConstructorFunction = new ConstructorFunction<String, ScheduledExecutorContainer>(){

        @Override
        public ScheduledExecutorContainer createNew(String name) {
            ScheduledExecutorConfig config = ScheduledExecutorPartition.this.nodeEngine.getConfig().findScheduledExecutorConfig(name);
            return new ScheduledExecutorContainer(name, ScheduledExecutorPartition.this.partitionId, ScheduledExecutorPartition.this.nodeEngine, config.getDurability());
        }
    };

    public ScheduledExecutorPartition(NodeEngine nodeEngine, int partitionId) {
        this.logger = nodeEngine.getLogger(this.getClass());
        this.partitionId = partitionId;
        this.nodeEngine = nodeEngine;
    }

    public void createContainer(String name, ConcurrentMap<String, ScheduledTaskDescriptor> tasks) {
        Preconditions.checkNotNull(name, "Name can't be null");
        Preconditions.checkNotNull(tasks, "Tasks info can't be null");
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Creating Scheduled Executor partition with name: " + name);
        }
        ScheduledExecutorConfig config = this.nodeEngine.getConfig().findScheduledExecutorConfig(name);
        ScheduledExecutorContainer container = new ScheduledExecutorContainer(name, this.partitionId, this.nodeEngine, config.getDurability(), tasks);
        this.containers.put(name, container);
    }

    @Override
    public Collection<ScheduledExecutorContainer> getContainers() {
        return Collections.unmodifiableCollection(this.containers.values());
    }

    @Override
    public ScheduledExecutorContainer getOrCreateContainer(String name) {
        Preconditions.checkNotNull(name, "Name can't be null");
        return ConcurrencyUtil.getOrPutIfAbsent(this.containers, name, this.containerConstructorFunction);
    }

    public void destroy() {
        for (ScheduledExecutorContainer container : this.containers.values()) {
            ((InternalExecutionService)this.nodeEngine.getExecutionService()).shutdownScheduledDurableExecutor(container.getName());
        }
    }

    public Operation prepareReplicationOperation(int replicaIndex, boolean migrationMode) {
        HashMap<String, Map<String, ScheduledTaskDescriptor>> map = new HashMap<String, Map<String, ScheduledTaskDescriptor>>();
        for (ScheduledExecutorContainer container : this.containers.values()) {
            if (replicaIndex > container.getDurability()) continue;
            map.put(container.getName(), container.prepareForReplication(migrationMode));
        }
        return new ReplicationOperation(map);
    }

    void disposeObsoleteReplicas(int thresholdReplicaIndex) {
        if (thresholdReplicaIndex < 0) {
            for (ScheduledExecutorContainer container : this.containers.values()) {
                container.destroy();
            }
            this.containers.clear();
        } else {
            Iterator iterator = this.containers.values().iterator();
            while (iterator.hasNext()) {
                ScheduledExecutorContainer container = (ScheduledExecutorContainer)iterator.next();
                if (thresholdReplicaIndex <= container.getDurability()) continue;
                container.destroy();
                iterator.remove();
            }
        }
    }

    void promoteStash() {
        for (ScheduledExecutorContainer container : this.containers.values()) {
            container.promoteStash();
        }
    }
}

