/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.MembershipAdapter;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.PartitionLostEvent;
import com.hazelcast.partition.PartitionLostListener;
import com.hazelcast.scheduledexecutor.IScheduledFuture;
import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import com.hazelcast.scheduledexecutor.ScheduledTaskStatistics;
import com.hazelcast.scheduledexecutor.StaleTaskException;
import com.hazelcast.scheduledexecutor.impl.operations.CancelTaskOperation;
import com.hazelcast.scheduledexecutor.impl.operations.DisposeTaskOperation;
import com.hazelcast.scheduledexecutor.impl.operations.GetDelayOperation;
import com.hazelcast.scheduledexecutor.impl.operations.GetResultOperation;
import com.hazelcast.scheduledexecutor.impl.operations.GetStatisticsOperation;
import com.hazelcast.scheduledexecutor.impl.operations.IsCanceledOperation;
import com.hazelcast.scheduledexecutor.impl.operations.IsDoneOperation;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.util.Preconditions;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ScheduledFutureProxy<V>
implements IScheduledFuture<V>,
HazelcastInstanceAware,
PartitionLostListener {
    private transient HazelcastInstance instance;
    private transient String partitionLostRegistration;
    private transient String membershipListenerRegistration;
    private transient boolean partitionLost;
    private transient boolean memberLost;
    private ScheduledTaskHandler handler;

    public ScheduledFutureProxy() {
    }

    public ScheduledFutureProxy(ScheduledTaskHandler handler) {
        this.handler = handler;
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.unRegisterPartitionListenerIfExists();
        this.unRegisterMembershipListenerIfExists();
        this.instance = hazelcastInstance;
        this.registerPartitionListener();
        this.registerMembershipListener();
    }

    @Override
    public ScheduledTaskHandler getHandler() {
        return this.handler;
    }

    @Override
    public ScheduledTaskStatistics getStats() {
        this.checkAccessibleHandler();
        this.checkAccessibleOwner();
        GetStatisticsOperation op = new GetStatisticsOperation(this.handler);
        return (ScheduledTaskStatistics)this.invoke(op).join();
    }

    @Override
    public long getDelay(TimeUnit unit) {
        Preconditions.checkNotNull(unit, "Unit is null");
        this.checkAccessibleHandler();
        this.checkAccessibleOwner();
        GetDelayOperation op = new GetDelayOperation(this.handler, unit);
        return (Long)this.invoke(op).join();
    }

    @Override
    public int compareTo(Delayed o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (mayInterruptIfRunning) {
            throw new UnsupportedOperationException("mayInterruptIfRunning flag is not supported.");
        }
        this.checkAccessibleHandler();
        this.checkAccessibleOwner();
        CancelTaskOperation op = new CancelTaskOperation(this.handler, mayInterruptIfRunning);
        return (Boolean)this.invoke(op).join();
    }

    @Override
    public boolean isCancelled() {
        this.checkAccessibleHandler();
        this.checkAccessibleOwner();
        IsCanceledOperation op = new IsCanceledOperation(this.handler);
        return (Boolean)this.invoke(op).join();
    }

    @Override
    public boolean isDone() {
        this.checkAccessibleHandler();
        this.checkAccessibleOwner();
        IsDoneOperation op = new IsDoneOperation(this.handler);
        return (Boolean)this.invoke(op).join();
    }

    private InternalCompletableFuture<V> get0() {
        this.checkAccessibleHandler();
        this.checkAccessibleOwner();
        GetResultOperation op = new GetResultOperation(this.handler);
        return this.invoke(op);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.get0().join();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        Preconditions.checkNotNull(unit, "Unit is null");
        return this.get0().get(timeout, unit);
    }

    @Override
    public void dispose() {
        this.checkAccessibleHandler();
        this.checkAccessibleOwner();
        this.unRegisterPartitionListenerIfExists();
        this.unRegisterMembershipListenerIfExists();
        DisposeTaskOperation op = new DisposeTaskOperation(this.handler);
        InternalCompletableFuture<V> future = this.invoke(op);
        this.handler = null;
        future.join();
    }

    @Override
    public void partitionLost(PartitionLostEvent event) {
        if (this.handler.getPartitionId() == event.getPartitionId() && event.getLostBackupCount() == this.instance.getConfig().getScheduledExecutorConfig(this.handler.getSchedulerName()).getDurability()) {
            this.unRegisterPartitionListenerIfExists();
            this.partitionLost = true;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduledFutureProxy proxy = (ScheduledFutureProxy)o;
        return this.handler != null ? this.handler.equals(proxy.handler) : proxy.handler == null;
    }

    public int hashCode() {
        return this.handler != null ? this.handler.hashCode() : 0;
    }

    private void registerPartitionListener() {
        if (this.handler.isAssignedToPartition()) {
            this.partitionLostRegistration = this.instance.getPartitionService().addPartitionLostListener(this);
        }
    }

    private void unRegisterPartitionListenerIfExists() {
        if (this.partitionLostRegistration != null) {
            this.instance.getPartitionService().removePartitionLostListener(this.partitionLostRegistration);
        }
    }

    private void registerMembershipListener() {
        if (this.handler.isAssignedToMember()) {
            this.membershipListenerRegistration = this.instance.getCluster().addMembershipListener(new MembershipAdapter(){

                @Override
                public void memberRemoved(MembershipEvent membershipEvent) {
                    if (membershipEvent.getMember().getAddress().equals(ScheduledFutureProxy.this.handler.getAddress())) {
                        ScheduledFutureProxy.this.memberLost = true;
                    }
                }
            });
        }
    }

    private void unRegisterMembershipListenerIfExists() {
        if (this.membershipListenerRegistration != null) {
            this.instance.getCluster().removeMembershipListener(this.membershipListenerRegistration);
        }
    }

    private void checkAccessibleOwner() {
        if (this.handler.isAssignedToPartition()) {
            if (this.partitionLost) {
                throw new IllegalStateException("Partition holding this Scheduled task was lost along with all backups.");
            }
        } else if (this.memberLost) {
            throw new IllegalStateException("Member holding this Scheduled task was removed from the cluster.");
        }
    }

    private void checkAccessibleHandler() {
        if (this.handler == null) {
            throw new StaleTaskException("Scheduled task was previously disposed.");
        }
    }

    private <V> InternalCompletableFuture<V> invoke(Operation op) {
        if (this.handler.isAssignedToPartition()) {
            op.setPartitionId(this.handler.getPartitionId());
            return this.invokeOnPartition(op);
        }
        return this.invokeOnAddress(op, this.handler.getAddress());
    }

    private <V> InternalCompletableFuture<V> invokeOnPartition(Operation op) {
        InternalOperationService opService = ((HazelcastInstanceImpl)this.instance).node.getNodeEngine().getOperationService();
        return opService.invokeOnPartition(op);
    }

    private <V> InternalCompletableFuture<V> invokeOnAddress(Operation op, Address address) {
        InternalOperationService opService = ((HazelcastInstanceImpl)this.instance).node.getNodeEngine().getOperationService();
        return opService.invokeOnTarget(op.getServiceName(), op, address);
    }
}

