/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorDataSerializerHook;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskStatisticsImpl;
import com.hazelcast.scheduledexecutor.impl.TaskDefinition;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicReference;

public class ScheduledTaskDescriptor
implements IdentifiedDataSerializable {
    private TaskDefinition definition;
    private ScheduledFuture<?> scheduledFuture;
    private AtomicReference<ScheduledTaskStatisticsImpl> stats = new AtomicReference<Object>(null);
    private Map<?, ?> state;

    public ScheduledTaskDescriptor() {
    }

    public ScheduledTaskDescriptor(TaskDefinition definition) {
        this.definition = definition;
        this.state = new HashMap();
        this.stats.set(new ScheduledTaskStatisticsImpl());
    }

    public ScheduledTaskDescriptor(TaskDefinition definition, Map<?, ?> state, ScheduledTaskStatisticsImpl stats) {
        this.definition = definition;
        this.stats.set(stats);
        this.state = state;
    }

    public TaskDefinition getDefinition() {
        return this.definition;
    }

    ScheduledTaskStatisticsImpl getStatsSnapshot() {
        return this.stats.get().snapshot();
    }

    void setStats(ScheduledTaskStatisticsImpl stats) {
        this.stats.set(stats);
    }

    Map<?, ?> getStateSnapshot() {
        return new HashMap(this.state);
    }

    void setState(Map<?, ?> snapshot) {
        this.state = snapshot;
    }

    ScheduledFuture<?> getScheduledFuture() {
        return this.scheduledFuture;
    }

    void setScheduledFuture(ScheduledFuture<?> future) {
        this.scheduledFuture = future;
    }

    @Override
    public int getFactoryId() {
        return ScheduledExecutorDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 2;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.definition);
        out.writeObject(this.state);
        out.writeObject(this.stats.get());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.definition = (TaskDefinition)in.readObject();
        this.state = (Map)in.readObject();
        this.stats.set((ScheduledTaskStatisticsImpl)in.readObject());
    }

    public String toString() {
        return "ScheduledTaskDescriptor{definition=" + this.definition + ", scheduledFuture=" + this.scheduledFuture + ", stats=" + this.stats + ", state=" + this.state + '}';
    }
}

