/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.scheduledexecutor.ScheduledTaskStatistics;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorDataSerializerHook;
import com.hazelcast.scheduledexecutor.impl.TaskLifecycleListener;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class ScheduledTaskStatisticsImpl
implements ScheduledTaskStatistics,
TaskLifecycleListener {
    private static final TimeUnit MEASUREMENT_UNIT = TimeUnit.NANOSECONDS;
    private long runs;
    private long createdAt = System.nanoTime();
    private long firstRunStart;
    private long lastRunStart;
    private long lastRunEnd;
    private long lastIdleTime;
    private long totalRunTime;
    private long totalIdleTime;

    public ScheduledTaskStatisticsImpl() {
    }

    public ScheduledTaskStatisticsImpl(ScheduledTaskStatistics copy) {
        this(copy.getTotalRuns(), copy.getFirstRunStartNanos(), copy.getLastRunStartNanos(), copy.getLastRunEndNanos(), copy.getLastIdleTime(MEASUREMENT_UNIT), copy.getTotalRunTime(MEASUREMENT_UNIT), copy.getTotalIdleTime(MEASUREMENT_UNIT));
    }

    public ScheduledTaskStatisticsImpl(long runs, long firstRunStartNanos, long lastRunStartNanos, long lastRunEndNanos, long lastIdleTimeNanos, long totalRunTimeNanos, long totalIdleTimeNanos) {
        this.runs = runs;
        this.firstRunStart = firstRunStartNanos;
        this.lastRunStart = lastRunStartNanos;
        this.lastRunEnd = lastRunEndNanos;
        this.lastIdleTime = lastIdleTimeNanos;
        this.totalRunTime = totalRunTimeNanos;
        this.totalIdleTime = totalIdleTimeNanos;
    }

    @Override
    public long getTotalRuns() {
        return this.runs;
    }

    @Override
    public long getCreatedAtNanos() {
        return this.createdAt;
    }

    @Override
    public long getFirstRunStartNanos() {
        return this.firstRunStart;
    }

    @Override
    public long getLastRunStartNanos() {
        return this.lastRunStart;
    }

    @Override
    public long getLastRunEndNanos() {
        return this.lastRunEnd;
    }

    @Override
    public long getLastRunDuration(TimeUnit unit) {
        long duration = this.lastRunEnd - this.lastRunStart;
        return unit.convert(duration, MEASUREMENT_UNIT);
    }

    @Override
    public long getLastIdleTime(TimeUnit unit) {
        return unit.convert(this.lastIdleTime, MEASUREMENT_UNIT);
    }

    @Override
    public long getTotalIdleTime(TimeUnit unit) {
        return unit.convert(this.totalIdleTime, MEASUREMENT_UNIT);
    }

    @Override
    public long getTotalRunTime(TimeUnit unit) {
        return unit.convert(this.totalRunTime, MEASUREMENT_UNIT);
    }

    @Override
    public int getFactoryId() {
        return ScheduledExecutorDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 16;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.runs);
        out.writeLong(this.createdAt);
        out.writeLong(this.firstRunStart);
        out.writeLong(this.lastRunStart);
        out.writeLong(this.lastRunEnd);
        out.writeLong(this.lastIdleTime);
        out.writeLong(this.totalIdleTime);
        out.writeLong(this.totalRunTime);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.runs = in.readLong();
        this.createdAt = in.readLong();
        this.firstRunStart = in.readLong();
        this.lastRunStart = in.readLong();
        this.lastRunEnd = in.readLong();
        this.lastIdleTime = in.readLong();
        this.totalIdleTime = in.readLong();
        this.totalRunTime = in.readLong();
    }

    @Override
    public void onBeforeRun() {
        long now;
        this.lastRunStart = now = System.nanoTime();
        this.lastIdleTime = now - (this.lastRunEnd != 0L ? this.lastRunEnd : this.createdAt);
        this.totalIdleTime += this.lastIdleTime;
        if (this.firstRunStart == 0L) {
            this.firstRunStart = this.lastRunStart;
        }
    }

    @Override
    public void onAfterRun() {
        long now = System.nanoTime();
        long lastRunTime = now - this.lastRunStart;
        this.lastRunEnd = now;
        ++this.runs;
        this.totalRunTime += lastRunTime;
    }

    public ScheduledTaskStatisticsImpl snapshot() {
        return new ScheduledTaskStatisticsImpl(this);
    }

    public String toString() {
        return "ScheduledTaskStatisticsImpl{ runs=" + this.runs + ", createdAt=" + this.createdAt + ", firstRunStart=" + this.firstRunStart + ", lastRunStart=" + this.lastRunStart + ", lastRunEnd=" + this.lastRunEnd + ", lastIdleTime=" + this.lastIdleTime + ", totalRunTime=" + this.totalRunTime + ", totalIdleTime=" + this.totalIdleTime + '}';
    }
}

