/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl.operations;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.scheduledexecutor.impl.DistributedScheduledExecutorService;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorDataSerializerHook;
import com.hazelcast.scheduledexecutor.impl.ScheduledExecutorPartition;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskDescriptor;
import com.hazelcast.scheduledexecutor.impl.operations.AbstractSchedulerOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReplicationOperation
extends AbstractSchedulerOperation {
    private Map<String, Map<String, ScheduledTaskDescriptor>> map;

    public ReplicationOperation() {
    }

    public ReplicationOperation(Map<String, Map<String, ScheduledTaskDescriptor>> map) {
        this.map = map;
    }

    @Override
    public void run() throws Exception {
        DistributedScheduledExecutorService service = (DistributedScheduledExecutorService)this.getService();
        ScheduledExecutorPartition partition = service.getPartition(this.getPartitionId());
        for (Map.Entry<String, Map<String, ScheduledTaskDescriptor>> entry : this.map.entrySet()) {
            partition.createContainer(entry.getKey(), new ConcurrentHashMap<String, ScheduledTaskDescriptor>(entry.getValue()));
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeInt(this.map.size());
        for (Map.Entry<String, Map<String, ScheduledTaskDescriptor>> entry : this.map.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeInt(entry.getValue().size());
            for (Map.Entry<String, ScheduledTaskDescriptor> subEntry : entry.getValue().entrySet()) {
                out.writeUTF(subEntry.getKey());
                out.writeObject(subEntry.getValue());
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int size = in.readInt();
        this.map = new HashMap<String, Map<String, ScheduledTaskDescriptor>>(size);
        for (int i = 0; i < size; ++i) {
            String key = in.readUTF();
            int subSize = in.readInt();
            HashMap<String, ScheduledTaskDescriptor> subMap = new HashMap<String, ScheduledTaskDescriptor>(subSize);
            this.map.put(key, subMap);
            for (int k = 0; k < subSize; ++k) {
                subMap.put(in.readUTF(), (ScheduledTaskDescriptor)in.readObject());
            }
        }
    }

    @Override
    public int getFactoryId() {
        return ScheduledExecutorDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 19;
    }
}

