/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl.operations;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskStatisticsImpl;
import com.hazelcast.scheduledexecutor.impl.operations.AbstractSchedulerOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SyncBackupStateOperation
extends AbstractSchedulerOperation {
    private String taskName;
    private Map<Object, Object> state;
    private ScheduledTaskStatisticsImpl stats;

    public SyncBackupStateOperation() {
    }

    public SyncBackupStateOperation(String schedulerName, String taskName, Map state, ScheduledTaskStatisticsImpl stats) {
        super(schedulerName);
        this.taskName = taskName;
        this.state = state;
        this.stats = stats;
    }

    @Override
    public void run() throws Exception {
        this.getContainer().syncState(this.taskName, this.state, this.stats);
    }

    @Override
    public int getId() {
        return 18;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.taskName);
        out.writeInt(this.state.size());
        for (Map.Entry<Object, Object> entry : this.state.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeObject(this.stats);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.taskName = in.readUTF();
        int stateSize = in.readInt();
        this.state = new HashMap<Object, Object>(stateSize);
        for (int i = 0; i < stateSize; ++i) {
            this.state.put(in.readObject(), in.readObject());
        }
        this.stats = (ScheduledTaskStatisticsImpl)in.readObject();
    }
}

