/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.util.concurrent.BackoffIdleStrategy;
import com.hazelcast.util.concurrent.IdleStrategy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

abstract class CallIdSequence {
    CallIdSequence() {
    }

    abstract int getMaxConcurrentInvocations();

    abstract long next(boolean var1) throws TimeoutException;

    abstract void complete();

    abstract long getLastCallId();

    static final class CallIdSequenceWithBackpressure
    extends CallIdSequence {
        static final int MAX_DELAY_MS = 500;
        private static final IdleStrategy IDLER = new BackoffIdleStrategy(0L, 0L, TimeUnit.MILLISECONDS.toNanos(1L), TimeUnit.MILLISECONDS.toNanos(500L));
        private static final int INDEX_HEAD = 7;
        private static final int INDEX_TAIL = 15;
        private final AtomicLongArray longs = new AtomicLongArray(24);
        private final int maxConcurrentInvocations;
        private final long backoffTimeoutMs;

        CallIdSequenceWithBackpressure(int maxConcurrentInvocations, long backoffTimeoutMs) {
            this.maxConcurrentInvocations = maxConcurrentInvocations;
            this.backoffTimeoutMs = backoffTimeoutMs;
        }

        @Override
        public long getLastCallId() {
            return this.longs.get(7);
        }

        @Override
        public int getMaxConcurrentInvocations() {
            return this.maxConcurrentInvocations;
        }

        @Override
        public long next(boolean isUrgent) throws TimeoutException {
            if (!isUrgent && !this.hasSpace()) {
                this.waitForSpace();
            }
            return this.next();
        }

        @Override
        public void complete() {
            long newTail = this.longs.incrementAndGet(15);
            assert (newTail <= this.longs.get(7));
        }

        long getTail() {
            return this.longs.get(15);
        }

        private long next() {
            return this.longs.incrementAndGet(7);
        }

        private boolean hasSpace() {
            return this.longs.get(7) - this.longs.get(15) < (long)this.maxConcurrentInvocations;
        }

        private void waitForSpace() throws TimeoutException {
            long deadline = System.currentTimeMillis() + this.backoffTimeoutMs;
            long idleCount = 0L;
            while (true) {
                IDLER.idle(idleCount);
                if (this.hasSpace()) {
                    return;
                }
                if (System.currentTimeMillis() >= deadline) {
                    throw new TimeoutException(String.format("Timed out trying to acquire another call ID. maxConcurrentInvocations = %d, backoffTimeout = %d", this.maxConcurrentInvocations, this.backoffTimeoutMs));
                }
                ++idleCount;
            }
        }
    }

    static final class CallIdSequenceWithoutBackpressure
    extends CallIdSequence {
        private static final AtomicLongFieldUpdater<CallIdSequenceWithoutBackpressure> HEAD = AtomicLongFieldUpdater.newUpdater(CallIdSequenceWithoutBackpressure.class, "head");
        private volatile long head;

        CallIdSequenceWithoutBackpressure() {
        }

        @Override
        public long getLastCallId() {
            return this.head;
        }

        @Override
        public int getMaxConcurrentInvocations() {
            return Integer.MAX_VALUE;
        }

        @Override
        public long next(boolean isUrgent) {
            return HEAD.incrementAndGet(this);
        }

        @Override
        public void complete() {
        }
    }
}

