/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aggregation.impl;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.query.impl.Extractable;
import java.util.Map;

public abstract class AbstractAggregator<I, R>
extends Aggregator<I, R> {
    private final String attributePath;

    public AbstractAggregator() {
        this(null);
    }

    public AbstractAggregator(String attributePath) {
        this.attributePath = attributePath;
    }

    protected final <T> T extract(I input) {
        if (this.attributePath == null) {
            if (input instanceof Map.Entry) {
                return (T)((Map.Entry)input).getValue();
            }
        } else if (input instanceof Extractable) {
            return (T)((Extractable)input).getAttributeValue(this.attributePath);
        }
        throw new IllegalArgumentException("Can't extract " + this.attributePath + " from the given input");
    }
}

