/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aggregation.impl;

import com.hazelcast.aggregation.Aggregator;
import com.hazelcast.aggregation.impl.AbstractAggregator;

public class MaxAggregator<I, R extends Comparable>
extends AbstractAggregator<I, R> {
    private R max;

    public MaxAggregator() {
    }

    public MaxAggregator(String attributePath) {
        super(attributePath);
    }

    @Override
    public void accumulate(I entry) {
        Comparable extractedValue = (Comparable)this.extract(entry);
        if (this.isCurrentlyLessThan(extractedValue)) {
            this.max = extractedValue;
        }
    }

    private boolean isCurrentlyLessThan(R extractedValue) {
        return this.max == null || this.max.compareTo(extractedValue) < 0;
    }

    @Override
    public void combine(Aggregator aggregator) {
        MaxAggregator maxAggregator = (MaxAggregator)aggregator;
        R valueFromOtherAggregator = maxAggregator.max;
        if (this.isCurrentlyLessThan(valueFromOtherAggregator)) {
            this.max = valueFromOtherAggregator;
        }
    }

    @Override
    public R aggregate() {
        return this.max;
    }
}

