/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.scheduledexecutor;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorCancelCodec;
import com.hazelcast.client.impl.protocol.task.AbstractInvocationMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.nio.Connection;
import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import com.hazelcast.scheduledexecutor.impl.operations.CancelTaskOperation;
import com.hazelcast.security.permission.ScheduledExecutorPermission;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import java.security.Permission;

public class ScheduledExecutorTaskCancelMessageTask
extends AbstractInvocationMessageTask<ScheduledExecutorCancelCodec.RequestParameters> {
    public ScheduledExecutorTaskCancelMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected InvocationBuilder getInvocationBuilder(Operation op) {
        InternalOperationService operationService = this.nodeEngine.getOperationService();
        ScheduledTaskHandler handler = ScheduledTaskHandler.of(((ScheduledExecutorCancelCodec.RequestParameters)this.parameters).handlerUrn);
        if (handler.getAddress() != null) {
            return operationService.createInvocationBuilder(this.getServiceName(), op, handler.getAddress());
        }
        return operationService.createInvocationBuilder(this.getServiceName(), op, handler.getPartitionId());
    }

    @Override
    protected Operation prepareOperation() {
        ScheduledTaskHandler handler = ScheduledTaskHandler.of(((ScheduledExecutorCancelCodec.RequestParameters)this.parameters).handlerUrn);
        CancelTaskOperation op = new CancelTaskOperation(handler, ((ScheduledExecutorCancelCodec.RequestParameters)this.parameters).mayInterruptIfRunning);
        op.setPartitionId(this.getPartitionId());
        op.setCallerUuid(this.endpoint.getUuid());
        return op;
    }

    @Override
    protected ScheduledExecutorCancelCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return ScheduledExecutorCancelCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return ScheduledExecutorCancelCodec.encodeResponse((Boolean)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:scheduledExecutorService";
    }

    @Override
    public Permission getRequiredPermission() {
        ScheduledTaskHandler handler = ScheduledTaskHandler.of(((ScheduledExecutorCancelCodec.RequestParameters)this.parameters).handlerUrn);
        return new ScheduledExecutorPermission(handler.getSchedulerName(), "modify");
    }

    @Override
    public String getDistributedObjectName() {
        ScheduledTaskHandler handler = ScheduledTaskHandler.of(((ScheduledExecutorCancelCodec.RequestParameters)this.parameters).handlerUrn);
        return handler.getTaskName();
    }

    @Override
    public String getMethodName() {
        return "cancel";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((ScheduledExecutorCancelCodec.RequestParameters)this.parameters).handlerUrn, ((ScheduledExecutorCancelCodec.RequestParameters)this.parameters).mayInterruptIfRunning};
    }
}

