/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.scheduledexecutor;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetDelayCodec;
import com.hazelcast.client.impl.protocol.task.AbstractInvocationMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.nio.Connection;
import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import com.hazelcast.scheduledexecutor.impl.operations.GetDelayOperation;
import com.hazelcast.security.permission.ScheduledExecutorPermission;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import java.security.Permission;
import java.util.concurrent.TimeUnit;

public class ScheduledExecutorTaskGetDelayMessageTask
extends AbstractInvocationMessageTask<ScheduledExecutorGetDelayCodec.RequestParameters> {
    public ScheduledExecutorTaskGetDelayMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected InvocationBuilder getInvocationBuilder(Operation op) {
        InternalOperationService operationService = this.nodeEngine.getOperationService();
        ScheduledTaskHandler handler = ScheduledTaskHandler.of(((ScheduledExecutorGetDelayCodec.RequestParameters)this.parameters).handlerUrn);
        if (handler.getAddress() != null) {
            return operationService.createInvocationBuilder(this.getServiceName(), op, handler.getAddress());
        }
        return operationService.createInvocationBuilder(this.getServiceName(), op, handler.getPartitionId());
    }

    @Override
    protected Operation prepareOperation() {
        ScheduledTaskHandler handler = ScheduledTaskHandler.of(((ScheduledExecutorGetDelayCodec.RequestParameters)this.parameters).handlerUrn);
        GetDelayOperation op = new GetDelayOperation(handler, TimeUnit.valueOf(((ScheduledExecutorGetDelayCodec.RequestParameters)this.parameters).timeUnitName));
        op.setPartitionId(this.getPartitionId());
        return op;
    }

    @Override
    protected ScheduledExecutorGetDelayCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return ScheduledExecutorGetDelayCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return ScheduledExecutorGetDelayCodec.encodeResponse((Long)response);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:scheduledExecutorService";
    }

    @Override
    public Permission getRequiredPermission() {
        ScheduledTaskHandler handler = ScheduledTaskHandler.of(((ScheduledExecutorGetDelayCodec.RequestParameters)this.parameters).handlerUrn);
        return new ScheduledExecutorPermission(handler.getSchedulerName(), "read");
    }

    @Override
    public String getDistributedObjectName() {
        ScheduledTaskHandler handler = ScheduledTaskHandler.of(((ScheduledExecutorGetDelayCodec.RequestParameters)this.parameters).handlerUrn);
        return handler.getTaskName();
    }

    @Override
    public String getMethodName() {
        return "getDelay";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((ScheduledExecutorGetDelayCodec.RequestParameters)this.parameters).handlerUrn, ((ScheduledExecutorGetDelayCodec.RequestParameters)this.parameters).timeUnitName};
    }
}

