/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.listener;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.spi.impl.listener.ClientEventRegistration;
import com.hazelcast.client.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.client.spi.impl.listener.ClientRegistrationKey;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.InitialMembershipListener;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.nio.Address;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.UuidUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ClientSmartListenerService
extends ClientListenerServiceImpl
implements InitialMembershipListener {
    private static final long SMART_LISTENER_MEMBER_ADDED_RESCHEDULE_TIME = 1000L;
    private static final long SMART_LISTENER_CONNECT_ALL_SERVERS_RETRY_WAIT_TIME = 5000L;
    private static final String SMART_LISTENER_SERVICE_CONNECTION_OPENER = "Smart Listener ConnectionOpener";
    private final Set<Member> members = new HashSet<Member>();
    private final Map<ClientRegistrationKey, Map<Member, ClientEventRegistration>> registrations = new ConcurrentHashMap<ClientRegistrationKey, Map<Member, ClientEventRegistration>>();
    private final ClientClusterService clusterService;
    private volatile LifecycleEvent.LifecycleState lifecycleState;
    private String membershipListenerId;
    private ScheduledFuture<?> connectionOpener;

    public ClientSmartListenerService(HazelcastClientInstanceImpl client, int eventThreadCount, int eventQueueCapacity) {
        super(client, eventThreadCount, eventQueueCapacity);
        this.clusterService = client.getClientClusterService();
    }

    @Override
    public String registerListener(final ListenerMessageCodec codec, final EventHandler handler) {
        Future<String> future = this.registrationExecutor.submit(new Callable<String>(){

            @Override
            public String call() {
                String userRegistrationId = UuidUtil.newUnsecureUuidString();
                ClientRegistrationKey registrationKey = new ClientRegistrationKey(userRegistrationId, handler, codec);
                return ClientSmartListenerService.this.register(registrationKey);
            }
        });
        try {
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private String register(ClientRegistrationKey registrationKey) {
        this.registrations.put(registrationKey, new ConcurrentHashMap());
        for (Member member : this.members) {
            try {
                this.invoke(registrationKey, member);
            }
            catch (Exception e) {
                try {
                    this.deregister(registrationKey);
                }
                catch (Exception cleanupException) {
                    this.logger.warning("Could not perform appropriate cleanup for " + registrationKey, cleanupException);
                }
                throw new HazelcastException("Listener " + registrationKey + " can not be added to member " + member, e);
            }
        }
        return registrationKey.getUserRegistrationId();
    }

    @Override
    public void onClusterConnect(final ClientConnection clientConnection) {
        this.registrationExecutor.submit(new Runnable(){

            @Override
            public void run() {
                Collection<Member> newMemberList = ClientSmartListenerService.this.client.getClientClusterService().getMemberList();
                if (ClientSmartListenerService.this.registrations.isEmpty()) {
                    ClientSmartListenerService.this.members.clear();
                    ClientSmartListenerService.this.members.addAll(newMemberList);
                    return;
                }
                ArrayList<Member> removedMembers = new ArrayList<Member>();
                for (Member member : ClientSmartListenerService.this.members) {
                    if (newMemberList.contains(member)) continue;
                    removedMembers.add(member);
                }
                ArrayList<Member> newMembers = new ArrayList<Member>();
                for (Member member : newMemberList) {
                    if (ClientSmartListenerService.this.members.contains(member)) continue;
                    newMembers.add(member);
                }
                ClientSmartListenerService.this.members.clear();
                ClientSmartListenerService.this.members.addAll(newMemberList);
                ClientSmartListenerService.this.updateRegistrations(clientConnection, removedMembers, newMembers);
                ClientSmartListenerService.this.ensureConnectionsToAllServers();
            }
        });
    }

    private void invoke(ClientRegistrationKey registrationKey, Member member) throws Exception {
        ListenerMessageCodec codec = registrationKey.getCodec();
        ClientMessage request = codec.encodeAddRequest(true);
        EventHandler handler = registrationKey.getHandler();
        handler.beforeListenerRegister();
        Address address = member.getAddress();
        ClientInvocation invocation = new ClientInvocation(this.client, request, address);
        invocation.setEventHandler(handler);
        String serverRegistrationId = codec.decodeAddResponse((ClientMessage)invocation.invoke().get());
        handler.onListenerRegister();
        long correlationId = request.getCorrelationId();
        ClientEventRegistration registration = new ClientEventRegistration(serverRegistrationId, correlationId, member, codec);
        Map<Member, ClientEventRegistration> registrationMap = this.registrations.get(registrationKey);
        registrationMap.put(member, registration);
    }

    @Override
    public boolean deregisterListener(final String userRegistrationId) {
        try {
            Future<Boolean> future = this.registrationExecutor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    ClientRegistrationKey key = new ClientRegistrationKey(userRegistrationId);
                    return ClientSmartListenerService.this.deregister(key);
                }
            });
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private Boolean deregister(ClientRegistrationKey key) {
        Map<Member, ClientEventRegistration> registrationMap = this.registrations.get(key);
        if (registrationMap == null) {
            return false;
        }
        boolean successful = true;
        for (ClientEventRegistration registration : registrationMap.values()) {
            Member subscriber = registration.getSubscriber();
            try {
                ListenerMessageCodec listenerMessageCodec = registration.getCodec();
                String serverRegistrationId = registration.getServerRegistrationId();
                ClientMessage request = listenerMessageCodec.encodeRemoveRequest(serverRegistrationId);
                new ClientInvocation(this.client, request, subscriber.getAddress()).invoke().get();
                this.removeEventHandler(registration.getCallId());
                registrationMap.remove(subscriber);
            }
            catch (Exception e) {
                successful = false;
                this.logger.warning("Deregistration of listener with id " + key.getUserRegistrationId() + " has failed to member " + subscriber, e);
            }
        }
        if (successful) {
            this.registrations.remove(key);
        }
        return successful;
    }

    @Override
    public void start() {
        this.membershipListenerId = this.clusterService.addMembershipListener(this);
        if (null != this.clusterService.getOwnerConnectionAddress()) {
            this.lifecycleState = LifecycleEvent.LifecycleState.CLIENT_CONNECTED;
        }
        this.client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            @Override
            public void stateChanged(LifecycleEvent event) {
                ClientSmartListenerService.this.lifecycleState = event.getState();
            }
        });
        this.connectionOpener = this.client.getClientExecutionService().scheduleWithRepetition(SMART_LISTENER_SERVICE_CONNECTION_OPENER, new Runnable(){

            @Override
            public void run() {
                ClientSmartListenerService.this.registrationExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        ClientSmartListenerService.this.ensureConnectionsToAllServers();
                    }
                });
            }
        }, 0L, 5000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() {
        if (null != this.connectionOpener) {
            this.connectionOpener.cancel(true);
        }
        super.shutdown();
        if (this.membershipListenerId != null) {
            this.clusterService.removeMembershipListener(this.membershipListenerId);
        }
    }

    @Override
    public void memberAdded(MembershipEvent membershipEvent) {
        this.registrationExecutor.submit(new MemberAddedHandler(membershipEvent));
    }

    @Override
    public void memberRemoved(final MembershipEvent membershipEvent) {
        this.registrationExecutor.submit(new Runnable(){

            @Override
            public void run() {
                if (LifecycleEvent.LifecycleState.CLIENT_CONNECTED != ClientSmartListenerService.this.lifecycleState) {
                    ClientSmartListenerService.this.logger.finest("Ignoring member removed event " + membershipEvent + " since the client is disconnected.");
                    return;
                }
                Member member = membershipEvent.getMember();
                ClientSmartListenerService.this.members.remove(member);
                for (Map registrationMap : ClientSmartListenerService.this.registrations.values()) {
                    ClientSmartListenerService.this.removeRegistrationLocally(member, registrationMap);
                }
            }
        });
    }

    @Override
    public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
    }

    @Override
    public void init(InitialMembershipEvent event) {
    }

    private void updateRegistrations(ClientConnection clientConnection, List<Member> removedMembers, List<Member> newMembers) {
        if (clientConnection.getConnectedServerVersion() == -1) {
            this.reRegisterAll();
            return;
        }
        List<Member> clientUnregisteredMembers = clientConnection.getClientUnregisteredMembers();
        for (Member member : removedMembers) {
            for (Map<Member, ClientEventRegistration> registrationMap : this.registrations.values()) {
                this.removeRegistrationLocally(member, registrationMap);
            }
            clientUnregisteredMembers.remove(member);
        }
        for (Member member : clientUnregisteredMembers) {
            this.reRegister(member);
            newMembers.remove(member);
        }
        for (Member member : newMembers) {
            this.register(member);
        }
    }

    private void reRegister(Member member) {
        this.register(member, true);
    }

    private void register(Member member) {
        this.register(member, false);
    }

    private void register(Member member, boolean removeLocally) {
        for (Map.Entry<ClientRegistrationKey, Map<Member, ClientEventRegistration>> entry : this.registrations.entrySet()) {
            ClientRegistrationKey registrationKey = entry.getKey();
            if (removeLocally) {
                Map<Member, ClientEventRegistration> registrationMap = entry.getValue();
                this.removeRegistrationLocally(member, registrationMap);
            }
            try {
                this.invoke(registrationKey, member);
            }
            catch (Exception e) {
                this.logger.warning("Listener " + registrationKey + " could not be added to the new member " + member, e);
            }
        }
    }

    private void reRegisterAll() {
        for (ClientRegistrationKey key : this.registrations.keySet()) {
            this.deregister(key);
            this.register(key);
        }
    }

    private void removeRegistrationLocally(Member member, Map<Member, ClientEventRegistration> registrationMap) {
        ClientEventRegistration registration = registrationMap.remove(member);
        if (null != registration) {
            this.removeEventHandler(registration.getCallId());
        }
    }

    private void ensureConnectionsToAllServers() {
        if (this.registrations.isEmpty()) {
            return;
        }
        Address ownerConnectionAddress = this.clusterService.getOwnerConnectionAddress();
        if (null == ownerConnectionAddress) {
            return;
        }
        for (Member member : this.members) {
            try {
                this.getOrConnect(member, ownerConnectionAddress);
            }
            catch (Exception e) {
                this.logger.warning("Could not open connection to member " + member, e);
            }
        }
    }

    private void getOrConnect(Member member, Address ownerConnectionAddress) throws IOException {
        Address memberAddress = member.getAddress();
        this.client.getConnectionManager().getOrConnect(memberAddress, ownerConnectionAddress.equals(memberAddress));
    }

    @Override
    public Collection<ClientEventRegistration> getActiveRegistrations(final String uuid) {
        Future<Collection<ClientEventRegistration>> future = this.registrationExecutor.submit(new Callable<Collection<ClientEventRegistration>>(){

            @Override
            public Collection<ClientEventRegistration> call() {
                ClientRegistrationKey key = new ClientRegistrationKey(uuid);
                Map registrationMap = (Map)ClientSmartListenerService.this.registrations.get(key);
                if (registrationMap == null) {
                    return Collections.EMPTY_LIST;
                }
                LinkedList<ClientEventRegistration> activeRegistrations = new LinkedList<ClientEventRegistration>();
                for (ClientEventRegistration registration : registrationMap.values()) {
                    for (Member member : ClientSmartListenerService.this.members) {
                        if (!member.equals(registration.getSubscriber())) continue;
                        activeRegistrations.add(registration);
                    }
                }
                return activeRegistrations;
            }
        });
        try {
            return future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private final class MemberAddedHandler
    implements Runnable {
        final MembershipEvent membershipEvent;

        public MemberAddedHandler(MembershipEvent membershipEvent) {
            this.membershipEvent = membershipEvent;
        }

        @Override
        public void run() {
            if (LifecycleEvent.LifecycleState.CLIENT_CONNECTED != ClientSmartListenerService.this.lifecycleState) {
                ClientSmartListenerService.this.logger.finest("Ignoring member added event " + this.membershipEvent + " since the client is disconnected.");
                return;
            }
            Member member = this.membershipEvent.getMember();
            if (ClientSmartListenerService.this.members.contains(member)) {
                ClientSmartListenerService.this.logger.finest("Ignoring member added event " + this.membershipEvent + " since the member is already in the list.");
                return;
            }
            ClientSmartListenerService.this.logger.finest("New member added to the cluster. Registering " + ClientSmartListenerService.this.registrations.size() + " listeners to member " + member);
            try {
                ClientSmartListenerService.this.getOrConnect(member, ClientSmartListenerService.this.client.getClientClusterService().getOwnerConnectionAddress());
            }
            catch (Exception e) {
                ClientSmartListenerService.this.logger.warning("Failed to register listeners to member " + member + " rescheduling the registration in " + 1000L + " msecs", e);
                ClientSmartListenerService.this.client.getClientExecutionService().schedule(new Runnable(){

                    @Override
                    public void run() {
                        ClientSmartListenerService.this.memberAdded(MemberAddedHandler.this.membershipEvent);
                    }
                }, 1000L, TimeUnit.MILLISECONDS);
                return;
            }
            ClientSmartListenerService.this.members.add(member);
            for (Map.Entry entry : ClientSmartListenerService.this.registrations.entrySet()) {
                ClientRegistrationKey registrationKey = (ClientRegistrationKey)entry.getKey();
                Map registrationMap = (Map)ClientSmartListenerService.this.registrations.get(registrationKey);
                if (null != registrationMap.get(member)) continue;
                try {
                    ClientSmartListenerService.this.invoke(registrationKey, member);
                }
                catch (Exception e) {
                    ClientSmartListenerService.this.logger.warning("Listener " + registrationKey + " can not be added to new member " + member, e);
                }
            }
        }
    }
}

