/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl.operations;

import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskResult;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskStatisticsImpl;
import com.hazelcast.scheduledexecutor.impl.operations.AbstractBackupAwareSchedulerOperation;
import com.hazelcast.scheduledexecutor.impl.operations.SyncBackupStateOperation;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class SyncStateOperation
extends AbstractBackupAwareSchedulerOperation {
    private String taskName;
    private Map<Object, Object> state;
    private ScheduledTaskStatisticsImpl stats;
    private ScheduledTaskResult result;
    private boolean shouldRun;

    public SyncStateOperation() {
    }

    public SyncStateOperation(String schedulerName, String taskName, Map state, ScheduledTaskStatisticsImpl stats, ScheduledTaskResult result) {
        super(schedulerName);
        this.taskName = taskName;
        this.state = state;
        this.stats = stats;
        this.result = result;
    }

    @Override
    public void run() throws Exception {
        int partitionId = this.getPartitionId();
        boolean bl = this.shouldRun = partitionId == -1;
        if (partitionId >= 0) {
            Address partitionOwner = this.getNodeEngine().getPartitionService().getPartitionOwner(partitionId);
            boolean bl2 = this.shouldRun = this.shouldRun || this.getCallerAddress().equals(partitionOwner);
        }
        if (this.shouldRun) {
            this.getContainer().syncState(this.taskName, this.state, this.stats, this.result);
        }
    }

    @Override
    public boolean shouldBackup() {
        return super.shouldBackup() && this.shouldRun;
    }

    @Override
    public Operation getBackupOperation() {
        return new SyncBackupStateOperation(this.schedulerName, this.taskName, this.state, this.stats, this.result);
    }

    @Override
    public int getId() {
        return 17;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.taskName);
        out.writeInt(this.state.size());
        for (Map.Entry<Object, Object> entry : this.state.entrySet()) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeObject(this.stats);
        out.writeObject(this.result);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.taskName = in.readUTF();
        int stateSize = in.readInt();
        this.state = new HashMap<Object, Object>(stateSize);
        for (int i = 0; i < stateSize; ++i) {
            this.state.put(in.readObject(), in.readObject());
        }
        this.stats = (ScheduledTaskStatisticsImpl)in.readObject();
        this.result = (ScheduledTaskResult)in.readObject();
    }
}

