/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.event;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.map.impl.EntryEventFilter;
import com.hazelcast.map.impl.EventListenerFilter;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapPartitionLostEventFilter;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.event.DefaultEntryEventFilteringStrategy;
import com.hazelcast.map.impl.event.EntryEventData;
import com.hazelcast.map.impl.event.EntryEventDataCache;
import com.hazelcast.map.impl.event.FilteringStrategy;
import com.hazelcast.map.impl.event.MapEventData;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.event.MapPartitionEventData;
import com.hazelcast.map.impl.event.QueryCacheEventPublisher;
import com.hazelcast.map.impl.event.QueryCacheNaturalFilteringStrategy;
import com.hazelcast.map.impl.query.QueryEventFilter;
import com.hazelcast.map.impl.wan.MapReplicationRemove;
import com.hazelcast.map.impl.wan.MapReplicationUpdate;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.impl.eventservice.impl.TrueEventFilter;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.wan.ReplicationEventObject;
import com.hazelcast.wan.WanReplicationPublisher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class MapEventPublisherImpl
implements MapEventPublisher {
    public static final HazelcastProperty LISTENER_WITH_PREDICATE_PRODUCES_NATURAL_EVENT_TYPES = new HazelcastProperty("hazelcast.map.entry.filtering.natural.event.types", false);
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;
    protected final SerializationService serializationService;
    protected final EventService eventService;
    protected final FilteringStrategy filteringStrategy;
    protected final QueryCacheEventPublisher queryCacheEventPublisher;

    public MapEventPublisherImpl(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.serializationService = this.nodeEngine.getSerializationService();
        this.eventService = this.nodeEngine.getEventService();
        this.filteringStrategy = this.nodeEngine.getProperties().getBoolean(LISTENER_WITH_PREDICATE_PRODUCES_NATURAL_EVENT_TYPES) ? new QueryCacheNaturalFilteringStrategy(this.serializationService, mapServiceContext) : new DefaultEntryEventFilteringStrategy(this.serializationService, mapServiceContext);
        this.queryCacheEventPublisher = new QueryCacheEventPublisher(this.filteringStrategy, mapServiceContext.getQueryCacheContext(), (InternalSerializationService)this.serializationService);
    }

    @Override
    public void publishWanReplicationUpdate(String mapName, EntryView entryView) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        MapReplicationUpdate replicationEvent = new MapReplicationUpdate(mapName, mapContainer.getWanMergePolicy(), entryView);
        mapContainer.getWanReplicationPublisher().publishReplicationEvent("hz:impl:mapService", replicationEvent);
    }

    @Override
    public void publishWanReplicationRemove(String mapName, Data key, long removeTime) {
        MapReplicationRemove event = new MapReplicationRemove(mapName, key, removeTime);
        this.publishWanReplicationEventInternal(mapName, event);
    }

    @Override
    public void publishWanReplicationUpdateBackup(String mapName, EntryView entryView) {
    }

    @Override
    public void publishWanReplicationRemoveBackup(String mapName, Data key, long removeTime) {
    }

    @Override
    public void publishMapEvent(Address caller, String mapName, EntryEventType eventType, int numberOfEntriesAffected) {
        Collection<EventRegistration> mapsListenerRegistrations = this.getRegistrations(mapName);
        if (CollectionUtil.isEmpty(mapsListenerRegistrations)) {
            return;
        }
        ArrayList<EventRegistration> registrations = null;
        for (EventRegistration registration : mapsListenerRegistrations) {
            EventFilter filter = registration.getFilter();
            if (filter instanceof EventListenerFilter && !filter.eval(eventType.getType()) || filter instanceof MapPartitionLostEventFilter) continue;
            if (registrations == null) {
                registrations = new ArrayList<EventRegistration>();
            }
            registrations.add(registration);
        }
        if (CollectionUtil.isEmpty(registrations)) {
            return;
        }
        String source = this.getThisNodesAddress();
        MapEventData mapEventData = new MapEventData(source, mapName, caller, eventType.getType(), numberOfEntriesAffected);
        this.publishEventInternal(registrations, mapEventData, mapName.hashCode());
    }

    @Override
    public void publishEvent(Address caller, String mapName, EntryEventType eventType, Data dataKey, Object dataOldValue, Object dataValue) {
        this.publishEvent(caller, mapName, eventType, dataKey, dataOldValue, dataValue, null);
    }

    @Override
    public void publishEvent(Address caller, String mapName, EntryEventType eventType, Data dataKey, Object oldValue, Object value, Object mergingValue) {
        Collection<EventRegistration> registrations = this.getRegistrations(mapName);
        if (CollectionUtil.isEmpty(registrations)) {
            return;
        }
        this.publishEvent(registrations, caller, mapName, eventType, dataKey, oldValue, value, mergingValue);
    }

    private void publishEvent(Collection<EventRegistration> registrations, Address caller, String mapName, EntryEventType eventType, Data dataKey, Object oldValue, Object value, Object mergingValue) {
        EntryEventDataCache eventDataCache = this.filteringStrategy.getEntryEventDataCache();
        int orderKey = this.pickOrderKey(dataKey);
        for (EventRegistration registration : registrations) {
            EventFilter filter = registration.getFilter();
            int eventTypeForPublishing = this.filteringStrategy.doFilter(filter, dataKey, oldValue, value, eventType, mapName);
            if (eventTypeForPublishing == -1) continue;
            EntryEventData eventDataToBePublished = eventDataCache.getOrCreateEventData(mapName, caller, dataKey, value, oldValue, mergingValue, eventTypeForPublishing, MapEventPublisherImpl.isIncludeValue(filter));
            this.eventService.publishEvent("hz:impl:mapService", registration, (Object)eventDataToBePublished, orderKey);
        }
        if (!eventDataCache.isEmpty()) {
            this.postPublishEvent(eventDataCache.eventDataIncludingValues(), eventDataCache.eventDataExcludingValues());
        }
    }

    protected void postPublishEvent(Collection<EntryEventData> eventDataIncludingValues, Collection<EntryEventData> eventDataExcludingValues) {
        if (eventDataIncludingValues != null) {
            for (EntryEventData entryEventData : eventDataIncludingValues) {
                this.queryCacheEventPublisher.addEventToQueryCache(entryEventData);
            }
        }
    }

    static boolean isIncludeValue(EventFilter filter) {
        if (filter instanceof EventListenerFilter) {
            filter = ((EventListenerFilter)filter).getEventFilter();
        }
        if (filter instanceof TrueEventFilter) {
            return true;
        }
        if (filter instanceof QueryEventFilter) {
            return ((QueryEventFilter)filter).isIncludeValue();
        }
        if (filter instanceof EntryEventFilter) {
            return ((EntryEventFilter)filter).isIncludeValue();
        }
        throw new IllegalArgumentException("Unknown EventFilter type = [" + filter.getClass().getCanonicalName() + "]");
    }

    @Override
    public void publishMapPartitionLostEvent(Address caller, String mapName, int partitionId) {
        LinkedList<EventRegistration> registrations = new LinkedList<EventRegistration>();
        for (EventRegistration registration : this.getRegistrations(mapName)) {
            if (!(registration.getFilter() instanceof MapPartitionLostEventFilter)) continue;
            registrations.add(registration);
        }
        if (registrations.isEmpty()) {
            return;
        }
        String thisNodesAddress = this.getThisNodesAddress();
        MapPartitionEventData eventData = new MapPartitionEventData(thisNodesAddress, mapName, caller, partitionId);
        this.publishEventInternal(registrations, eventData, partitionId);
    }

    @Override
    public void hintMapEvent(Address caller, String mapName, EntryEventType eventType, int numberOfEntriesAffected, int partitionId) {
        this.queryCacheEventPublisher.hintMapEvent(caller, mapName, eventType, numberOfEntriesAffected, partitionId);
    }

    @Override
    public void addEventToQueryCache(Object eventData) {
        this.queryCacheEventPublisher.addEventToQueryCache(eventData);
    }

    @Override
    public boolean hasEventListener(String mapName) {
        return this.eventService.hasEventRegistration("hz:impl:mapService", mapName);
    }

    protected Collection<EventRegistration> getRegistrations(String mapName) {
        return this.eventService.getRegistrations("hz:impl:mapService", mapName);
    }

    private int pickOrderKey(Data key) {
        return key == null ? -1 : key.hashCode();
    }

    protected void publishEventInternal(Collection<EventRegistration> registrations, Object eventData, int orderKey) {
        this.eventService.publishEvent("hz:impl:mapService", registrations, eventData, orderKey);
        this.queryCacheEventPublisher.addEventToQueryCache(eventData);
    }

    private String getThisNodesAddress() {
        Address thisAddress = this.nodeEngine.getThisAddress();
        return thisAddress.toString();
    }

    protected void publishWanReplicationEventInternal(String mapName, ReplicationEventObject event) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        WanReplicationPublisher wanReplicationPublisher = mapContainer.getWanReplicationPublisher();
        wanReplicationPublisher.publishReplicationEvent("hz:impl:mapService", event);
    }
}

