/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.DefaultOutOfMemoryHandler;
import com.hazelcast.util.EmptyStatement;

public class ClientOutOfMemoryHandler
extends DefaultOutOfMemoryHandler {
    @Override
    public void onOutOfMemory(OutOfMemoryError oome, HazelcastInstance[] hazelcastInstances) {
        for (HazelcastInstance instance : hazelcastInstances) {
            if (!(instance instanceof HazelcastClientInstanceImpl)) continue;
            ClientHelper.cleanResources((HazelcastClientInstanceImpl)instance);
        }
        try {
            oome.printStackTrace(System.err);
        }
        catch (Throwable ignored) {
            EmptyStatement.ignore(ignored);
        }
    }

    private static final class ClientHelper {
        private ClientHelper() {
        }

        public static void cleanResources(HazelcastClientInstanceImpl client) {
            ClientHelper.closeSockets(client);
            ClientHelper.tryShutdown(client);
        }

        private static void closeSockets(HazelcastClientInstanceImpl client) {
            ClientConnectionManager connectionManager = client.getConnectionManager();
            if (connectionManager != null) {
                try {
                    connectionManager.shutdown();
                }
                catch (Throwable ignored) {
                    EmptyStatement.ignore(ignored);
                }
            }
        }

        private static void tryShutdown(HazelcastClientInstanceImpl client) {
            if (client == null) {
                return;
            }
            try {
                client.doShutdown();
            }
            catch (Throwable ignored) {
                EmptyStatement.ignore(ignored);
            }
        }
    }
}

