/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;

public class XmlClientConfigLocator {
    private static final ILogger LOGGER = Logger.getLogger(XmlClientConfigLocator.class);
    private InputStream in;

    public XmlClientConfigLocator() {
        try {
            if (this.loadFromSystemProperty()) {
                return;
            }
            if (this.loadFromWorkingDirectory()) {
                return;
            }
            if (this.loadClientHazelcastXmlFromClasspath()) {
                return;
            }
            this.loadDefaultConfigurationFromClasspath();
        }
        catch (RuntimeException e) {
            throw new HazelcastException("Failed to load ClientConfig", e);
        }
    }

    public InputStream getIn() {
        return this.in;
    }

    private void loadDefaultConfigurationFromClasspath() {
        LOGGER.info("Loading 'hazelcast-client-default.xml' from classpath.");
        this.in = Config.class.getClassLoader().getResourceAsStream("hazelcast-client-default.xml");
        if (this.in == null) {
            throw new HazelcastException("Could not load 'hazelcast-client-default.xml' from classpath");
        }
    }

    private boolean loadClientHazelcastXmlFromClasspath() {
        URL url = Config.class.getClassLoader().getResource("hazelcast-client.xml");
        if (url == null) {
            LOGGER.finest("Could not find 'hazelcast-client.xml' in classpath.");
            return false;
        }
        LOGGER.info("Loading 'hazelcast-client.xml' from classpath.");
        this.in = Config.class.getClassLoader().getResourceAsStream("hazelcast-client.xml");
        if (this.in == null) {
            throw new HazelcastException("Could not load 'hazelcast-client.xml' from classpath");
        }
        return true;
    }

    private boolean loadFromWorkingDirectory() {
        File file = new File("hazelcast-client.xml");
        if (!file.exists()) {
            LOGGER.finest("Could not find 'hazelcast-client.xml' in working directory.");
            return false;
        }
        LOGGER.info("Loading 'hazelcast-client.xml' from working directory.");
        try {
            this.in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new HazelcastException("Failed to open file: " + file.getAbsolutePath(), e);
        }
        return true;
    }

    private boolean loadFromSystemProperty() {
        String configSystemProperty = System.getProperty("hazelcast.client.config");
        if (configSystemProperty == null) {
            LOGGER.finest("Could not 'hazelcast.client.config' System property");
            return false;
        }
        LOGGER.info("Loading configuration " + configSystemProperty + " from System property 'hazelcast.client.config'");
        if (configSystemProperty.startsWith("classpath:")) {
            this.loadSystemPropertyClassPathResource(configSystemProperty);
        } else {
            this.loadSystemPropertyFileResource(configSystemProperty);
        }
        return true;
    }

    private void loadSystemPropertyFileResource(String configSystemProperty) {
        File configurationFile = new File(configSystemProperty);
        LOGGER.info("Using configuration file at " + configurationFile.getAbsolutePath());
        if (!configurationFile.exists()) {
            String msg = "Config file at '" + configurationFile.getAbsolutePath() + "' doesn't exist.";
            throw new HazelcastException(msg);
        }
        try {
            this.in = new FileInputStream(configurationFile);
        }
        catch (FileNotFoundException e) {
            throw new HazelcastException("Failed to open file: " + configurationFile.getAbsolutePath(), e);
        }
    }

    private void loadSystemPropertyClassPathResource(String configSystemProperty) {
        String resource = configSystemProperty.substring("classpath:".length());
        LOGGER.info("Using classpath resource at " + resource);
        if (resource.isEmpty()) {
            throw new HazelcastException("classpath resource can't be empty");
        }
        this.in = Config.class.getClassLoader().getResourceAsStream(resource);
        if (this.in == null) {
            throw new HazelcastException("Could not load classpath resource: " + resource);
        }
    }
}

