/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache.impl.store;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.IFunction;
import com.hazelcast.internal.eviction.EvictionChecker;
import com.hazelcast.internal.eviction.EvictionListener;
import com.hazelcast.internal.eviction.EvictionPolicyEvaluator;
import com.hazelcast.internal.eviction.EvictionPolicyEvaluatorProvider;
import com.hazelcast.internal.eviction.EvictionPolicyType;
import com.hazelcast.internal.eviction.EvictionStrategy;
import com.hazelcast.internal.eviction.EvictionStrategyProvider;
import com.hazelcast.internal.eviction.MaxSizeChecker;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.nearcache.NearCacheRecord;
import com.hazelcast.internal.nearcache.NearCacheRecordStore;
import com.hazelcast.internal.nearcache.impl.NearCacheRecordMap;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataContainer;
import com.hazelcast.internal.nearcache.impl.invalidation.StaleReadDetector;
import com.hazelcast.monitor.NearCacheStats;
import com.hazelcast.monitor.impl.NearCacheStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public abstract class AbstractNearCacheRecordStore<K, V, KS, R extends NearCacheRecord, NCRM extends NearCacheRecordMap<KS, R>>
implements NearCacheRecordStore<K, V>,
EvictionListener<KS, R> {
    protected static final AtomicLongFieldUpdater<AbstractNearCacheRecordStore> RESERVATION_ID = AtomicLongFieldUpdater.newUpdater(AbstractNearCacheRecordStore.class, "reservationId");
    protected static final int REFERENCE_SIZE = GlobalMemoryAccessorRegistry.MEM_AVAILABLE ? GlobalMemoryAccessorRegistry.MEM.arrayIndexScale(Object[].class) : 4;
    protected static final int MILLI_SECONDS_IN_A_SECOND = 1000;
    protected final long timeToLiveMillis;
    protected final long maxIdleMillis;
    protected final NearCacheConfig nearCacheConfig;
    protected final SerializationService serializationService;
    protected final ClassLoader classLoader;
    protected final NearCacheStatsImpl nearCacheStats;
    protected final IFunction<K, R> reserveForUpdate = new IFunction<K, R>(){

        @Override
        public R apply(K key) {
            NearCacheRecord record = null;
            try {
                record = (NearCacheRecord)AbstractNearCacheRecordStore.this.valueToRecord(null);
                AbstractNearCacheRecordStore.this.onRecordCreate(key, record);
                record.casRecordState(-4L, -2L);
            }
            catch (Throwable throwable) {
                AbstractNearCacheRecordStore.this.onPutError(key, null, record, null, throwable);
                throw ExceptionUtil.rethrow(throwable);
            }
            return record;
        }
    };
    protected MaxSizeChecker maxSizeChecker;
    protected EvictionPolicyEvaluator<KS, R> evictionPolicyEvaluator;
    protected EvictionChecker evictionChecker;
    protected EvictionStrategy<KS, R, NCRM> evictionStrategy;
    protected EvictionPolicyType evictionPolicyType;
    protected NCRM records;
    protected volatile StaleReadDetector staleReadDetector = StaleReadDetector.ALWAYS_FRESH;
    protected volatile long reservationId;

    public AbstractNearCacheRecordStore(NearCacheConfig nearCacheConfig, SerializationService serializationService, ClassLoader classLoader) {
        this(nearCacheConfig, new NearCacheStatsImpl(), serializationService, classLoader);
    }

    protected AbstractNearCacheRecordStore(NearCacheConfig nearCacheConfig, NearCacheStatsImpl nearCacheStats, SerializationService serializationService, ClassLoader classLoader) {
        this.nearCacheConfig = nearCacheConfig;
        this.timeToLiveMillis = nearCacheConfig.getTimeToLiveSeconds() * 1000;
        this.maxIdleMillis = nearCacheConfig.getMaxIdleSeconds() * 1000;
        this.serializationService = serializationService;
        this.classLoader = classLoader;
        this.nearCacheStats = nearCacheStats;
        this.evictionPolicyType = nearCacheConfig.getEvictionConfig().getEvictionPolicyType();
    }

    @Override
    public void initialize() {
        EvictionConfig evictionConfig = this.nearCacheConfig.getEvictionConfig();
        this.records = this.createNearCacheRecordMap(this.nearCacheConfig);
        this.maxSizeChecker = this.createNearCacheMaxSizeChecker(evictionConfig, this.nearCacheConfig);
        this.evictionPolicyEvaluator = this.createEvictionPolicyEvaluator(evictionConfig);
        this.evictionChecker = this.createEvictionChecker(this.nearCacheConfig);
        this.evictionStrategy = this.createEvictionStrategy(evictionConfig);
        this.evictionPolicyType = evictionConfig.getEvictionPolicyType();
    }

    @Override
    public void setStaleReadDetector(StaleReadDetector staleReadDetector) {
        this.staleReadDetector = staleReadDetector;
    }

    @Override
    public StaleReadDetector getStaleReadDetector() {
        return this.staleReadDetector;
    }

    protected abstract MaxSizeChecker createNearCacheMaxSizeChecker(EvictionConfig var1, NearCacheConfig var2);

    protected abstract NCRM createNearCacheRecordMap(NearCacheConfig var1);

    protected abstract long getKeyStorageMemoryCost(K var1);

    protected abstract long getRecordStorageMemoryCost(R var1);

    protected abstract R valueToRecord(V var1);

    protected abstract void updateRecordValue(R var1, V var2);

    protected abstract V recordToValue(R var1);

    public abstract R getRecord(K var1);

    protected abstract R getOrCreateToReserve(K var1);

    protected abstract V updateAndGetReserved(K var1, V var2, long var3, boolean var5);

    protected abstract R putRecord(K var1, R var2);

    protected abstract R removeRecord(K var1);

    protected abstract boolean containsRecordKey(K var1);

    protected void checkAvailable() {
        if (!this.isAvailable()) {
            throw new IllegalStateException(this.nearCacheConfig.getName() + " named Near Cache record store is not available");
        }
    }

    protected EvictionPolicyEvaluator<KS, R> createEvictionPolicyEvaluator(EvictionConfig evictionConfig) {
        EvictionPolicyType evictionPolicyType = evictionConfig.getEvictionPolicyType();
        if (evictionPolicyType == null) {
            throw new IllegalArgumentException("Eviction policy cannot be null");
        }
        return EvictionPolicyEvaluatorProvider.getEvictionPolicyEvaluator(evictionConfig, this.classLoader);
    }

    protected EvictionStrategy<KS, R, NCRM> createEvictionStrategy(EvictionConfig evictionConfig) {
        return EvictionStrategyProvider.getEvictionStrategy(evictionConfig);
    }

    protected EvictionChecker createEvictionChecker(NearCacheConfig nearCacheConfig) {
        return new MaxSizeEvictionChecker();
    }

    protected boolean isAvailable() {
        return this.records != null;
    }

    protected Data valueToData(V value) {
        if (value instanceof Data) {
            return (Data)value;
        }
        if (value != null) {
            return this.serializationService.toData(value);
        }
        return null;
    }

    protected V dataToValue(Data data) {
        if (data != null) {
            return (V)this.serializationService.toObject(data);
        }
        return null;
    }

    protected Data toData(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Data) {
            return (Data)obj;
        }
        return this.valueToData(obj);
    }

    protected V toValue(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Data) {
            return this.dataToValue((Data)obj);
        }
        return (V)obj;
    }

    protected long getTotalStorageMemoryCost(K key, R record) {
        return this.getKeyStorageMemoryCost(key) + this.getRecordStorageMemoryCost(record);
    }

    protected boolean isRecordExpired(R record) {
        long now = Clock.currentTimeMillis();
        if (record.isExpiredAt(now)) {
            return true;
        }
        return record.isIdleAt(this.maxIdleMillis, now);
    }

    protected void onRecordCreate(K key, R record) {
        record.setCreationTime(Clock.currentTimeMillis());
        MetaDataContainer metaDataContainer = this.staleReadDetector.getMetaDataContainer(key);
        if (metaDataContainer != null) {
            record.setUuid(metaDataContainer.getUuid());
            record.setInvalidationSequence(metaDataContainer.getSequence());
        }
    }

    protected void onRecordAccess(R record) {
        record.setAccessTime(Clock.currentTimeMillis());
        record.incrementAccessHit();
    }

    protected void onGet(K key, V value, R record) {
    }

    protected void onGetError(K key, V value, R record, Throwable error) {
    }

    protected void onPut(K key, V value, R record, R oldRecord) {
    }

    protected void onPutError(K key, V value, R record, R oldRecord, Throwable error) {
    }

    protected void onRemove(K key, R record, boolean removed) {
    }

    protected void onRemoveError(K key, R record, boolean removed, Throwable error) {
    }

    protected void onExpire(K key, R record) {
        this.nearCacheStats.incrementExpirations();
    }

    protected boolean isEvictionEnabled() {
        return this.evictionStrategy != null && this.evictionPolicyEvaluator != null && this.evictionPolicyType != null && !this.evictionPolicyType.equals((Object)EvictionPolicyType.NONE);
    }

    @Override
    public void onEvict(KS key, R record, boolean wasExpired) {
        if (wasExpired) {
            this.nearCacheStats.incrementExpirations();
        } else {
            this.nearCacheStats.incrementEvictions();
        }
        this.nearCacheStats.decrementOwnedEntryCount();
    }

    @Override
    public V get(K key) {
        this.checkAvailable();
        NearCacheRecord record = null;
        V value = null;
        try {
            record = (NearCacheRecord)this.getRecord(key);
            if (record != null) {
                if (record.getRecordState() != -4L) {
                    return null;
                }
                if (this.staleReadDetector.isStaleRead(key, record)) {
                    this.remove(key);
                    return null;
                }
                if (this.isRecordExpired(record)) {
                    this.remove(key);
                    this.onExpire(key, record);
                    return null;
                }
                this.onRecordAccess(record);
                this.nearCacheStats.incrementHits();
                value = this.recordToValue(record);
                this.onGet(key, value, record);
                return value;
            }
            this.nearCacheStats.incrementMisses();
            return null;
        }
        catch (Throwable error) {
            this.onGetError(key, value, record, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    @Override
    public void put(K key, V value) {
        this.checkAvailable();
        if (!this.isEvictionEnabled() && this.evictionChecker.isEvictionRequired() && !this.containsRecordKey(key)) {
            return;
        }
        R record = null;
        R oldRecord = null;
        try {
            record = this.valueToRecord(value);
            this.onRecordCreate(key, record);
            oldRecord = this.putRecord(key, record);
            if (oldRecord == null) {
                this.nearCacheStats.incrementOwnedEntryCount();
            }
            this.onPut(key, value, record, oldRecord);
        }
        catch (Throwable error) {
            this.onPutError(key, value, record, oldRecord, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    @Override
    public boolean remove(K key) {
        this.checkAvailable();
        NearCacheRecord record = null;
        boolean removed = false;
        try {
            record = (NearCacheRecord)this.removeRecord(key);
            if (record != null && record.getRecordState() == -4L) {
                removed = true;
                this.nearCacheStats.decrementOwnedEntryCount();
            }
            this.onRemove(key, record, removed);
            return record != null;
        }
        catch (Throwable error) {
            this.onRemoveError(key, record, removed, error);
            throw ExceptionUtil.rethrow(error);
        }
    }

    protected void clearRecords() {
        this.records.clear();
    }

    @Override
    public void clear() {
        this.checkAvailable();
        this.clearRecords();
        this.nearCacheStats.setOwnedEntryCount(0L);
        this.nearCacheStats.setOwnedEntryMemoryCost(0L);
    }

    protected void destroyStore() {
        this.clearRecords();
    }

    @Override
    public void destroy() {
        this.checkAvailable();
        this.destroyStore();
        this.nearCacheStats.setOwnedEntryCount(0L);
        this.nearCacheStats.setOwnedEntryMemoryCost(0L);
    }

    @Override
    public int size() {
        this.checkAvailable();
        return this.records.size();
    }

    @Override
    public NearCacheStats getNearCacheStats() {
        this.checkAvailable();
        return this.nearCacheStats;
    }

    @Override
    public void doEvictionIfRequired() {
        this.checkAvailable();
        if (this.isEvictionEnabled()) {
            this.evictionStrategy.evict(this.records, this.evictionPolicyEvaluator, this.evictionChecker, this);
        }
    }

    @Override
    public void doEviction() {
        this.checkAvailable();
        if (this.isEvictionEnabled()) {
            this.evictionStrategy.evict(this.records, this.evictionPolicyEvaluator, null, this);
        }
    }

    @Override
    public long tryReserveForUpdate(K key) {
        long reservationId;
        this.checkAvailable();
        if (!this.isEvictionEnabled() && this.evictionChecker.isEvictionRequired() && !this.containsRecordKey(key)) {
            return -1L;
        }
        R reservedRecord = this.getOrCreateToReserve(key);
        if (reservedRecord.casRecordState(-2L, reservationId = this.nextReservationId())) {
            return reservationId;
        }
        return -1L;
    }

    @Override
    public V tryPublishReserved(K key, V value, long reservationId, boolean deserialize) {
        return this.updateAndGetReserved(key, value, reservationId, deserialize);
    }

    protected R updateReservedRecordInternal(K key, V value, R reservedRecord, long reservationId) {
        if (!reservedRecord.casRecordState(reservationId, -3L)) {
            return reservedRecord;
        }
        this.updateRecordValue(reservedRecord, value);
        reservedRecord.casRecordState(-3L, -4L);
        this.nearCacheStats.incrementOwnedEntryMemoryCost(this.getTotalStorageMemoryCost(key, reservedRecord));
        this.nearCacheStats.incrementOwnedEntryCount();
        return reservedRecord;
    }

    protected long nextReservationId() {
        return RESERVATION_ID.incrementAndGet(this);
    }

    private class MaxSizeEvictionChecker
    implements EvictionChecker {
        private MaxSizeEvictionChecker() {
        }

        @Override
        public boolean isEvictionRequired() {
            return AbstractNearCacheRecordStore.this.maxSizeChecker != null && AbstractNearCacheRecordStore.this.maxSizeChecker.isReachedToMaxSize();
        }
    }
}

