/*
 * Copyright (c) 2008-2017, Hazelcast, Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.internal.eviction;

/**
 * Interface for evaluation implementations of {@link com.hazelcast.config.EvictionPolicy}.
 *
 * @param <A> Type of the accessor (id) of the {@link com.hazelcast.internal.eviction.EvictionCandidate}
 * @param <E> Type of the {@link com.hazelcast.internal.eviction.Evictable} value of
 *            {@link com.hazelcast.internal.eviction.EvictionCandidate}
 */
public interface EvictionPolicyEvaluator<A, E extends Evictable> {

    /**
     * Gets the underlying {@link EvictionPolicyComparator}.
     *
     * @return the underlying {@link EvictionPolicyComparator}
     */
    EvictionPolicyComparator getEvictionPolicyComparator();

    /**
     * The evaluate method implements the actual policy rules and is called on every eviction to select one or
     * more candidates to be evicted from the given input set of candidates.
     * The selection algorithm should execute in a constant time to deliver a predictable timing results of
     * the eviction system.
     *
     * @param evictionCandidates Multiple {@link EvictionCandidate} to be evicted
     *
     * @return multiple {@link EvictionCandidate}s that are available to be evicted
     */
    <C extends EvictionCandidate<A, E>> Iterable<C> evaluate(Iterable<C> evictionCandidates);

}
