/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.eviction;

import com.hazelcast.internal.eviction.Evictable;
import com.hazelcast.internal.eviction.EvictionConfiguration;
import com.hazelcast.internal.eviction.EvictionPolicyComparator;
import com.hazelcast.internal.eviction.EvictionPolicyEvaluator;
import com.hazelcast.internal.eviction.EvictionPolicyType;
import com.hazelcast.internal.eviction.impl.comparator.LFUEvictionPolicyComparator;
import com.hazelcast.internal.eviction.impl.comparator.LRUEvictionPolicyComparator;
import com.hazelcast.internal.eviction.impl.comparator.RandomEvictionPolicyComparator;
import com.hazelcast.internal.eviction.impl.evaluator.DefaultEvictionPolicyEvaluator;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.StringUtil;

public final class EvictionPolicyEvaluatorProvider {
    private EvictionPolicyEvaluatorProvider() {
    }

    private static EvictionPolicyComparator createEvictionPolicyComparator(EvictionPolicyType evictionPolicyType) {
        switch (evictionPolicyType) {
            case LRU: {
                return new LRUEvictionPolicyComparator();
            }
            case LFU: {
                return new LFUEvictionPolicyComparator();
            }
            case RANDOM: {
                return new RandomEvictionPolicyComparator();
            }
            case NONE: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unsupported eviction policy type: " + (Object)((Object)evictionPolicyType));
    }

    public static <A, E extends Evictable> EvictionPolicyEvaluator<A, E> getEvictionPolicyEvaluator(EvictionConfiguration evictionConfig, ClassLoader classLoader) {
        EvictionPolicyComparator evictionPolicyComparator;
        if (evictionConfig == null) {
            return null;
        }
        String evictionPolicyComparatorClassName = evictionConfig.getComparatorClassName();
        if (!StringUtil.isNullOrEmpty(evictionPolicyComparatorClassName)) {
            try {
                evictionPolicyComparator = (EvictionPolicyComparator)ClassLoaderUtil.newInstance(classLoader, evictionPolicyComparatorClassName);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        } else {
            EvictionPolicyComparator comparator = evictionConfig.getComparator();
            if (comparator != null) {
                evictionPolicyComparator = comparator;
            } else {
                EvictionPolicyType evictionPolicyType = evictionConfig.getEvictionPolicyType();
                if (evictionPolicyType == null) {
                    return null;
                }
                evictionPolicyComparator = EvictionPolicyEvaluatorProvider.createEvictionPolicyComparator(evictionPolicyType);
            }
        }
        return new DefaultEvictionPolicyEvaluator(evictionPolicyComparator);
    }
}

