/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.core.TypeConverter;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.QueryException;
import com.hazelcast.query.impl.ComparisonType;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.IndexStore;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.SingleResultSet;
import com.hazelcast.query.impl.SortedIndexStore;
import com.hazelcast.query.impl.TypeConverters;
import com.hazelcast.query.impl.UnsortedIndexStore;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.query.impl.predicates.PredicateDataSerializerHook;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class IndexImpl
implements Index {
    public static final NullObject NULL = new NullObject();
    private final IndexStore indexStore;
    private final String attributeName;
    private final boolean ordered;
    private volatile TypeConverter converter;
    private final InternalSerializationService ss;
    private final Extractors extractors;

    public IndexImpl(String attributeName, boolean ordered, InternalSerializationService ss, Extractors extractors) {
        this.attributeName = attributeName;
        this.ordered = ordered;
        this.ss = ss;
        this.indexStore = ordered ? new SortedIndexStore() : new UnsortedIndexStore();
        this.extractors = extractors;
    }

    @Override
    public void saveEntryIndex(QueryableEntry entry, Object oldRecordValue) throws QueryException {
        if (this.converter == null || this.converter == TypeConverters.NULL_CONVERTER) {
            this.converter = entry.getConverter(this.attributeName);
        }
        Object newAttributeValue = this.extractAttributeValue(entry.getKeyData(), entry.getTargetObject(false));
        if (oldRecordValue == null) {
            this.indexStore.newIndex(newAttributeValue, entry);
        } else {
            Object oldAttributeValue = this.extractAttributeValue(entry.getKeyData(), oldRecordValue);
            this.indexStore.updateIndex(oldAttributeValue, newAttributeValue, entry);
        }
    }

    @Override
    public void removeEntryIndex(Data key, Object value) {
        Object attributeValue = this.extractAttributeValue(key, value);
        this.indexStore.removeIndex(attributeValue, key);
    }

    private Object extractAttributeValue(Data key, Object value) {
        return QueryableEntry.extractAttributeValue(this.extractors, this.ss, this.attributeName, key, value);
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable[] values) {
        if (values.length == 1) {
            return this.getRecords(values[0]);
        }
        if (this.converter != null) {
            HashSet<Comparable> convertedValues = new HashSet<Comparable>(values.length);
            for (Comparable value : values) {
                convertedValues.add(this.convert(value));
            }
            return this.indexStore.getRecords(convertedValues);
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable attributeValue) {
        if (this.converter == null) {
            return new SingleResultSet(null);
        }
        return this.indexStore.getRecords(this.convert(attributeValue));
    }

    @Override
    public Set<QueryableEntry> getSubRecords(ComparisonType comparisonType, Comparable searchedAttributeValue) {
        if (this.converter == null) {
            return Collections.EMPTY_SET;
        }
        return this.indexStore.getSubRecords(comparisonType, this.convert(searchedAttributeValue));
    }

    @Override
    public Set<QueryableEntry> getSubRecordsBetween(Comparable fromAttributeValue, Comparable toAttributeValue) {
        if (this.converter == null) {
            return Collections.EMPTY_SET;
        }
        return this.indexStore.getSubRecordsBetween(this.convert(fromAttributeValue), this.convert(toAttributeValue));
    }

    private Comparable convert(Comparable attributeValue) {
        return this.converter.convert(attributeValue);
    }

    @Override
    public TypeConverter getConverter() {
        return this.converter;
    }

    @Override
    public void clear() {
        this.indexStore.clear();
        this.converter = null;
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public boolean isOrdered() {
        return this.ordered;
    }

    public static final class NullObject
    implements Comparable,
    IdentifiedDataSerializable {
        public int compareTo(Object o) {
            if (o == this || o instanceof NullObject) {
                return 0;
            }
            return -1;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
        }

        @Override
        public int getFactoryId() {
            return PredicateDataSerializerHook.F_ID;
        }

        @Override
        public int getId() {
            return 17;
        }
    }
}

