/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.proxy;

import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.impl.invalidation.BatchNearCacheInvalidation;
import com.hazelcast.internal.nearcache.impl.invalidation.Invalidation;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.nearcache.MapNearCacheManager;
import com.hazelcast.map.impl.nearcache.invalidation.InvalidationListener;
import com.hazelcast.map.impl.nearcache.invalidation.UuidFilter;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.MapUtil;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class NearCachedMapProxyImpl<K, V>
extends MapProxyImpl<K, V> {
    private boolean cacheLocalEntries;
    private boolean invalidateOnChange;
    private NearCache<Object, Object> nearCache;
    private MapNearCacheManager mapNearCacheManager;
    private RepairingHandler repairingHandler;
    private volatile String invalidationListenerId;

    public NearCachedMapProxyImpl(String name, MapService mapService, NodeEngine nodeEngine, MapConfig mapConfig) {
        super(name, mapService, nodeEngine, mapConfig);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.mapNearCacheManager = this.mapServiceContext.getMapNearCacheManager();
        this.cacheLocalEntries = this.getMapConfig().getNearCacheConfig().isCacheLocalEntries();
        NearCacheConfig nearCacheConfig = this.mapConfig.getNearCacheConfig();
        this.nearCache = this.mapNearCacheManager.getOrCreateNearCache(this.name, nearCacheConfig);
        this.invalidateOnChange = this.nearCache.isInvalidatedOnChange();
        if (this.invalidateOnChange) {
            this.registerInvalidationListener();
        }
    }

    @Override
    protected Object getInternal(Data key) {
        Object value = this.getCachedValue(key, true);
        if (value != NearCache.NOT_CACHED) {
            return value;
        }
        long reservationId = this.tryReserveForUpdate(key);
        if (reservationId == -1L) {
            value = super.getInternal(key);
        } else {
            try {
                value = super.getInternal(key);
                value = this.tryPublishReserved(key, value, reservationId);
            }
            catch (Throwable throwable) {
                this.invalidateCache(key);
                throw ExceptionUtil.rethrow(throwable);
            }
        }
        return value;
    }

    @Override
    protected InternalCompletableFuture<Data> getAsyncInternal(final Data key) {
        InternalCompletableFuture<Data> future;
        Object value = this.getCachedValue(key, false);
        if (value != NearCache.NOT_CACHED) {
            return new CompletedFuture<Data>(this.getNodeEngine().getSerializationService(), value, this.getNodeEngine().getExecutionService().getExecutor("hz:async"));
        }
        final long reservationId = this.tryReserveForUpdate(key);
        try {
            future = super.getAsyncInternal(key);
        }
        catch (Throwable t) {
            this.invalidateCache(key);
            throw ExceptionUtil.rethrow(t);
        }
        future.andThen(new ExecutionCallback<Data>(){

            @Override
            public void onResponse(Data value) {
                NearCachedMapProxyImpl.this.nearCache.tryPublishReserved(key, value, reservationId, false);
            }

            @Override
            public void onFailure(Throwable t) {
                NearCachedMapProxyImpl.this.invalidateCache(key);
            }
        });
        return future;
    }

    @Override
    protected Data putInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        Data data = super.putInternal(key, value, ttl, timeunit);
        this.invalidateCache(key);
        return data;
    }

    @Override
    protected boolean tryPutInternal(Data key, Data value, long timeout, TimeUnit timeunit) {
        boolean putInternal = super.tryPutInternal(key, value, timeout, timeunit);
        this.invalidateCache(key);
        return putInternal;
    }

    @Override
    protected Data putIfAbsentInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        Data data = super.putIfAbsentInternal(key, value, ttl, timeunit);
        this.invalidateCache(key);
        return data;
    }

    @Override
    protected void putTransientInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        super.putTransientInternal(key, value, ttl, timeunit);
        this.invalidateCache(key);
    }

    @Override
    protected InternalCompletableFuture<Data> putAsyncInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        InternalCompletableFuture<Data> future = super.putAsyncInternal(key, value, ttl, timeunit);
        this.invalidateCache(key);
        return future;
    }

    @Override
    protected InternalCompletableFuture<Data> setAsyncInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        InternalCompletableFuture<Data> future = super.setAsyncInternal(key, value, ttl, timeunit);
        this.invalidateCache(key);
        return future;
    }

    @Override
    protected boolean replaceInternal(Data key, Data expect, Data update) {
        boolean replaceInternal = super.replaceInternal(key, expect, update);
        this.invalidateCache(key);
        return replaceInternal;
    }

    @Override
    protected Data replaceInternal(Data key, Data value) {
        Data replaceInternal = super.replaceInternal(key, value);
        this.invalidateCache(key);
        return replaceInternal;
    }

    @Override
    protected void setInternal(Data key, Data value, long ttl, TimeUnit timeunit) {
        super.setInternal(key, value, ttl, timeunit);
        this.invalidateCache(key);
    }

    @Override
    protected boolean evictInternal(Data key) {
        boolean evictInternal = super.evictInternal(key);
        this.invalidateCache(key);
        return evictInternal;
    }

    @Override
    protected void evictAllInternal() {
        super.evictAllInternal();
        this.nearCache.clear();
    }

    @Override
    public void clearInternal() {
        super.clearInternal();
        this.nearCache.clear();
    }

    @Override
    public void loadAllInternal(boolean replaceExistingValues) {
        super.loadAllInternal(replaceExistingValues);
        if (replaceExistingValues) {
            this.nearCache.clear();
        }
    }

    @Override
    protected void loadInternal(Iterable<Data> keys, boolean replaceExistingValues) {
        super.loadInternal(keys, replaceExistingValues);
        this.invalidateCache(keys);
    }

    @Override
    protected Data removeInternal(Data key) {
        Data data = super.removeInternal(key);
        this.invalidateCache(key);
        return data;
    }

    @Override
    protected void removeAllInternal(Predicate predicate) {
        super.removeAllInternal(predicate);
        this.nearCache.clear();
    }

    @Override
    protected void deleteInternal(Data key) {
        super.deleteInternal(key);
        this.invalidateCache(key);
    }

    @Override
    protected boolean removeInternal(Data key, Data value) {
        boolean removeInternal = super.removeInternal(key, value);
        this.invalidateCache(key);
        return removeInternal;
    }

    @Override
    protected boolean tryRemoveInternal(Data key, long timeout, TimeUnit timeunit) {
        boolean removeInternal = super.tryRemoveInternal(key, timeout, timeunit);
        this.invalidateCache(key);
        return removeInternal;
    }

    @Override
    protected InternalCompletableFuture<Data> removeAsyncInternal(Data key) {
        this.invalidateCache(key);
        return super.removeAsyncInternal(key);
    }

    @Override
    protected boolean containsKeyInternal(Data keyData) {
        Object cachedValue = this.getCachedValue(keyData, false);
        if (cachedValue != NearCache.NOT_CACHED) {
            return cachedValue != null;
        }
        return super.containsKeyInternal(keyData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getAllObjectInternal(List<Data> keys, List<Object> resultingKeyValuePairs) {
        this.getCachedValues(keys, resultingKeyValuePairs);
        Map<Data, Long> reservations = Collections.emptyMap();
        try {
            reservations = this.tryReserveForUpdate(keys);
            int currentSize = resultingKeyValuePairs.size();
            super.getAllObjectInternal(keys, resultingKeyValuePairs);
            int i = currentSize;
            while (i < resultingKeyValuePairs.size()) {
                Data key = this.toData(resultingKeyValuePairs.get(i++));
                Data value = this.toData(resultingKeyValuePairs.get(i++));
                Long reservationId = reservations.get(key);
                if (reservationId == null) continue;
                Object cachedValue = this.tryPublishReserved(key, value, reservationId);
                resultingKeyValuePairs.set(i - 1, cachedValue);
                reservations.remove(key);
            }
        }
        finally {
            this.releaseReservedKeys(reservations);
        }
    }

    private Map<Data, Long> tryReserveForUpdate(List<Data> keys) {
        Map<Data, Long> reservedKeys = MapUtil.createHashMap(keys.size());
        for (Data key : keys) {
            long reservationId = this.tryReserveForUpdate(key);
            if (reservationId == -1L) continue;
            reservedKeys.put(key, reservationId);
        }
        return reservedKeys;
    }

    private void releaseReservedKeys(Map<Data, Long> reservationResults) {
        for (Data key : reservationResults.keySet()) {
            this.invalidateCache(key);
        }
    }

    @Override
    protected void invokePutAllOperationFactory(Address address, long size, int[] partitions, MapEntries[] entries) throws Exception {
        super.invokePutAllOperationFactory(address, size, partitions, entries);
        for (MapEntries mapEntries : entries) {
            for (int i = 0; i < mapEntries.size(); ++i) {
                this.invalidateCache(mapEntries.getKey(i));
            }
        }
    }

    @Override
    public Data executeOnKeyInternal(Data key, EntryProcessor entryProcessor) {
        Data data = super.executeOnKeyInternal(key, entryProcessor);
        this.invalidateCache(key);
        return data;
    }

    @Override
    public Map executeOnKeysInternal(Set<Data> keys, EntryProcessor entryProcessor) {
        Map map = super.executeOnKeysInternal((Set)keys, entryProcessor);
        this.invalidateCache((Collection<Data>)keys);
        return map;
    }

    @Override
    public InternalCompletableFuture<Object> executeOnKeyInternal(Data key, EntryProcessor entryProcessor, ExecutionCallback<Object> callback) {
        InternalCompletableFuture future = super.executeOnKeyInternal(key, entryProcessor, (ExecutionCallback)callback);
        this.invalidateCache(key);
        return future;
    }

    @Override
    public void executeOnEntriesInternal(EntryProcessor entryProcessor, Predicate predicate, List<Data> resultingKeyValuePairs) {
        super.executeOnEntriesInternal(entryProcessor, predicate, (List)resultingKeyValuePairs);
        for (int i = 0; i < resultingKeyValuePairs.size(); i += 2) {
            Data key = resultingKeyValuePairs.get(i);
            this.invalidateCache(key);
        }
    }

    @Override
    protected boolean preDestroy() {
        if (this.invalidateOnChange) {
            this.mapNearCacheManager.deregisterRepairingHandler(this.name);
            this.removeEntryListener(this.invalidationListenerId);
        }
        return super.preDestroy();
    }

    private void getCachedValues(List<Data> keys, List<Object> resultingKeyValuePairs) {
        Iterator<Data> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Data key = iterator.next();
            Object value = this.getCachedValue(key, true);
            if (value == null || value == NearCache.NOT_CACHED) continue;
            resultingKeyValuePairs.add(this.toObject(key));
            resultingKeyValuePairs.add(this.toObject(value));
            iterator.remove();
        }
    }

    protected void invalidateCache(Data key) {
        if (key == null) {
            return;
        }
        this.nearCache.remove(key);
    }

    protected void invalidateCache(Collection<Data> keys) {
        for (Data key : keys) {
            this.nearCache.remove(key);
        }
    }

    protected void invalidateCache(Iterable<Data> keys) {
        for (Data key : keys) {
            this.nearCache.remove(key);
        }
    }

    protected boolean isOwn(Data key) {
        int partitionId = this.partitionService.getPartitionId(key);
        Address partitionOwner = this.partitionService.getPartitionOwner(partitionId);
        return this.thisAddress.equals(partitionOwner);
    }

    private Object tryPublishReserved(Data key, Object value, long reservationId) {
        assert (value != NearCache.NOT_CACHED);
        Object cachedValue = this.nearCache.tryPublishReserved(key, value, reservationId, true);
        return cachedValue != null ? cachedValue : value;
    }

    private boolean cachingAllowedFor(Data key) {
        return !this.isOwn(key) || this.cacheLocalEntries;
    }

    private Object getCachedValue(Data key, boolean deserializeValue) {
        Object value = this.nearCache.get(key);
        if (value == null) {
            return NearCache.NOT_CACHED;
        }
        if (value == NearCache.CACHED_AS_NULL) {
            return null;
        }
        this.mapServiceContext.interceptAfterGet(this.name, value);
        return deserializeValue ? this.toObject(value) : value;
    }

    private long tryReserveForUpdate(Data key) {
        if (!this.cachingAllowedFor(key)) {
            return -1L;
        }
        return this.nearCache.tryReserveForUpdate(key);
    }

    public NearCache<Object, Object> getNearCache() {
        return this.nearCache;
    }

    public String addNearCacheInvalidationListener(InvalidationListener listener) {
        String localMemberUuid = this.getNodeEngine().getClusterService().getLocalMember().getUuid();
        UuidFilter eventFilter = new UuidFilter(localMemberUuid);
        return this.mapServiceContext.addEventListener(listener, eventFilter, this.name);
    }

    private void registerInvalidationListener() {
        this.repairingHandler = this.mapNearCacheManager.newRepairingHandler(this.name, this.nearCache);
        this.invalidationListenerId = this.addNearCacheInvalidationListener(new NearCacheInvalidationListener());
    }

    private final class NearCacheInvalidationListener
    implements InvalidationListener {
        private NearCacheInvalidationListener() {
        }

        @Override
        public void onInvalidate(Invalidation invalidation) {
            assert (invalidation != null);
            if (invalidation instanceof BatchNearCacheInvalidation) {
                List<Invalidation> batch = ((BatchNearCacheInvalidation)invalidation).getInvalidations();
                for (Invalidation single : batch) {
                    this.handleInternal(single);
                }
            } else {
                this.handleInternal(invalidation);
            }
        }

        private void handleInternal(Invalidation single) {
            NearCachedMapProxyImpl.this.repairingHandler.handle(single.getKey(), single.getSourceUuid(), single.getPartitionUuid(), single.getSequence());
        }
    }
}

