/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.RingbufferStoreConfig;
import com.hazelcast.spi.annotation.Beta;
import com.hazelcast.util.Preconditions;

@Beta
public class RingbufferConfig {
    public static final int DEFAULT_CAPACITY = 10000;
    public static final int DEFAULT_SYNC_BACKUP_COUNT = 1;
    public static final int DEFAULT_ASYNC_BACKUP_COUNT = 0;
    public static final int DEFAULT_TTL_SECONDS = 0;
    public static final InMemoryFormat DEFAULT_IN_MEMORY_FORMAT = InMemoryFormat.BINARY;
    private String name;
    private int capacity = 10000;
    private int backupCount = 1;
    private int asyncBackupCount = 0;
    private int timeToLiveSeconds = 0;
    private InMemoryFormat inMemoryFormat = DEFAULT_IN_MEMORY_FORMAT;
    private RingbufferStoreConfig ringbufferStoreConfig = new RingbufferStoreConfig().setEnabled(false);

    public RingbufferConfig() {
    }

    public RingbufferConfig(String name) {
        this.name = Preconditions.checkNotNull(name, "name can't be null");
    }

    public RingbufferConfig(RingbufferConfig config) {
        Preconditions.checkNotNull(config, "config can't be null");
        this.name = config.name;
        this.capacity = config.capacity;
        this.backupCount = config.backupCount;
        this.asyncBackupCount = config.asyncBackupCount;
        this.timeToLiveSeconds = config.timeToLiveSeconds;
        this.inMemoryFormat = config.inMemoryFormat;
        if (config.ringbufferStoreConfig != null) {
            this.ringbufferStoreConfig = new RingbufferStoreConfig(config.ringbufferStoreConfig);
        }
    }

    public RingbufferConfig(String name, RingbufferConfig config) {
        this(config);
        this.name = Preconditions.checkNotNull(name, "name can't be null");
    }

    public RingbufferConfig setName(String name) {
        this.name = Preconditions.checkHasText(name, "name must contain text");
        return this;
    }

    public String getName() {
        return this.name;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public RingbufferConfig setCapacity(int capacity) {
        Preconditions.checkPositive(capacity, "capacity can't be smaller than 1");
        this.capacity = capacity;
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public RingbufferConfig setBackupCount(int backupCount) {
        this.backupCount = Preconditions.checkBackupCount(backupCount, this.asyncBackupCount);
        return this;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public RingbufferConfig setAsyncBackupCount(int asyncBackupCount) {
        this.asyncBackupCount = Preconditions.checkAsyncBackupCount(this.backupCount, asyncBackupCount);
        return this;
    }

    public int getTotalBackupCount() {
        return this.backupCount + this.asyncBackupCount;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public RingbufferConfig setTimeToLiveSeconds(int timeToLiveSeconds) {
        this.timeToLiveSeconds = Preconditions.checkNotNegative(timeToLiveSeconds, "timeToLiveSeconds can't be smaller than 0");
        return this;
    }

    public InMemoryFormat getInMemoryFormat() {
        return this.inMemoryFormat;
    }

    public RingbufferConfig setInMemoryFormat(InMemoryFormat inMemoryFormat) {
        Preconditions.checkNotNull(inMemoryFormat, "inMemoryFormat can't be null");
        Preconditions.checkFalse(inMemoryFormat == InMemoryFormat.NATIVE, "InMemoryFormat " + (Object)((Object)InMemoryFormat.NATIVE) + " is not supported");
        this.inMemoryFormat = inMemoryFormat;
        return this;
    }

    public String toString() {
        return "RingbufferConfig{name='" + this.name + '\'' + ", capacity=" + this.capacity + ", backupCount=" + this.backupCount + ", asyncBackupCount=" + this.asyncBackupCount + ", timeToLiveSeconds=" + this.timeToLiveSeconds + ", inMemoryFormat=" + (Object)((Object)this.inMemoryFormat) + ", ringbufferStoreConfig=" + this.ringbufferStoreConfig + '}';
    }

    public RingbufferStoreConfig getRingbufferStoreConfig() {
        return this.ringbufferStoreConfig;
    }

    public RingbufferConfig setRingbufferStoreConfig(RingbufferStoreConfig ringbufferStoreConfig) {
        this.ringbufferStoreConfig = ringbufferStoreConfig;
        return this;
    }

    public RingbufferConfig getAsReadOnly() {
        return new RingbufferConfigReadonly(this);
    }

    @Beta
    private static class RingbufferConfigReadonly
    extends RingbufferConfig {
        RingbufferConfigReadonly(RingbufferConfig config) {
            super(config);
        }

        @Override
        public RingbufferStoreConfig getRingbufferStoreConfig() {
            RingbufferStoreConfig storeConfig = super.getRingbufferStoreConfig();
            if (storeConfig != null) {
                return storeConfig.getAsReadOnly();
            }
            return null;
        }

        @Override
        public RingbufferConfig setCapacity(int capacity) {
            throw new UnsupportedOperationException("This config is read-only");
        }

        @Override
        public RingbufferConfig setAsyncBackupCount(int asyncBackupCount) {
            throw new UnsupportedOperationException("This config is read-only");
        }

        @Override
        public RingbufferConfig setBackupCount(int backupCount) {
            throw new UnsupportedOperationException("This config is read-only");
        }

        @Override
        public RingbufferConfig setTimeToLiveSeconds(int timeToLiveSeconds) {
            throw new UnsupportedOperationException("This config is read-only");
        }

        @Override
        public RingbufferConfig setInMemoryFormat(InMemoryFormat inMemoryFormat) {
            throw new UnsupportedOperationException("This config is read-only");
        }

        @Override
        public RingbufferConfig setRingbufferStoreConfig(RingbufferStoreConfig ringbufferStoreConfig) {
            throw new UnsupportedOperationException("This config is read-only");
        }
    }
}

