/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.AbstractClusterWideIterator;
import com.hazelcast.cache.impl.ICacheInternal;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheIterateCodec;
import com.hazelcast.client.impl.protocol.codec.CacheIterateEntriesCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;
import java.util.Iterator;
import java.util.List;
import javax.cache.Cache;

public class ClientClusterWideIterator<K, V>
extends AbstractClusterWideIterator<K, V>
implements Iterator<Cache.Entry<K, V>> {
    private ICacheInternal<K, V> cacheProxy;
    private ClientContext context;

    public ClientClusterWideIterator(ICacheInternal<K, V> cacheProxy, ClientContext context, boolean prefetchValues) {
        this(cacheProxy, context, 100, prefetchValues);
    }

    public ClientClusterWideIterator(ICacheInternal<K, V> cacheProxy, ClientContext context, int fetchSize, boolean prefetchValues) {
        super(cacheProxy, context.getPartitionService().getPartitionCount(), fetchSize, prefetchValues);
        this.cacheProxy = cacheProxy;
        this.context = context;
        this.advance();
    }

    public ClientClusterWideIterator(ICacheInternal<K, V> cacheProxy, ClientContext context, int fetchSize, int partitionId, boolean prefetchValues) {
        super(cacheProxy, context.getPartitionService().getPartitionCount(), fetchSize, prefetchValues);
        this.cacheProxy = cacheProxy;
        this.context = context;
        this.partitionIndex = partitionId;
        this.advance();
    }

    @Override
    protected List fetch() {
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.context.getHazelcastInstance();
        if (this.prefetchValues) {
            ClientMessage request = CacheIterateEntriesCodec.encodeRequest(this.cacheProxy.getPrefixedName(), this.partitionIndex, this.lastTableIndex, this.fetchSize);
            try {
                ClientInvocation clientInvocation = new ClientInvocation(client, request, this.partitionIndex);
                ClientInvocationFuture future = clientInvocation.invoke();
                CacheIterateEntriesCodec.ResponseParameters responseParameters = CacheIterateEntriesCodec.decodeResponse((ClientMessage)future.get());
                this.setLastTableIndex(responseParameters.entries, responseParameters.tableIndex);
                return responseParameters.entries;
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        ClientMessage request = CacheIterateCodec.encodeRequest(this.cacheProxy.getPrefixedName(), this.partitionIndex, this.lastTableIndex, this.fetchSize);
        try {
            ClientInvocation clientInvocation = new ClientInvocation(client, request, this.partitionIndex);
            ClientInvocationFuture future = clientInvocation.invoke();
            CacheIterateCodec.ResponseParameters responseParameters = CacheIterateCodec.decodeResponse((ClientMessage)future.get());
            this.setLastTableIndex(responseParameters.keys, responseParameters.tableIndex);
            return responseParameters.keys;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    protected Data toData(Object obj) {
        return this.context.getSerializationService().toData(obj);
    }

    @Override
    protected <T> T toObject(Object data) {
        return this.context.getSerializationService().toObject(data);
    }
}

