/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl.nearcache.invalidation;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheAssignAndGetUuidsCodec;
import com.hazelcast.client.impl.protocol.codec.CacheFetchNearCacheInvalidationMetadataCodec;
import com.hazelcast.client.impl.protocol.codec.MapAssignAndGetUuidsCodec;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.Member;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataFetcher;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.InternalCompletableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ClientCacheMetaDataFetcher
extends MetaDataFetcher {
    private final ClientClusterService clusterService;
    private final HazelcastClientInstanceImpl clientImpl;

    public ClientCacheMetaDataFetcher(ClientContext clientContext) {
        super(Logger.getLogger(ClientCacheMetaDataFetcher.class));
        this.clusterService = clientContext.getClusterService();
        this.clientImpl = (HazelcastClientInstanceImpl)clientContext.getHazelcastInstance();
    }

    @Override
    protected List<InternalCompletableFuture> scanMembers(List<String> names) {
        Collection<Member> members = this.clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        ArrayList<InternalCompletableFuture> futures = new ArrayList<InternalCompletableFuture>(members.size());
        for (Member member : members) {
            Address address = member.getAddress();
            ClientMessage message = CacheFetchNearCacheInvalidationMetadataCodec.encodeRequest(names, address);
            ClientInvocation invocation = new ClientInvocation(this.clientImpl, message, address);
            try {
                futures.add(invocation.invoke());
            }
            catch (Exception e) {
                if (!this.logger.isWarningEnabled()) continue;
                this.logger.warning("Cant fetch invalidation meta-data from address + " + address + " + [" + e.getMessage() + "]");
            }
        }
        return futures;
    }

    @Override
    protected void process(InternalCompletableFuture future, ConcurrentMap<String, RepairingHandler> handlers) {
        block2: {
            try {
                CacheFetchNearCacheInvalidationMetadataCodec.ResponseParameters response = this.extractResponse(future);
                this.repairUuids(response.partitionUuidList, handlers);
                this.repairSequences(response.namePartitionSequenceList, handlers);
            }
            catch (Exception e) {
                if (!this.logger.isWarningEnabled()) break block2;
                this.logger.warning("Cant fetch invalidation meta-data [" + e.getMessage() + "]");
            }
        }
    }

    private CacheFetchNearCacheInvalidationMetadataCodec.ResponseParameters extractResponse(InternalCompletableFuture future) throws InterruptedException, ExecutionException, TimeoutException {
        ClientMessage message = (ClientMessage)future.get(1L, TimeUnit.MINUTES);
        return CacheFetchNearCacheInvalidationMetadataCodec.decodeResponse(message);
    }

    public List<Map.Entry<Integer, UUID>> assignAndGetUuids() throws Exception {
        ClientMessage request = MapAssignAndGetUuidsCodec.encodeRequest();
        ClientInvocation invocation = new ClientInvocation(this.clientImpl, request);
        CacheAssignAndGetUuidsCodec.ResponseParameters responseParameters = CacheAssignAndGetUuidsCodec.decodeResponse((ClientMessage)invocation.invoke().get());
        return responseParameters.partitionUuidList;
    }
}

