/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapFetchWithQueryCodec;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.map.impl.iterator.AbstractMapQueryPartitionIterator;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ExceptionUtil;
import java.util.List;
import java.util.Map;

public class ClientMapQueryPartitionIterator<K, V, R>
extends AbstractMapQueryPartitionIterator<K, V, R> {
    private final ClientMapProxy<K, V> mapProxy;
    private final ClientContext context;

    public ClientMapQueryPartitionIterator(ClientMapProxy<K, V> mapProxy, ClientContext context, int fetchSize, int partitionId, Predicate<K, V> predicate, Projection<Map.Entry<K, V>, R> projection) {
        super(mapProxy, fetchSize, partitionId, predicate, projection);
        this.mapProxy = mapProxy;
        this.context = context;
    }

    @Override
    protected List<Data> fetch() {
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.context.getHazelcastInstance();
        ClientMessage request = MapFetchWithQueryCodec.encodeRequest(this.mapProxy.getName(), this.lastTableIndex, this.fetchSize, this.getSerializationService().toData(this.query.getProjection()), this.getSerializationService().toData(this.query.getPredicate()));
        ClientInvocation clientInvocation = new ClientInvocation(client, request, this.partitionId);
        try {
            ClientInvocationFuture f = clientInvocation.invoke();
            MapFetchWithQueryCodec.ResponseParameters responseParameters = MapFetchWithQueryCodec.decodeResponse((ClientMessage)f.get());
            List<Data> results = responseParameters.results;
            this.setLastTableIndex(results, responseParameters.nextTableIndexToReadFrom);
            return results;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    protected SerializationService getSerializationService() {
        return this.context.getSerializationService();
    }
}

