/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapAddNearCacheEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapAddNearCacheInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.MapRemoveEntryListenerCodec;
import com.hazelcast.client.proxy.ClientMapProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.internal.adapter.IMapDataStructureAdapter;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.MapUtil;
import com.hazelcast.util.executor.CompletedFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class NearCachedClientMapProxy<K, V>
extends ClientMapProxy<K, V> {
    private final int minConsistentNearCacheSupportingServerVersion = BuildInfo.calculateVersion("3.8");
    private ILogger logger;
    private boolean serializeKeys;
    private NearCache<Object, Object> nearCache;
    private volatile String invalidationListenerId;

    public NearCachedClientMapProxy(String serviceName, String name, ClientContext context) {
        super(serviceName, name, context);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.logger = this.getContext().getLoggingService().getLogger(this.getClass());
        NearCacheConfig nearCacheConfig = this.getContext().getClientConfig().getNearCacheConfig(this.name);
        this.serializeKeys = nearCacheConfig.isSerializeKeys();
        NearCacheManager nearCacheManager = this.getContext().getNearCacheManager();
        IMapDataStructureAdapter adapter = new IMapDataStructureAdapter(this);
        this.nearCache = nearCacheManager.getOrCreateNearCache(this.name, nearCacheConfig, adapter);
        if (nearCacheConfig.isInvalidateOnChange()) {
            this.registerInvalidationListener();
        }
    }

    @Override
    protected boolean containsKeyInternal(Object key) {
        Object cached = this.getCachedValue(key, false);
        if (cached != NearCache.NOT_CACHED) {
            return true;
        }
        return super.containsKeyInternal(key);
    }

    @Override
    protected V getInternal(Object key) {
        key = this.serializeKeys ? this.toData(key) : key;
        Object value = this.getCachedValue(key, true);
        if (value != NearCache.NOT_CACHED) {
            return (V)value;
        }
        try {
            Data keyData = this.toData(key);
            long reservationId = this.nearCache.tryReserveForUpdate(key, keyData);
            value = super.getInternal(keyData);
            if (reservationId != -1L) {
                value = this.tryPublishReserved(key, value, reservationId);
            }
            return (V)value;
        }
        catch (Throwable throwable) {
            this.invalidateNearCache(key);
            throw ExceptionUtil.rethrow(throwable);
        }
    }

    @Override
    public ICompletableFuture<V> getAsyncInternal(Object keyParameter) {
        ICompletableFuture future;
        final Object key = this.serializeKeys ? this.toData(keyParameter) : keyParameter;
        Object value = this.getCachedValue(key, false);
        if (value != NearCache.NOT_CACHED) {
            ExecutorService executor = this.getContext().getExecutionService().getUserExecutor();
            return new CompletedFuture(this.getSerializationService(), value, executor);
        }
        Data keyData = this.toData(key);
        final long reservationId = this.nearCache.tryReserveForUpdate(key, keyData);
        try {
            future = super.getAsyncInternal(keyData);
        }
        catch (Throwable t) {
            this.invalidateNearCache(key);
            throw ExceptionUtil.rethrow(t);
        }
        if (reservationId != -1L) {
            ((ClientDelegatingFuture)future).andThenInternal(new ExecutionCallback<Object>(){

                @Override
                public void onResponse(Object value) {
                    NearCachedClientMapProxy.this.nearCache.tryPublishReserved(key, value, reservationId, false);
                }

                @Override
                public void onFailure(Throwable t) {
                    NearCachedClientMapProxy.this.invalidateNearCache(key);
                }
            }, false);
        }
        return future;
    }

    @Override
    protected MapRemoveCodec.ResponseParameters removeInternal(Object key) {
        MapRemoveCodec.ResponseParameters responseParameters;
        key = this.serializeKeys ? this.toData(key) : key;
        try {
            responseParameters = super.removeInternal(key);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return responseParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean removeInternal(Object key, Object value) {
        boolean removed;
        key = this.serializeKeys ? this.toData(key) : key;
        try {
            removed = super.removeInternal(key, value);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return removed;
    }

    @Override
    protected void removeAllInternal(Predicate predicate) {
        try {
            super.removeAllInternal(predicate);
        }
        finally {
            this.nearCache.clear();
        }
    }

    @Override
    protected void deleteInternal(Object key) {
        key = this.serializeKeys ? this.toData(key) : key;
        try {
            super.deleteInternal(key);
        }
        finally {
            this.invalidateNearCache(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ICompletableFuture<V> putAsyncInternal(long ttl, TimeUnit timeunit, Object key, Object value) {
        ICompletableFuture future;
        key = this.serializeKeys ? this.toData(key) : key;
        try {
            future = super.putAsyncInternal(ttl, timeunit, key, value);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ICompletableFuture<Void> setAsyncInternal(long ttl, TimeUnit timeunit, Object key, Object value) {
        ICompletableFuture<Void> future;
        key = this.serializeKeys ? this.toData(key) : key;
        try {
            future = super.setAsyncInternal(ttl, timeunit, key, value);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return future;
    }

    @Override
    protected ICompletableFuture<V> removeAsyncInternal(Object key) {
        ICompletableFuture future;
        key = this.serializeKeys ? this.toData(key) : key;
        try {
            future = super.removeAsyncInternal(key);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean tryRemoveInternal(long timeout, TimeUnit timeunit, Object key) {
        boolean removed;
        key = this.serializeKeys ? this.toData(key) : key;
        try {
            removed = super.tryRemoveInternal(timeout, timeunit, key);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean tryPutInternal(long timeout, TimeUnit timeunit, Object key, Object value) {
        boolean putInternal;
        key = this.serializeKeys ? this.toData(key) : key;
        try {
            putInternal = super.tryPutInternal(timeout, timeunit, key, value);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return putInternal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected V putInternal(long ttl, TimeUnit timeunit, Object key, Object value) {
        Object previousValue;
        key = this.serializeKeys ? this.toData(key) : key;
        try {
            previousValue = super.putInternal(ttl, timeunit, key, value);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return previousValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void putTransientInternal(long ttl, TimeUnit timeunit, Object key, Object value) {
        key = this.serializeKeys ? this.toData(key) : key;
        try {
            super.putTransientInternal(ttl, timeunit, key, value);
        }
        finally {
            this.invalidateNearCache(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected V putIfAbsentInternal(long ttl, TimeUnit timeunit, Object key, Object value) {
        Object previousValue;
        key = this.serializeKeys ? this.toData(key) : key;
        try {
            previousValue = super.putIfAbsentInternal(ttl, timeunit, key, value);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return previousValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean replaceIfSameInternal(Object key, Object oldValue, Object newValue) {
        boolean replaceIfSame;
        key = this.serializeKeys ? this.toData(key) : key;
        try {
            replaceIfSame = super.replaceIfSameInternal(key, oldValue, newValue);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return replaceIfSame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected V replaceInternal(Object key, Object value) {
        Object v;
        key = this.serializeKeys ? this.toData(key) : key;
        try {
            v = super.replaceInternal(key, value);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setInternal(long ttl, TimeUnit timeunit, Object key, Object value) {
        key = this.serializeKeys ? this.toData(key) : key;
        try {
            super.setInternal(ttl, timeunit, key, value);
        }
        finally {
            this.invalidateNearCache(key);
        }
    }

    @Override
    protected boolean evictInternal(Object key) {
        boolean evicted;
        key = this.serializeKeys ? this.toData(key) : key;
        try {
            evicted = super.evictInternal(key);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return evicted;
    }

    @Override
    public void evictAll() {
        try {
            super.evictAll();
        }
        finally {
            this.nearCache.clear();
        }
    }

    @Override
    public void loadAll(boolean replaceExistingValues) {
        super.loadAll(replaceExistingValues);
        if (replaceExistingValues) {
            this.nearCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadAllInternal(boolean replaceExistingValues, Collection<?> keysParameter) {
        Collection<?> keys = this.serializeKeys ? CollectionUtil.objectToDataCollection(keysParameter, this.getSerializationService()) : keysParameter;
        try {
            super.loadAllInternal(replaceExistingValues, keys);
        }
        finally {
            for (Object key : keys) {
                this.invalidateNearCache(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getAllInternal(Set<K> keys, Map<Integer, List<Data>> partitionToKeyData, List<Object> resultingKeyValuePairs) {
        Map<Object, Data> keyMap = MapUtil.createHashMap(keys.size());
        if (this.serializeKeys) {
            this.fillPartitionToKeyData(keys, partitionToKeyData, keyMap, null);
        }
        LinkedList<K> ncKeys = this.serializeKeys ? keyMap.values() : new LinkedList<K>(keys);
        this.populateResultFromNearCache(ncKeys, resultingKeyValuePairs);
        if (ncKeys.isEmpty()) {
            return;
        }
        Map<Data, Object> reverseKeyMap = null;
        if (!this.serializeKeys) {
            reverseKeyMap = MapUtil.createHashMap(ncKeys.size());
            this.fillPartitionToKeyData(keys, partitionToKeyData, keyMap, reverseKeyMap);
        }
        Map<Object, Long> reservations = this.getNearCacheReservations(ncKeys, keyMap);
        try {
            int currentSize = resultingKeyValuePairs.size();
            super.getAllInternal(keys, partitionToKeyData, resultingKeyValuePairs);
            this.populateResultFromRemote(currentSize, resultingKeyValuePairs, reservations, reverseKeyMap);
        }
        finally {
            this.releaseRemainingReservedKeys(reservations);
        }
    }

    private void populateResultFromNearCache(Collection<?> keys, List<Object> resultingKeyValuePairs) {
        Iterator<?> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object cached = this.getCachedValue(key, true);
            if (cached == null || cached == NearCache.NOT_CACHED) continue;
            resultingKeyValuePairs.add(key);
            resultingKeyValuePairs.add(cached);
            iterator.remove();
        }
    }

    private Map<Object, Long> getNearCacheReservations(Collection<?> nearCacheKeys, Map<Object, Data> keyMap) {
        Map<Object, Long> reservations = MapUtil.createHashMap(nearCacheKeys.size());
        for (Object key : nearCacheKeys) {
            Data keyData;
            long reservationId = this.nearCache.tryReserveForUpdate(key, keyData = this.serializeKeys ? (Data)key : keyMap.get(key));
            if (reservationId == -1L) continue;
            reservations.put(key, reservationId);
        }
        return reservations;
    }

    private void populateResultFromRemote(int currentSize, List<Object> resultingKeyValuePairs, Map<Object, Long> reservations, Map<Data, Object> reverseKeyMap) {
        for (int i = currentSize; i < resultingKeyValuePairs.size(); i += 2) {
            Long reservationId;
            Data ncKey;
            Data keyData = (Data)resultingKeyValuePairs.get(i);
            Data valueData = (Data)resultingKeyValuePairs.get(i + 1);
            Data data = ncKey = this.serializeKeys ? keyData : reverseKeyMap.get(keyData);
            if (!this.serializeKeys) {
                resultingKeyValuePairs.set(i, ncKey);
            }
            if ((reservationId = reservations.get(ncKey)) == null) continue;
            Object cachedValue = this.tryPublishReserved(ncKey, valueData, reservationId);
            resultingKeyValuePairs.set(i + 1, cachedValue);
            reservations.remove(ncKey);
        }
    }

    private void releaseRemainingReservedKeys(Map<Object, Long> reservedKeys) {
        for (Map.Entry<Object, Long> entry : reservedKeys.entrySet()) {
            Object key = this.serializeKeys ? this.toData(entry.getKey()) : entry.getKey();
            this.invalidateNearCache(key);
        }
    }

    @Override
    public LocalMapStats getLocalMapStats() {
        LocalMapStatsImpl localMapStats = (LocalMapStatsImpl)super.getLocalMapStats();
        localMapStats.setNearCacheStats(this.nearCache.getNearCacheStats());
        return localMapStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeOnKeyInternal(Object key, EntryProcessor entryProcessor) {
        Object response;
        key = this.serializeKeys ? this.toData(key) : key;
        try {
            response = super.executeOnKeyInternal(key, entryProcessor);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICompletableFuture submitToKeyInternal(Object key, EntryProcessor entryProcessor) {
        ICompletableFuture future;
        key = this.serializeKeys ? this.toData(key) : key;
        try {
            future = super.submitToKeyInternal(key, entryProcessor);
        }
        finally {
            this.invalidateNearCache(key);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitToKeyInternal(Object key, EntryProcessor entryProcessor, ExecutionCallback callback) {
        key = this.serializeKeys ? this.toData(key) : key;
        try {
            super.submitToKeyInternal(key, entryProcessor, callback);
        }
        finally {
            this.invalidateNearCache(key);
        }
    }

    @Override
    protected Map<K, Object> prepareResult(Collection<Map.Entry<Data, Data>> entrySet) {
        if (CollectionUtil.isEmpty(entrySet)) {
            return Collections.emptyMap();
        }
        Map result = MapUtil.createHashMap(entrySet.size());
        for (Map.Entry<Data, Data> entry : entrySet) {
            Data dataKey = entry.getKey();
            Object key = this.toObject(dataKey);
            Object value = this.toObject(entry.getValue());
            this.invalidateNearCache(this.serializeKeys ? dataKey : key);
            result.put(key, value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void putAllInternal(Map<? extends K, ? extends V> map, Map<Integer, List<Map.Entry<Data, Data>>> entryMap) {
        try {
            super.putAllInternal(map, entryMap);
        }
        finally {
            if (this.serializeKeys) {
                for (List<Map.Entry<Data, Data>> entries : entryMap.values()) {
                    for (Map.Entry<Data, Data> entry : entries) {
                        this.invalidateNearCache(entry.getKey());
                    }
                }
            } else {
                for (K key : map.keySet()) {
                    this.invalidateNearCache(key);
                }
            }
        }
    }

    @Override
    public void clear() {
        this.nearCache.clear();
        super.clear();
    }

    @Override
    protected void onDestroy() {
        this.removeNearCacheInvalidationListener();
        this.getContext().getNearCacheManager().destroyNearCache(this.name);
        super.onDestroy();
    }

    @Override
    protected void onShutdown() {
        this.removeNearCacheInvalidationListener();
        this.getContext().getNearCacheManager().destroyNearCache(this.name);
        super.onShutdown();
    }

    private Object tryPublishReserved(Object key, Object value, long reservationId) {
        assert (value != NearCache.NOT_CACHED);
        Object cachedValue = this.nearCache.tryPublishReserved(key, value, reservationId, true);
        return cachedValue != null ? cachedValue : value;
    }

    private Object getCachedValue(Object key, boolean deserializeValue) {
        Object value = this.nearCache.get(key);
        if (value == null) {
            return NearCache.NOT_CACHED;
        }
        if (value == NearCache.CACHED_AS_NULL) {
            return null;
        }
        return deserializeValue ? this.toObject(value) : value;
    }

    public NearCache<Object, Object> getNearCache() {
        return this.nearCache;
    }

    private void invalidateNearCache(Object key) {
        this.nearCache.remove(key);
    }

    public String addNearCacheInvalidationListener(EventHandler handler) {
        return this.registerListener(this.createNearCacheEntryListenerCodec(), handler);
    }

    private void registerInvalidationListener() {
        try {
            this.invalidationListenerId = this.addNearCacheInvalidationListener(new ConnectedServerVersionAwareNearCacheEventHandler());
        }
        catch (Exception e) {
            ILogger logger = this.getContext().getLoggingService().getLogger(this.getClass());
            logger.severe("-----------------\nNear Cache is not initialized!\n-----------------", e);
        }
    }

    private ListenerMessageCodec createNearCacheEntryListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                if (NearCachedClientMapProxy.this.supportsRepairableNearCache()) {
                    return MapAddNearCacheInvalidationListenerCodec.encodeRequest(NearCachedClientMapProxy.this.name, EntryEventType.INVALIDATION.getType(), localOnly);
                }
                return MapAddNearCacheEntryListenerCodec.encodeRequest(NearCachedClientMapProxy.this.name, EntryEventType.INVALIDATION.getType(), localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                if (NearCachedClientMapProxy.this.supportsRepairableNearCache()) {
                    return MapAddNearCacheInvalidationListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
                }
                return MapAddNearCacheEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return MapRemoveEntryListenerCodec.encodeRequest(NearCachedClientMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    private void removeNearCacheInvalidationListener() {
        String invalidationListenerId = this.invalidationListenerId;
        if (invalidationListenerId == null) {
            return;
        }
        this.getContext().getRepairingTask("hz:impl:mapService").deregisterHandler(this.name);
        this.deregisterListener(invalidationListenerId);
    }

    private int getConnectedServerVersion() {
        HazelcastClientInstanceImpl client = this.getClient();
        ClientConnectionManager connectionManager = client.getConnectionManager();
        ClientConnection connection = connectionManager.getOwnerConnection();
        if (connection == null) {
            this.logger.warning(String.format("No owner connection is available, near cached cache %s will be started in legacy mode", this.name));
            return -1;
        }
        return connection.getConnectedServerVersion();
    }

    private boolean supportsRepairableNearCache() {
        return this.getConnectedServerVersion() >= this.minConsistentNearCacheSupportingServerVersion;
    }

    private final class Pre38NearCacheEventHandler
    extends MapAddNearCacheEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private Pre38NearCacheEventHandler() {
        }

        @Override
        public void beforeListenerRegister() {
            NearCachedClientMapProxy.this.nearCache.clear();
        }

        @Override
        public void onListenerRegister() {
            NearCachedClientMapProxy.this.nearCache.clear();
        }

        @Override
        public void handle(Data key, String sourceUuid, UUID partitionUuid, long sequence) {
            if (key == null) {
                NearCachedClientMapProxy.this.nearCache.clear();
            } else {
                NearCachedClientMapProxy.this.nearCache.remove(NearCachedClientMapProxy.this.serializeKeys ? key : NearCachedClientMapProxy.this.toObject(key));
            }
        }

        @Override
        public void handle(Collection<Data> keys, Collection<String> sourceUuids, Collection<UUID> partitionUuids, Collection<Long> sequences) {
            for (Data key : keys) {
                NearCachedClientMapProxy.this.nearCache.remove(NearCachedClientMapProxy.this.serializeKeys ? key : NearCachedClientMapProxy.this.toObject(key));
            }
        }
    }

    private final class RepairableNearCacheEventHandler
    extends MapAddNearCacheInvalidationListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private volatile RepairingHandler repairingHandler;

        private RepairableNearCacheEventHandler() {
        }

        @Override
        public void beforeListenerRegister() {
            NearCachedClientMapProxy.this.nearCache.clear();
            this.getRepairingTask().deregisterHandler(NearCachedClientMapProxy.this.name);
        }

        @Override
        public void onListenerRegister() {
            NearCachedClientMapProxy.this.nearCache.clear();
            this.repairingHandler = this.getRepairingTask().registerAndGetHandler(NearCachedClientMapProxy.this.name, NearCachedClientMapProxy.this.nearCache);
        }

        @Override
        public void handle(Data key, String sourceUuid, UUID partitionUuid, long sequence) {
            this.repairingHandler.handle(key, sourceUuid, partitionUuid, sequence);
        }

        @Override
        public void handle(Collection<Data> keys, Collection<String> sourceUuids, Collection<UUID> partitionUuids, Collection<Long> sequences) {
            this.repairingHandler.handle(keys, sourceUuids, partitionUuids, sequences);
        }

        private RepairingTask getRepairingTask() {
            return NearCachedClientMapProxy.this.getContext().getRepairingTask("hz:impl:mapService");
        }
    }

    private final class ConnectedServerVersionAwareNearCacheEventHandler
    implements EventHandler<ClientMessage> {
        private final RepairableNearCacheEventHandler repairingEventHandler;
        private final Pre38NearCacheEventHandler pre38EventHandler;
        private volatile boolean supportsRepairableNearCache;

        private ConnectedServerVersionAwareNearCacheEventHandler() {
            this.repairingEventHandler = new RepairableNearCacheEventHandler();
            this.pre38EventHandler = new Pre38NearCacheEventHandler();
        }

        @Override
        public void beforeListenerRegister() {
            this.repairingEventHandler.beforeListenerRegister();
            this.pre38EventHandler.beforeListenerRegister();
        }

        @Override
        public void onListenerRegister() {
            this.supportsRepairableNearCache = NearCachedClientMapProxy.this.supportsRepairableNearCache();
            if (this.supportsRepairableNearCache) {
                this.repairingEventHandler.onListenerRegister();
            } else {
                this.pre38EventHandler.onListenerRegister();
            }
        }

        @Override
        public void handle(ClientMessage clientMessage) {
            if (this.supportsRepairableNearCache) {
                this.repairingEventHandler.handle(clientMessage);
            } else {
                this.pre38EventHandler.handle(clientMessage);
            }
        }
    }
}

