/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddMembershipListenerCodec;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.cluster.MemberAttributeOperationType;
import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.instance.AbstractMember;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class ClientMembershipListener
extends ClientAddMembershipListenerCodec.AbstractEventHandler
implements EventHandler<ClientMessage> {
    private static final int INITIAL_MEMBERS_TIMEOUT_SECONDS = 5;
    private final ILogger logger;
    private final Set<Member> members = new LinkedHashSet<Member>();
    private final HazelcastClientInstanceImpl client;
    private final ClientClusterServiceImpl clusterService;
    private final ClientPartitionServiceImpl partitionService;
    private final ClientConnectionManagerImpl connectionManager;
    private volatile CountDownLatch initialListFetchedLatch;

    public ClientMembershipListener(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.logger = client.getLoggingService().getLogger(ClientMembershipListener.class);
        this.connectionManager = (ClientConnectionManagerImpl)client.getConnectionManager();
        this.partitionService = (ClientPartitionServiceImpl)client.getClientPartitionService();
        this.clusterService = (ClientClusterServiceImpl)client.getClientClusterService();
    }

    @Override
    public void handle(Member member, int eventType) {
        switch (eventType) {
            case 1: {
                this.memberAdded(member);
                break;
            }
            case 2: {
                this.memberRemoved(member);
                break;
            }
            default: {
                this.logger.warning("Unknown event type: " + eventType);
            }
        }
        this.partitionService.refreshPartitions();
    }

    @Override
    public void handle(Collection<Member> initialMembers) {
        Map<String, Member> prevMembers = Collections.emptyMap();
        if (!this.members.isEmpty()) {
            prevMembers = new HashMap(this.members.size());
            for (Member member : this.members) {
                prevMembers.put(member.getUuid(), member);
            }
            this.members.clear();
        }
        for (Member initialMember : initialMembers) {
            this.members.add(initialMember);
        }
        if (prevMembers.isEmpty()) {
            this.logger.info(this.membersString());
            this.clusterService.handleInitialMembershipEvent(new InitialMembershipEvent(this.client.getCluster(), Collections.unmodifiableSet(this.members)));
            this.initialListFetchedLatch.countDown();
            return;
        }
        List<MembershipEvent> events = this.detectMembershipEvents(prevMembers);
        this.logger.info(this.membersString());
        this.fireMembershipEvent(events);
        this.initialListFetchedLatch.countDown();
    }

    @Override
    public void handle(String uuid, String key, int opType, String value) {
        Collection<Member> members = this.clusterService.getMemberList();
        for (Member target : members) {
            if (!target.getUuid().equals(uuid)) continue;
            MemberAttributeOperationType operationType = MemberAttributeOperationType.getValue(opType);
            ((AbstractMember)target).updateAttribute(operationType, key, value);
            MemberAttributeEvent memberAttributeEvent = new MemberAttributeEvent(this.client.getCluster(), target, operationType, key, value);
            this.clusterService.fireMemberAttributeEvent(memberAttributeEvent);
            break;
        }
    }

    @Override
    public void beforeListenerRegister() {
    }

    @Override
    public void onListenerRegister() {
    }

    void listenMembershipEvents(Connection ownerConnection) throws Exception {
        this.initialListFetchedLatch = new CountDownLatch(1);
        ClientMessage clientMessage = ClientAddMembershipListenerCodec.encodeRequest(false);
        ClientInvocation invocation = new ClientInvocation(this.client, clientMessage, ownerConnection);
        invocation.setEventHandler(this);
        invocation.invokeUrgent().get();
        this.waitInitialMemberListFetched();
    }

    private void waitInitialMemberListFetched() throws InterruptedException {
        boolean success = this.initialListFetchedLatch.await(5L, TimeUnit.SECONDS);
        if (!success) {
            this.logger.warning("Error while getting initial member list from cluster!");
        }
    }

    private void memberRemoved(Member member) {
        this.members.remove(member);
        this.logger.info(this.membersString());
        Connection connection = this.connectionManager.getActiveConnection(member.getAddress());
        if (connection != null) {
            connection.close(null, this.newTargetDisconnectedExceptionCausedByMemberLeftEvent(connection));
        }
        MembershipEvent event = new MembershipEvent(this.client.getCluster(), member, 2, Collections.unmodifiableSet(this.members));
        this.clusterService.handleMembershipEvent(event);
    }

    private void fireMembershipEvent(List<MembershipEvent> events) {
        for (MembershipEvent event : events) {
            this.clusterService.handleMembershipEvent(event);
        }
    }

    private List<MembershipEvent> detectMembershipEvents(Map<String, Member> prevMembers) {
        LinkedList<MembershipEvent> events = new LinkedList<MembershipEvent>();
        Set<Member> eventMembers = Collections.unmodifiableSet(this.members);
        LinkedList<Member> newMembers = new LinkedList<Member>();
        for (Member member : this.members) {
            Member former = prevMembers.remove(member.getUuid());
            if (former != null) continue;
            newMembers.add(member);
        }
        for (Member member : prevMembers.values()) {
            Connection connection;
            events.add(new MembershipEvent(this.client.getCluster(), member, 2, eventMembers));
            Address address = member.getAddress();
            if (this.clusterService.getMember(address) != null || (connection = this.connectionManager.getActiveConnection(address)) == null) continue;
            connection.close(null, this.newTargetDisconnectedExceptionCausedByMemberLeftEvent(connection));
        }
        for (Member member : newMembers) {
            events.add(new MembershipEvent(this.client.getCluster(), member, 1, eventMembers));
        }
        return events;
    }

    private Exception newTargetDisconnectedExceptionCausedByMemberLeftEvent(Connection connection) {
        return new TargetDisconnectedException("The client has closed the connection to this member, after receiving a member left event from the cluster. " + connection);
    }

    private void memberAdded(Member member) {
        this.members.add(member);
        this.logger.info(this.membersString());
        MembershipEvent event = new MembershipEvent(this.client.getCluster(), member, 1, Collections.unmodifiableSet(this.members));
        this.clusterService.handleMembershipEvent(event);
    }

    private String membersString() {
        StringBuilder sb = new StringBuilder("\n\nMembers [");
        sb.append(this.members.size());
        sb.append("] {");
        for (Member member : this.members) {
            sb.append("\n\t").append(member);
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    public String toString() {
        return "ClientMembershipListener{, members=" + this.members + ", client=" + this.client + '}';
    }
}

