/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.ConfigDataSerializerHook;
import com.hazelcast.config.SemaphoreConfigReadOnly;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.Preconditions;
import java.io.IOException;

public class SemaphoreConfig
implements IdentifiedDataSerializable {
    public static final int DEFAULT_SYNC_BACKUP_COUNT = 1;
    public static final int DEFAULT_ASYNC_BACKUP_COUNT = 0;
    private String name;
    private int initialPermits;
    private int backupCount = 1;
    private int asyncBackupCount = 0;
    private transient SemaphoreConfigReadOnly readOnly;

    public SemaphoreConfig() {
    }

    public SemaphoreConfig(SemaphoreConfig config) {
        Preconditions.isNotNull(config, "config");
        this.name = config.getName();
        this.initialPermits = config.getInitialPermits();
        this.backupCount = config.getBackupCount();
        this.asyncBackupCount = config.getAsyncBackupCount();
    }

    public SemaphoreConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new SemaphoreConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public String getName() {
        return this.name;
    }

    public SemaphoreConfig setName(String name) {
        this.name = Preconditions.checkHasText(name, "name must contain text");
        return this;
    }

    public int getInitialPermits() {
        return this.initialPermits;
    }

    public SemaphoreConfig setInitialPermits(int initialPermits) {
        this.initialPermits = initialPermits;
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public SemaphoreConfig setBackupCount(int backupCount) {
        this.backupCount = Preconditions.checkBackupCount(backupCount, this.asyncBackupCount);
        return this;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public SemaphoreConfig setAsyncBackupCount(int asyncBackupCount) {
        this.asyncBackupCount = Preconditions.checkAsyncBackupCount(this.backupCount, asyncBackupCount);
        return this;
    }

    public int getTotalBackupCount() {
        return this.asyncBackupCount + this.backupCount;
    }

    public String toString() {
        return "SemaphoreConfig{name='" + this.name + '\'' + ", initialPermits=" + this.initialPermits + ", backupCount=" + this.backupCount + ", asyncBackupCount=" + this.asyncBackupCount + '}';
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 33;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.initialPermits);
        out.writeInt(this.backupCount);
        out.writeInt(this.asyncBackupCount);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.initialPermits = in.readInt();
        this.backupCount = in.readInt();
        this.asyncBackupCount = in.readInt();
    }
}

