/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.cluster.Joiner;
import com.hazelcast.instance.AddressPicker;
import com.hazelcast.instance.DefaultAddressPicker;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeContext;
import com.hazelcast.instance.NodeExtension;
import com.hazelcast.instance.NodeExtensionFactory;
import com.hazelcast.internal.networking.EventLoopGroup;
import com.hazelcast.internal.networking.nio.NioEventLoopGroup;
import com.hazelcast.internal.networking.spinning.SpinningEventLoopGroup;
import com.hazelcast.logging.LoggingServiceImpl;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.NodeIOService;
import com.hazelcast.nio.tcp.MemberChannelInitializer;
import com.hazelcast.nio.tcp.TcpIpConnectionChannelErrorHandler;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import com.hazelcast.spi.annotation.PrivateApi;
import java.nio.channels.ServerSocketChannel;

@PrivateApi
public class DefaultNodeContext
implements NodeContext {
    @Override
    public NodeExtension createNodeExtension(Node node) {
        return NodeExtensionFactory.create(node);
    }

    @Override
    public AddressPicker createAddressPicker(Node node) {
        return new DefaultAddressPicker(node.getConfig(), node.getProperties(), node.getLogger(AddressPicker.class));
    }

    @Override
    public Joiner createJoiner(Node node) {
        return node.createJoiner();
    }

    @Override
    public ConnectionManager createConnectionManager(Node node, ServerSocketChannel serverSocketChannel) {
        NodeIOService ioService = new NodeIOService(node, node.nodeEngine);
        EventLoopGroup eventLoopGroup = this.createEventLoopGroup(node, ioService);
        return new TcpIpConnectionManager(ioService, serverSocketChannel, node.loggingService, node.nodeEngine.getMetricsRegistry(), eventLoopGroup);
    }

    private EventLoopGroup createEventLoopGroup(Node node, NodeIOService ioService) {
        boolean spinning = Boolean.getBoolean("hazelcast.io.spinning");
        LoggingServiceImpl loggingService = node.loggingService;
        MemberChannelInitializer initializer = new MemberChannelInitializer(loggingService.getLogger(MemberChannelInitializer.class), ioService);
        TcpIpConnectionChannelErrorHandler exceptionHandler = new TcpIpConnectionChannelErrorHandler(loggingService.getLogger(TcpIpConnectionChannelErrorHandler.class));
        if (spinning) {
            return new SpinningEventLoopGroup(loggingService, node.nodeEngine.getMetricsRegistry(), exceptionHandler, initializer, node.hazelcastInstance.getName());
        }
        return new NioEventLoopGroup(loggingService, node.nodeEngine.getMetricsRegistry(), node.hazelcastInstance.getName(), exceptionHandler, ioService.getInputSelectorThreadCount(), ioService.getOutputSelectorThreadCount(), ioService.getBalancerIntervalSeconds(), initializer);
    }
}

