/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.cluster.impl.ClusterHeartbeatManager;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.MemberMap;
import com.hazelcast.internal.cluster.impl.MembershipManager;
import com.hazelcast.internal.cluster.impl.operations.MemberRemoveOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;

@Deprecated
public class MembershipManagerCompat {
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final ClusterServiceImpl clusterService;
    private final MembershipManager membershipManager;
    private final Lock clusterServiceLock;
    private final ILogger logger;

    MembershipManagerCompat(Node node, ClusterServiceImpl clusterService, Lock clusterServiceLock) {
        this.node = node;
        this.clusterService = clusterService;
        this.clusterServiceLock = clusterServiceLock;
        this.nodeEngine = node.getNodeEngine();
        this.membershipManager = clusterService.getMembershipManager();
        this.logger = node.getLogger(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(Address deadAddress, String uuid, String reason) {
        if (this.clusterService.getClusterVersion().isGreaterOrEqual(Versions.V3_9)) {
            throw new IllegalStateException("Should not be called on versions 3.9+");
        }
        if (!this.ensureMemberIsRemovable(deadAddress)) {
            return;
        }
        this.clusterServiceLock.lock();
        try {
            Connection conn;
            if (!this.clusterService.isJoined()) {
                this.logger.fine("Cannot remove " + deadAddress + " with uuid: " + uuid + " because this node is not joined...");
                return;
            }
            MemberImpl member = this.membershipManager.getMember(deadAddress);
            if (member == null || uuid != null && !uuid.equals(member.getUuid())) {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Cannot remove " + deadAddress + ", either member is not present " + "or uuid is not matching. Uuid: " + uuid + ", member: " + member);
                }
                return;
            }
            if (deadAddress.equals(this.clusterService.getMasterAddress())) {
                this.assignNewMaster();
            }
            if (this.clusterService.isMaster()) {
                this.clusterService.getClusterJoinManager().removeJoin(deadAddress);
            }
            if ((conn = this.node.connectionManager.getConnection(deadAddress)) != null) {
                conn.close(reason, null);
            }
            this.removeMember(member);
            this.clusterService.printMemberList();
        }
        finally {
            this.clusterServiceLock.unlock();
        }
    }

    private void assignNewMaster() {
        Address oldMasterAddress = this.clusterService.getMasterAddress();
        if (this.clusterService.isJoined()) {
            Collection<MemberImpl> members = this.membershipManager.getMembers();
            Member newMaster = null;
            int size = members.size();
            if (size > 1) {
                Iterator<MemberImpl> iterator = members.iterator();
                Member member = iterator.next();
                if (member.getAddress().equals(oldMasterAddress)) {
                    newMaster = iterator.next();
                } else {
                    this.logger.severe(String.format("Old master %s is dead, but the first of member list is a different member %s!", oldMasterAddress, member));
                    newMaster = member;
                }
            } else {
                this.logger.warning(String.format("Old master %s is dead and this node is not master, but member list contains only %d members: %s", oldMasterAddress, size, members));
            }
            this.logger.info(String.format("Old master %s left the cluster, assigning new master %s", oldMasterAddress, newMaster));
            if (newMaster != null) {
                this.clusterService.setMasterAddress(newMaster.getAddress());
            } else {
                this.clusterService.setMasterAddress(null);
            }
        } else {
            this.clusterService.setMasterAddress(null);
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine(String.format("Old master: %s, new master: %s ", oldMasterAddress, this.clusterService.getMasterAddress()));
        }
        ClusterHeartbeatManager clusterHeartbeatManager = this.clusterService.getClusterHeartbeatManager();
        if (this.clusterService.isMaster()) {
            clusterHeartbeatManager.resetMemberMasterConfirmations();
        } else {
            clusterHeartbeatManager.sendMasterConfirmation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMember(MemberImpl deadMember) {
        assert (this.clusterService.getClusterVersion().isLessThan(Versions.V3_9));
        this.logger.info("Removing " + deadMember);
        this.clusterServiceLock.lock();
        try {
            ClusterHeartbeatManager clusterHeartbeatManager = this.clusterService.getClusterHeartbeatManager();
            MemberMap currentMembers = this.membershipManager.getMemberMap();
            if (currentMembers.contains(deadMember.getAddress())) {
                clusterHeartbeatManager.removeMember(deadMember);
                MemberMap newMembers = MemberMap.cloneExcluding(currentMembers, deadMember);
                this.membershipManager.setMembers(newMembers);
                if (this.clusterService.isMaster()) {
                    if (this.logger.isFineEnabled()) {
                        this.logger.fine(deadMember + " is dead, sending remove to all other members...");
                    }
                    this.sendMemberRemoveOperation(deadMember);
                }
                this.membershipManager.handleMemberRemove(newMembers, deadMember);
            }
        }
        finally {
            this.clusterServiceLock.unlock();
        }
    }

    private void sendMemberRemoveOperation(Member deadMember) {
        for (Member member : this.membershipManager.getMembers()) {
            Address address = member.getAddress();
            if (this.node.getThisAddress().equals(address) || address.equals(deadMember.getAddress())) continue;
            MemberRemoveOperation op = new MemberRemoveOperation(deadMember.getAddress(), deadMember.getUuid());
            this.nodeEngine.getOperationService().send(op, address);
        }
    }

    private boolean ensureMemberIsRemovable(Address deadAddress) {
        return this.clusterService.isJoined() && !deadAddress.equals(this.node.getThisAddress());
    }
}

