/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl.operations;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.core.Member;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.MembersView;
import com.hazelcast.internal.cluster.impl.operations.MembersUpdateOp;
import com.hazelcast.internal.cluster.impl.operations.PostJoinOp;
import com.hazelcast.internal.partition.PartitionRuntimeState;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.OperationResponseHandlerFactory;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.version.Version;
import java.io.IOException;
import java.util.Set;

public class FinalizeJoinOp
extends MembersUpdateOp {
    private PostJoinOp postJoinOp;
    private String clusterId;
    private long clusterStartTime;
    private ClusterState clusterState;
    private Version clusterVersion;
    private transient boolean finalized;

    public FinalizeJoinOp() {
    }

    public FinalizeJoinOp(String targetUuid, MembersView members, PostJoinOp postJoinOp, long masterTime, String clusterId, long clusterStartTime, ClusterState clusterState, Version clusterVersion, PartitionRuntimeState partitionRuntimeState, boolean sendResponse) {
        super(targetUuid, members, masterTime, partitionRuntimeState, sendResponse);
        this.postJoinOp = postJoinOp;
        this.clusterId = clusterId;
        this.clusterStartTime = clusterStartTime;
        this.clusterState = clusterState;
        this.clusterVersion = clusterVersion;
    }

    @Override
    public void run() throws Exception {
        this.checkLocalMemberUuid();
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        Address callerAddress = this.getConnectionEndpointOrThisAddress();
        String callerUuid = this.getCallerUuid();
        this.finalized = clusterService.finalizeJoin(this.getMembersView(), callerAddress, callerUuid, this.clusterId, this.clusterState, this.clusterVersion, this.clusterStartTime, this.masterTime);
        if (!this.finalized) {
            return;
        }
        this.processPartitionState();
    }

    @Override
    public void afterRun() throws Exception {
        super.afterRun();
        if (!this.finalized) {
            return;
        }
        this.sendPostJoinOperations();
        this.runPostJoinOp();
    }

    private void runPostJoinOp() {
        if (this.postJoinOp == null) {
            return;
        }
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        NodeEngineImpl nodeEngine = clusterService.getNodeEngine();
        InternalOperationService operationService = nodeEngine.getOperationService();
        this.postJoinOp.setNodeEngine(nodeEngine);
        OperationAccessor.setCallerAddress(this.postJoinOp, this.getCallerAddress());
        OperationAccessor.setConnection(this.postJoinOp, this.getConnection());
        this.postJoinOp.setOperationResponseHandler(OperationResponseHandlerFactory.createEmptyResponseHandler());
        operationService.run(this.postJoinOp);
    }

    private void sendPostJoinOperations() {
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        NodeEngineImpl nodeEngine = clusterService.getNodeEngine();
        Operation[] postJoinOperations = nodeEngine.getPostJoinOperations();
        if (postJoinOperations != null && postJoinOperations.length > 0) {
            InternalOperationService operationService = nodeEngine.getOperationService();
            Set<Member> members = clusterService.getMembers();
            for (Member member : members) {
                if (member.localMember()) continue;
                PostJoinOp operation = new PostJoinOp(postJoinOperations);
                operationService.invokeOnTarget("hz:core:clusterService", operation, member.getAddress());
            }
        }
    }

    @Override
    protected void writeInternalImpl(ObjectDataOutput out) throws IOException {
        super.writeInternalImpl(out);
        boolean hasPJOp = this.postJoinOp != null;
        out.writeBoolean(hasPJOp);
        if (hasPJOp) {
            this.postJoinOp.writeData(out);
        }
        out.writeUTF(this.clusterId);
        out.writeLong(this.clusterStartTime);
        out.writeUTF(this.clusterState.toString());
        out.writeObject(this.clusterVersion);
    }

    @Override
    protected void readInternalImpl(ObjectDataInput in) throws IOException {
        super.readInternalImpl(in);
        boolean hasPJOp = in.readBoolean();
        if (hasPJOp) {
            this.postJoinOp = new PostJoinOp();
            this.postJoinOp.readData(in);
        }
        this.clusterId = in.readUTF();
        this.clusterStartTime = in.readLong();
        String stateName = in.readUTF();
        this.clusterState = ClusterState.valueOf(stateName);
        this.clusterVersion = (Version)in.readObject();
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", postJoinOp=").append(this.postJoinOp);
    }

    @Override
    public int getId() {
        return 7;
    }
}

